/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.Wss10;

public class Wss11
extends Wss10 {
    private boolean MustSupportRefThumbprint;
    private boolean MustSupportRefEncryptedKey;
    private boolean RequireSignatureConfirmation;

    public boolean isMustSupportRefEncryptedKey() {
        return this.MustSupportRefEncryptedKey;
    }

    public void setMustSupportRefEncryptedKey(boolean mustSupportRefEncryptedKey) {
        this.MustSupportRefEncryptedKey = mustSupportRefEncryptedKey;
    }

    public boolean isMustSupportRefThumbprint() {
        return this.MustSupportRefThumbprint;
    }

    public void setMustSupportRefThumbprint(boolean mustSupportRefThumbprint) {
        this.MustSupportRefThumbprint = mustSupportRefThumbprint;
    }

    public boolean isRequireSignatureConfirmation() {
        return this.RequireSignatureConfirmation;
    }

    public void setRequireSignatureConfirmation(boolean requireSignatureConfirmation) {
        this.RequireSignatureConfirmation = requireSignatureConfirmation;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localname = Constants.WSS11.getLocalPart();
        String namespaceURI = Constants.WSS11.getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = Constants.WSS11.getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String pPrefix = writer.getPrefix(Constants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            writer.setPrefix(Constants.POLICY.getPrefix(), Constants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(prefix, Constants.POLICY.getLocalPart(), Constants.POLICY.getNamespaceURI());
        if (this.isMustSupportRefKeyIdentifier()) {
            writer.writeStartElement(prefix, Constants.MUST_SUPPORT_REF_KEY_IDENTIFIER.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefIssuerSerial()) {
            writer.writeStartElement(prefix, Constants.MUST_SUPPORT_REF_ISSUER_SERIAL.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefExternalURI()) {
            writer.writeStartElement(prefix, Constants.MUST_SUPPORT_REF_EXTERNAL_URI.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefEmbeddedToken()) {
            writer.writeStartElement(prefix, Constants.MUST_SUPPORT_REF_EMBEDDED_TOKEN.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefThumbprint()) {
            writer.writeStartElement(prefix, Constants.MUST_SUPPORT_REF_THUMBPRINT.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefEncryptedKey()) {
            writer.writeStartElement(prefix, Constants.MUST_SUPPORT_REF_ENCRYPTED_KEY.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.isRequireSignatureConfirmation()) {
            writer.writeStartElement(prefix, Constants.REQUIRE_SIGNATURE_CONFIRMATION.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

