/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;

public class Wss10
extends AbstractSecurityAssertion {
    private boolean mustSupportRefKeyIdentifier;
    private boolean MustSupportRefIssuerSerial;
    private boolean MustSupportRefExternalURI;
    private boolean MustSupportRefEmbeddedToken;

    public boolean isMustSupportRefEmbeddedToken() {
        return this.MustSupportRefEmbeddedToken;
    }

    public void setMustSupportRefEmbeddedToken(boolean mustSupportRefEmbeddedToken) {
        this.MustSupportRefEmbeddedToken = mustSupportRefEmbeddedToken;
    }

    public boolean isMustSupportRefExternalURI() {
        return this.MustSupportRefExternalURI;
    }

    public void setMustSupportRefExternalURI(boolean mustSupportRefExternalURI) {
        this.MustSupportRefExternalURI = mustSupportRefExternalURI;
    }

    public boolean isMustSupportRefIssuerSerial() {
        return this.MustSupportRefIssuerSerial;
    }

    public void setMustSupportRefIssuerSerial(boolean mustSupportRefIssuerSerial) {
        this.MustSupportRefIssuerSerial = mustSupportRefIssuerSerial;
    }

    public boolean isMustSupportRefKeyIdentifier() {
        return this.mustSupportRefKeyIdentifier;
    }

    public void setMustSupportRefKeyIdentifier(boolean mustSupportRefKeyIdentifier) {
        this.mustSupportRefKeyIdentifier = mustSupportRefKeyIdentifier;
    }

    public QName getName() {
        return Constants.WSS10;
    }

    public PolicyComponent normalize() {
        return this;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localname = Constants.WSS10.getLocalPart();
        String namespaceURI = Constants.WSS10.getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = Constants.WSS10.getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String pPrefix = writer.getPrefix(Constants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            writer.setPrefix(Constants.POLICY.getPrefix(), Constants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(prefix, Constants.POLICY.getLocalPart(), Constants.POLICY.getNamespaceURI());
        if (this.isMustSupportRefKeyIdentifier()) {
            writer.writeStartElement(prefix, Constants.MUST_SUPPORT_REF_KEY_IDENTIFIER.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefIssuerSerial()) {
            writer.writeStartElement(prefix, Constants.MUST_SUPPORT_REF_ISSUER_SERIAL.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefExternalURI()) {
            writer.writeStartElement(prefix, Constants.MUST_SUPPORT_REF_EXTERNAL_URI.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.isMustSupportRefEmbeddedToken()) {
            writer.writeStartElement(prefix, Constants.MUST_SUPPORT_REF_EMBEDDED_TOKEN.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

