/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.Binding;
import org.apache.ws.secpolicy.model.Layout;
import org.apache.ws.secpolicy.model.TransportToken;

public class TransportBinding
extends Binding {
    private TransportToken transportToken;
    private List transportBindings;

    public TransportToken getTransportToken() {
        return this.transportToken;
    }

    public void setTransportToken(TransportToken transportToken) {
        this.transportToken = transportToken;
    }

    public List getConfigurations() {
        return this.transportBindings;
    }

    public TransportBinding getDefaultConfiguration() {
        if (this.transportBindings != null) {
            return (TransportBinding)this.transportBindings.get(0);
        }
        return null;
    }

    public void addConfiguration(TransportBinding transportBinding) {
        if (this.transportBindings == null) {
            this.transportBindings = new ArrayList();
        }
        this.transportBindings.add(transportBinding);
    }

    public QName getName() {
        return Constants.TRANSPORT_BINDING;
    }

    public PolicyComponent normalize() {
        if (this.isNormalized()) {
            return this;
        }
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        List configurations = algorithmSuite.getConfigurations();
        if (configurations != null && configurations.size() == 1) {
            this.setNormalized(true);
            return this;
        }
        Policy policy = new Policy();
        ExactlyOne exactlyOne = new ExactlyOne();
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            All wrapper = new All();
            TransportBinding transportBinding = new TransportBinding();
            algorithmSuite = (AlgorithmSuite)iterator.next();
            transportBinding.setAlgorithmSuite(algorithmSuite);
            transportBinding.setIncludeTimestamp(this.isIncludeTimestamp());
            transportBinding.setLayout(this.getLayout());
            transportBinding.setSignedEndorsingSupportingTokens(this.getSignedEndorsingSupportingTokens());
            transportBinding.setSignedSupportingToken(this.getSignedSupportingToken());
            transportBinding.setTransportToken(this.getTransportToken());
            wrapper.addPolicyComponent((PolicyComponent)transportBinding);
            exactlyOne.addPolicyComponent((PolicyComponent)wrapper);
        }
        policy.addPolicyComponent((PolicyComponent)exactlyOne);
        return policy;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = Constants.TRANSPORT_BINDING.getLocalPart();
        String namespaceURI = Constants.TRANSPORT_BINDING.getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = Constants.TRANSPORT_BINDING.getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String pPrefix = writer.getPrefix(Constants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            pPrefix = Constants.POLICY.getPrefix();
            writer.setPrefix(pPrefix, Constants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, Constants.POLICY.getLocalPart(), Constants.POLICY.getNamespaceURI());
        if (this.transportToken == null) {
            throw new RuntimeException("no TransportToken found");
        }
        this.transportToken.serialize(writer);
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        if (algorithmSuite == null) {
            throw new RuntimeException("no AlgorithmSuite found");
        }
        algorithmSuite.serialize(writer);
        Layout layout = this.getLayout();
        if (layout != null) {
            layout.serialize(writer);
        }
        if (this.isIncludeTimestamp()) {
            writer.writeStartElement(Constants.INCLUDE_TIMESTAMP.getPrefix(), Constants.INCLUDE_TIMESTAMP.getLocalPart(), Constants.INCLUDE_TIMESTAMP.getNamespaceURI());
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

