/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.EncryptionToken;
import org.apache.ws.secpolicy.model.Layout;
import org.apache.ws.secpolicy.model.ProtectionToken;
import org.apache.ws.secpolicy.model.SignatureToken;
import org.apache.ws.secpolicy.model.SymmetricAsymmetricBindingBase;

public class SymmetricBinding
extends SymmetricAsymmetricBindingBase {
    private EncryptionToken encryptionToken;
    private SignatureToken signatureToken;
    private ProtectionToken protectionToken;

    public EncryptionToken getEncryptionToken() {
        return this.encryptionToken;
    }

    public void setEncryptionToken(EncryptionToken encryptionToken) {
        if (this.protectionToken != null) {
            // empty if block
        }
        this.encryptionToken = encryptionToken;
    }

    public ProtectionToken getProtectionToken() {
        return this.protectionToken;
    }

    public void setProtectionToken(ProtectionToken protectionToken) {
        if (this.encryptionToken != null || this.signatureToken != null) {
            // empty if block
        }
        this.protectionToken = protectionToken;
    }

    public SignatureToken getSignatureToken() {
        return this.signatureToken;
    }

    public void setSignatureToken(SignatureToken signatureToken) {
        if (this.protectionToken != null) {
            // empty if block
        }
        this.signatureToken = signatureToken;
    }

    public QName getName() {
        return Constants.SYMMETRIC_BINDING;
    }

    public PolicyComponent normalize() {
        if (this.isNormalized()) {
            return this;
        }
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        List configurations = algorithmSuite.getConfigurations();
        if (configurations == null && configurations.size() == 1) {
            this.setNormalized(true);
            return this;
        }
        Policy policy = new Policy();
        ExactlyOne exactlyOne = new ExactlyOne();
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            All wrapper = new All();
            SymmetricBinding symmetricBinding = new SymmetricBinding();
            algorithmSuite = (AlgorithmSuite)iterator.next();
            symmetricBinding.setAlgorithmSuite(algorithmSuite);
            symmetricBinding.setEncryptionToken(this.getEncryptionToken());
            symmetricBinding.setEntireHeadersAndBodySignatures(this.isEntireHeadersAndBodySignatures());
            symmetricBinding.setIncludeTimestamp(this.isIncludeTimestamp());
            symmetricBinding.setLayout(this.getLayout());
            symmetricBinding.setProtectionOrder(this.getProtectionOrder());
            symmetricBinding.setProtectionToken(this.getProtectionToken());
            symmetricBinding.setSignatureProtection(this.isSignatureProtection());
            symmetricBinding.setSignatureToken(this.getSignatureToken());
            symmetricBinding.setSignedEndorsingSupportingTokens(this.getSignedEndorsingSupportingTokens());
            symmetricBinding.setSignedSupportingToken(this.getSignedSupportingToken());
            symmetricBinding.setTokenProtection(this.isTokenProtection());
            symmetricBinding.setNormalized(true);
            wrapper.addPolicyComponent((PolicyComponent)symmetricBinding);
            exactlyOne.addPolicyComponent((PolicyComponent)wrapper);
        }
        policy.addPolicyComponent((PolicyComponent)exactlyOne);
        return policy;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String wspPrefix;
        String prefix;
        String localname = Constants.SYMMETRIC_BINDING.getLocalPart();
        String namespaceURI = Constants.SYMMETRIC_BINDING.getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = Constants.SYMMETRIC_BINDING.getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        if (writerPrefix == null) {
            writer.writeNamespace(prefix, namespaceURI);
        }
        String policyLocalName = Constants.POLICY.getLocalPart();
        String policyNamespaceURI = Constants.POLICY.getNamespaceURI();
        String wspWriterPrefix = writer.getPrefix(policyNamespaceURI);
        if (wspWriterPrefix == null) {
            wspPrefix = Constants.POLICY.getPrefix();
            writer.setPrefix(wspPrefix, policyNamespaceURI);
        } else {
            wspPrefix = wspWriterPrefix;
        }
        writer.writeStartElement(wspPrefix, policyLocalName, policyNamespaceURI);
        if (this.protectionToken != null) {
            this.protectionToken.serialize(writer);
        } else if (this.encryptionToken != null && this.signatureToken != null) {
            this.encryptionToken.serialize(writer);
            this.signatureToken.serialize(writer);
        } else {
            throw new RuntimeException("Either (EncryptionToken and SignatureToken) or ProtectionToken must be set");
        }
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        if (algorithmSuite == null) {
            throw new RuntimeException("AlgorithmSuite must be set");
        }
        algorithmSuite.serialize(writer);
        Layout layout = this.getLayout();
        if (layout != null) {
            layout.serialize(writer);
        }
        if (this.isIncludeTimestamp()) {
            writer.writeStartElement(prefix, Constants.INCLUDE_TIMESTAMP.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if ("EncryptBeforeSigning".equals(this.getProtectionOrder())) {
            writer.writeStartElement(prefix, "EncryptBeforeSigning", namespaceURI);
            writer.writeEndElement();
        } else if ("SignBeforeEncrypting".equals(this.getProtectionOrder())) {
            writer.writeStartElement(prefix, "SignBeforeEncrypting", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isSignatureProtection()) {
            writer.writeStartElement(prefix, Constants.ENCRYPT_SIGNATURE.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.isEntireHeadersAndBodySignatures()) {
            writer.writeStartElement(prefix, "OnlySignEntireHeadersAndBody", namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

