/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.AbstractSecurityAssertion;

public class Layout
extends AbstractSecurityAssertion {
    private String value = "Lax";

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if ("Lax".equals(value) || "Strict".equals(value) || "LaxTimestampFirst".equals(value) || "LaxTimestampLast".equals(value)) {
            this.value = value;
        }
    }

    public QName getName() {
        return Constants.LAYOUT;
    }

    public PolicyComponent normalize() {
        throw new UnsupportedOperationException();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = Constants.LAYOUT.getLocalPart();
        String namespaceURI = Constants.LAYOUT.getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = Constants.LAYOUT.getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        writer.writeStartElement(Constants.POLICY.getPrefix(), Constants.POLICY.getLocalPart(), Constants.POLICY.getNamespaceURI());
        if ("Strict".equals(this.value)) {
            writer.writeStartElement(prefix, Constants.STRICT.getLocalPart(), namespaceURI);
        } else if ("Lax".equals(this.value)) {
            writer.writeStartElement(prefix, Constants.LAX.getLocalPart(), namespaceURI);
        } else if ("LaxTimestampFirst".equals(this.value)) {
            writer.writeStartElement(prefix, Constants.LAXTSFIRST.getLocalPart(), namespaceURI);
        } else if ("LaxTimestampLast".equals(this.value)) {
            writer.writeStartElement(prefix, Constants.LAXTSLAST.getLocalPart(), namespaceURI);
        }
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

