/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.Token;

public class IssuedToken
extends Token {
    private OMElement issuerEpr;
    private OMElement rstTemplate;
    boolean requireExternalReference;
    boolean requireInternalReference;

    public OMElement getIssuerEpr() {
        return this.issuerEpr;
    }

    public void setIssuerEpr(OMElement issuerEpr) {
        this.issuerEpr = issuerEpr;
    }

    public boolean isRequireExternalReference() {
        return this.requireExternalReference;
    }

    public void setRequireExternalReference(boolean requireExternalReference) {
        this.requireExternalReference = requireExternalReference;
    }

    public boolean isRequireInternalReference() {
        return this.requireInternalReference;
    }

    public void setRequireInternalReference(boolean requireInternalReference) {
        this.requireInternalReference = requireInternalReference;
    }

    public OMElement getRstTemplate() {
        return this.rstTemplate;
    }

    public void setRstTemplate(OMElement rstTemplate) {
        this.rstTemplate = rstTemplate;
    }

    public QName getName() {
        return Constants.ISSUED_TOKEN;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String wspPrefix;
        String inclusion;
        String prefix;
        String localname = Constants.ISSUED_TOKEN.getLocalPart();
        String namespaceURI = Constants.ISSUED_TOKEN.getNamespaceURI();
        String writerPrefix = writer.getPrefix(namespaceURI);
        if (writerPrefix == null) {
            prefix = Constants.ISSUED_TOKEN.getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        } else {
            prefix = writerPrefix;
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        if (writerPrefix == null) {
            writer.writeNamespace(prefix, namespaceURI);
        }
        if ((inclusion = this.getInclusion()) != null) {
            writer.writeAttribute(prefix, namespaceURI, "IncludeToken", inclusion);
        }
        if (this.issuerEpr != null) {
            writer.writeStartElement(prefix, Constants.ISSUER.getLocalPart(), namespaceURI);
            this.issuerEpr.serialize(writer);
            writer.writeEndElement();
        }
        if (this.rstTemplate != null) {
            writer.writeStartElement(prefix, Constants.REQUEST_SECURITY_TOKEN_TEMPLATE.getLocalPart(), namespaceURI);
            this.rstTemplate.serialize(writer);
            writer.writeEndElement();
        }
        String policyLocalName = Constants.PROTECTION_TOKEN.getLocalPart();
        String policyNamespaceURI = Constants.PROTECTION_TOKEN.getNamespaceURI();
        String wspWriterPrefix = writer.getPrefix(policyNamespaceURI);
        if (wspWriterPrefix == null) {
            wspPrefix = Constants.PROTECTION_TOKEN.getPrefix();
            writer.setPrefix(wspPrefix, policyNamespaceURI);
        } else {
            wspPrefix = wspWriterPrefix;
        }
        if (this.isRequireExternalReference() || this.isRequireInternalReference()) {
            writer.writeStartElement(wspPrefix, policyLocalName, policyNamespaceURI);
            if (wspWriterPrefix == null) {
                writer.writeNamespace(wspPrefix, policyNamespaceURI);
            }
            if (this.isRequireExternalReference()) {
                writer.writeEmptyElement(prefix, Constants.REQUIRE_EXTERNAL_REFERNCE.getLocalPart(), namespaceURI);
            }
            if (this.isRequireInternalReference()) {
                writer.writeEmptyElement(prefix, Constants.REQUIRE_INTERNAL_REFERNCE.getLocalPart(), namespaceURI);
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

