/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.All;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.InitiatorToken;
import org.apache.ws.secpolicy.model.Layout;
import org.apache.ws.secpolicy.model.RecipientToken;
import org.apache.ws.secpolicy.model.SymmetricAsymmetricBindingBase;

public class AsymmetricBinding
extends SymmetricAsymmetricBindingBase {
    private InitiatorToken initiatorToken;
    private RecipientToken recipientToken;

    public InitiatorToken getInitiatorToken() {
        return this.initiatorToken;
    }

    public void setInitiatorToken(InitiatorToken initiatorToken) {
        this.initiatorToken = initiatorToken;
    }

    public RecipientToken getRecipientToken() {
        return this.recipientToken;
    }

    public void setRecipientToken(RecipientToken recipientToken) {
        this.recipientToken = recipientToken;
    }

    public QName getName() {
        return Constants.ASYMMETRIC_BINDING;
    }

    public PolicyComponent normalize() {
        if (this.isNormalized()) {
            return this;
        }
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        List configs = algorithmSuite.getConfigurations();
        Policy policy = new Policy();
        ExactlyOne exactlyOne = new ExactlyOne();
        policy.addPolicyComponent((PolicyComponent)exactlyOne);
        Iterator iterator = configs.iterator();
        while (iterator.hasNext()) {
            All wrapper = new All();
            AsymmetricBinding asymmetricBinding = new AsymmetricBinding();
            asymmetricBinding.setAlgorithmSuite((AlgorithmSuite)iterator.next());
            asymmetricBinding.setEntireHeadersAndBodySignatures(this.isEntireHeadersAndBodySignatures());
            asymmetricBinding.setIncludeTimestamp(this.isIncludeTimestamp());
            asymmetricBinding.setInitiatorToken(this.getInitiatorToken());
            asymmetricBinding.setLayout(this.getLayout());
            asymmetricBinding.setProtectionOrder(this.getProtectionOrder());
            asymmetricBinding.setRecipientToken(this.getRecipientToken());
            asymmetricBinding.setSignatureProtection(this.isSignatureProtection());
            asymmetricBinding.setSignedEndorsingSupportingTokens(this.getSignedEndorsingSupportingTokens());
            asymmetricBinding.setTokenProtection(this.isTokenProtection());
            asymmetricBinding.setNormalized(true);
            wrapper.addPolicyComponent((PolicyComponent)wrapper);
        }
        return policy;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localname = Constants.ASYMMETRIC_BINDING.getLocalPart();
        String namespaceURI = Constants.ASYMMETRIC_BINDING.getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = Constants.ASYMMETRIC_BINDING.getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String pPrefix = writer.getPrefix(Constants.POLICY.getNamespaceURI());
        if (pPrefix == null) {
            pPrefix = Constants.POLICY.getPrefix();
            writer.setPrefix(pPrefix, Constants.POLICY.getNamespaceURI());
        }
        writer.writeStartElement(pPrefix, Constants.POLICY.getLocalPart(), Constants.POLICY.getNamespaceURI());
        if (this.initiatorToken == null) {
            throw new RuntimeException("InitiatorToken is not set");
        }
        this.initiatorToken.serialize(writer);
        if (this.recipientToken == null) {
            throw new RuntimeException("RecipientToken is not set");
        }
        this.recipientToken.serialize(writer);
        AlgorithmSuite algorithmSuite = this.getAlgorithmSuite();
        if (algorithmSuite == null) {
            throw new RuntimeException("AlgorithmSuite is not set");
        }
        algorithmSuite.serialize(writer);
        Layout layout = this.getLayout();
        if (layout != null) {
            layout.serialize(writer);
        }
        if (this.isIncludeTimestamp()) {
            writer.writeStartElement(Constants.INCLUDE_TIMESTAMP.getPrefix(), Constants.INCLUDE_TIMESTAMP.getLocalPart(), Constants.INCLUDE_TIMESTAMP.getNamespaceURI());
            writer.writeEndElement();
        }
        if ("EncryptBeforeSigning".equals(this.getProtectionOrder())) {
            writer.writeStartElement(prefix, "EncryptBeforeSigning", namespaceURI);
            writer.writeEndElement();
        }
        if (this.isSignatureProtection()) {
            writer.writeStartElement(prefix, Constants.ENCRYPT_SIGNATURE.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.isTokenProtection()) {
            writer.writeStartElement(prefix, Constants.PROTECT_TOKENS.getLocalPart(), namespaceURI);
            writer.writeEndElement();
        }
        if (this.isEntireHeadersAndBodySignatures()) {
            writer.writeStartElement(prefix, "OnlySignEntireHeadersAndBody", namespaceURI);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

