/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.Wss10;

public class WSS10Builder
implements AssertionBuilder {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        Wss10 wss10 = new Wss10();
        Policy policy = PolicyEngine.getPolicy((OMElement)element.getFirstElement());
        Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), wss10);
        }
        return wss10;
    }

    public QName[] getKnownElements() {
        return new QName[]{Constants.WSS10};
    }

    private void processAlternative(List assertions, Wss10 parent) {
        Iterator iterator = assertions.iterator();
        while (iterator.hasNext()) {
            Assertion assertion = (Assertion)iterator.next();
            QName name = assertion.getName();
            if (Constants.MUST_SUPPORT_REF_KEY_IDENTIFIER.equals(name)) {
                parent.setMustSupportRefKeyIdentifier(true);
                continue;
            }
            if (Constants.MUST_SUPPORT_REF_ISSUER_SERIAL.equals(name)) {
                parent.setMustSupportRefIssuerSerial(true);
                continue;
            }
            if (Constants.MUST_SUPPORT_REF_EXTERNAL_URI.equals(name)) {
                parent.setMustSupportRefExternalURI(true);
                continue;
            }
            if (!Constants.MUST_SUPPORT_REF_EMBEDDED_TOKEN.equals(name)) continue;
            parent.setMustSupportRefEmbeddedToken(true);
        }
    }
}

