/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.Constants;
import org.apache.ws.secpolicy.model.IssuedToken;

public class IssuedTokenBuilder
implements AssertionBuilder {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        OMElement policyElement;
        OMElement rstTmplElem;
        IssuedToken issuedToken = new IssuedToken();
        OMElement issuerElem = element.getFirstChildWithName(Constants.ISSUER);
        if (issuerElem != null && issuerElem.getFirstElement() != null) {
            issuedToken.setIssuerEpr(issuerElem.getFirstElement());
        }
        if ((rstTmplElem = element.getFirstChildWithName(Constants.ISSUER)) != null) {
            issuedToken.setIssuerEpr(rstTmplElem);
        }
        if ((policyElement = element.getFirstElement()) != null && policyElement.getQName().equals(org.apache.neethi.Constants.Q_ELEM_POLICY)) {
            Policy policy = PolicyEngine.getPolicy((OMElement)policyElement);
            Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
            if (iterator.hasNext()) {
                this.processAlternative((List)iterator.next(), issuedToken);
            }
        }
        return issuedToken;
    }

    public QName[] getKnownElements() {
        return new QName[]{Constants.ISSUED_TOKEN};
    }

    private void processAlternative(List assertions, IssuedToken parent) {
        Iterator iterator = assertions.iterator();
        while (iterator.hasNext()) {
            Assertion assertion = (Assertion)iterator.next();
            QName name = assertion.getName();
            if (Constants.REQUIRE_DERIVED_KEYS.equals(name)) {
                parent.setDerivedKeys(true);
                continue;
            }
            if (Constants.REQUIRE_EXTERNAL_REFERNCE.equals(name)) {
                parent.setRequireExternalReference(true);
                continue;
            }
            if (!Constants.REQUIRE_INTERNAL_REFERNCE.equals(name)) continue;
            parent.setRequireInternalReference(true);
        }
    }
}

