/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.maven2.mar;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.axis2.maven2.mar.FileSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractMarMojo
extends AbstractMojo {
    protected File baseDir;
    protected MavenProject project;
    private File classesDirectory;
    protected File marDirectory;
    private File moduleXmlFile;
    private FileSet[] fileSets;
    private boolean includeDependencies;

    protected void buildExplodedMar() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Exploding mar...");
        this.marDirectory.mkdirs();
        this.getLog().debug((CharSequence)("Assembling mar " + this.project.getArtifactId() + " in " + this.marDirectory));
        try {
            File metaInfDir = new File(this.marDirectory, "META-INF");
            File libDir = new File(this.marDirectory, "lib");
            File moduleFileTarget = new File(metaInfDir, "module.xml");
            boolean existsBeforeCopyingClasses = moduleFileTarget.exists();
            if (this.classesDirectory.exists() && !this.classesDirectory.equals(this.marDirectory)) {
                FileUtils.copyDirectoryStructure((File)this.classesDirectory, (File)this.marDirectory);
            }
            if (this.fileSets != null) {
                for (int i = 0; i < this.fileSets.length; ++i) {
                    FileSet fileSet = this.fileSets[i];
                    this.copyFileSet(fileSet, this.marDirectory);
                }
            }
            this.copyMetaInfFile(this.moduleXmlFile, moduleFileTarget, existsBeforeCopyingClasses, "module.xml file");
            if (this.includeDependencies) {
                Set artifacts = this.project.getArtifacts();
                List duplicates = this.findDuplicates(artifacts);
                for (Artifact artifact : artifacts) {
                    String type;
                    ScopeArtifactFilter filter;
                    String targetFileName = this.getDefaultFinalName(artifact);
                    this.getLog().debug((CharSequence)("Processing: " + targetFileName));
                    if (duplicates.contains(targetFileName)) {
                        this.getLog().debug((CharSequence)("Duplicate found: " + targetFileName));
                        targetFileName = artifact.getGroupId() + "-" + targetFileName;
                        this.getLog().debug((CharSequence)("Renamed to: " + targetFileName));
                    }
                    if (!(filter = new ScopeArtifactFilter("runtime")).include(artifact) || !"jar".equals(type = artifact.getType())) continue;
                    this.copyFileIfModified(artifact.getFile(), new File(libDir, targetFileName));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not explode mar...", (Exception)e);
        }
    }

    private List findDuplicates(Set artifacts) {
        ArrayList<String> duplicates = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        for (Artifact artifact : artifacts) {
            String candidate = this.getDefaultFinalName(artifact);
            if (identifiers.contains(candidate)) {
                duplicates.add(candidate);
                continue;
            }
            identifiers.add(candidate);
        }
        return duplicates;
    }

    private String getDefaultFinalName(Artifact artifact) {
        return artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getArtifactHandler().getExtension();
    }

    private void copyFileIfModified(File source, File destination) throws IOException {
        if (destination.lastModified() < source.lastModified()) {
            FileUtils.copyFile((File)source.getCanonicalFile(), (File)destination);
            destination.setLastModified(source.lastModified());
        }
    }

    private void copyFileSet(FileSet fileSet, File targetDirectory) throws IOException {
        String[] includes;
        String[] excludes;
        File dir = fileSet.getDirectory();
        if (dir == null) {
            dir = this.baseDir;
        }
        File targetDir = targetDirectory;
        if (fileSet.getOutputDirectory() != null) {
            targetDir = new File(targetDir, fileSet.getOutputDirectory());
        }
        if (targetDir.equals(dir)) {
            return;
        }
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(dir);
        if (!fileSet.isSkipDefaultExcludes()) {
            ds.addDefaultExcludes();
        }
        if ((excludes = fileSet.getExcludes()) != null) {
            ds.setExcludes(excludes);
        }
        if ((includes = fileSet.getIncludes()) != null) {
            ds.setIncludes(includes);
        }
        ds.scan();
        String[] files = ds.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            File sourceFile = new File(dir, files[i]);
            File targetFile = new File(targetDir, files[i]);
            FileUtils.copyFile((File)sourceFile, (File)targetFile);
        }
    }

    private void copyMetaInfFile(File pSource, File pTarget, boolean pExistsBeforeCopying, String pDescription) throws MojoExecutionException, IOException {
        if (pSource != null && pTarget != null) {
            if (!pSource.exists()) {
                throw new MojoExecutionException("The configured " + pDescription + " could not be found at " + pSource);
            }
            if (!pExistsBeforeCopying && pTarget.exists()) {
                this.getLog().warn((CharSequence)("The configured " + pDescription + " overwrites another file from the classpath."));
            }
            FileUtils.copyFile((File)pSource, (File)pTarget);
        }
    }
}

