/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jibx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.util.StAXUtils;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.StAXWriter;

public class JiBXDataSource
implements OMDataSource {
    private final IMarshallable outObject;
    private final IBindingFactory bindingFactory;

    public JiBXDataSource(IMarshallable obj, IBindingFactory factory) {
        this.outObject = obj;
        this.bindingFactory = factory;
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            IMarshallingContext ctx = this.bindingFactory.createMarshallingContext();
            ctx.setOutput(output, "UTF-8");
            this.outObject.marshal(ctx);
        }
        catch (JiBXException e) {
            throw new XMLStreamException("Error in JiBX marshalling", e);
        }
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            IMarshallingContext ctx = this.bindingFactory.createMarshallingContext();
            ctx.setOutput(writer);
            this.outObject.marshal(ctx);
        }
        catch (JiBXException e) {
            throw new XMLStreamException("Error in JiBX marshalling", e);
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        try {
            StAXWriter writer = new StAXWriter(this.bindingFactory.getNamespaces(), xmlWriter);
            IMarshallingContext ctx = this.bindingFactory.createMarshallingContext();
            ctx.setXmlWriter((IXMLWriter)writer);
            this.outObject.marshal(ctx);
        }
        catch (JiBXException e) {
            throw new XMLStreamException("Error in JiBX marshalling", e);
        }
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.serialize(bos, null);
        return StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(bos.toByteArray()));
    }
}

