/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jibx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.ElementBase;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.NamespaceElement;
import org.jibx.binding.model.ValidationContext;
import org.jibx.runtime.JiBXException;

public class CodeGenerationUtility {
    public static HashMap getBindingMap(String path) {
        File file = new File(path);
        if (!file.exists()) {
            throw new RuntimeException("jibx binding definition file " + path + " not found");
        }
        try {
            ValidationContext vctx = BindingElement.newValidationContext();
            BindingElement binding = BindingElement.readBinding((InputStream)new FileInputStream(file), (String)path, (ValidationContext)vctx);
            if (vctx.getErrorCount() != 0 || vctx.getFatalCount() != 0) {
                throw new RuntimeException("invalid jibx binding definition file " + path);
            }
            return CodeGenerationUtility.defineBoundClasses(binding);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (JiBXException e) {
            throw new RuntimeException(e);
        }
    }

    private static HashMap defineBoundClasses(BindingElement binding) {
        String defaultns = CodeGenerationUtility.findDefaultNS(binding.topChildIterator());
        HashMap<QName, String> mappings = new HashMap<QName, String>();
        Iterator iter = binding.topChildIterator();
        while (iter.hasNext()) {
            MappingElement mapping;
            String name;
            ElementBase child = (ElementBase)iter.next();
            if (child.type() != 3 || (name = (mapping = (MappingElement)child).getName()) == null) continue;
            String uri = mapping.getUri();
            if (uri == null && (uri = CodeGenerationUtility.findDefaultNS(mapping.topChildIterator())) == null) {
                uri = defaultns;
            }
            mappings.put(new QName(uri, name), mapping.getClassName());
        }
        return mappings;
    }

    private static String findDefaultNS(Iterator iter) {
        ElementBase child;
        while (iter.hasNext() && (child = (ElementBase)iter.next()).type() == 4) {
            NamespaceElement namespace = (NamespaceElement)child;
            String defaultName = namespace.getDefaultName();
            if (!"elements".equals(defaultName) && !"all".equals(defaultName)) continue;
            return namespace.getUri();
        }
        return null;
    }
}

