/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tools.idea;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressBarPanel
extends JPanel {
    private volatile boolean stop = false;
    private static int DELAY = 500;
    public volatile String val = null;
    private JLabel progressDescription;
    private JProgressBar progressSent;

    public ProgressBarPanel() {
        this.init();
    }

    public void requestStop() {
        this.stop = true;
    }

    private void init() {
        this.setVisible(false);
        this.progressDescription = new JLabel();
        this.progressDescription.setText("");
        this.progressSent = new JProgressBar();
        this.progressSent.setStringPainted(true);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.progressDescription, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.progressSent, new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
    }

    public void setProgressText(String s) {
        this.progressDescription.setText(s);
    }

    public void setProgressValue(int i) {
        this.progressSent.setValue(i);
    }

    public void aboutToDisplayPanel() {
        this.setProgressValue(0);
    }

    public void displayingPanel() {
        Thread t = new Thread(){

            public void run() {
                int minimum = ProgressBarPanel.this.progressSent.getMinimum();
                int maximum = ProgressBarPanel.this.progressSent.getMaximum();
                Runnable runner = new Runnable(){

                    public void run() {
                        if (ProgressBarPanel.this.stop && ProgressBarPanel.this.progressSent.getValue() < 75) {
                            ProgressBarPanel.this.progressSent.setIndeterminate(false);
                            int value = ProgressBarPanel.this.progressSent.getValue();
                            ProgressBarPanel.this.progressSent.setValue(value + 4);
                            ProgressBarPanel.this.setProgressValue(value + 4);
                        } else if (!ProgressBarPanel.this.stop) {
                            ProgressBarPanel.this.progressSent.setIndeterminate(true);
                        }
                    }
                };
                for (int i = minimum; i < maximum; ++i) {
                    try {
                        SwingUtilities.invokeAndWait(runner);
                        Thread.sleep(DELAY);
                        continue;
                    }
                    catch (InterruptedException ignoredException) {
                        continue;
                    }
                    catch (InvocationTargetException ignoredException) {
                        // empty catch block
                    }
                }
            }
        };
        t.start();
    }
}

