/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ideaplugin.frames;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.axis2.tools.component.WizardComponents;
import org.apache.axis2.tools.component.WizardPanel;
import org.apache.ideaplugin.bean.ArchiveBean;
import org.apache.ideaplugin.bean.ClassFileFilter;
import org.apache.ideaplugin.bean.OperationObj;
import org.apache.ideaplugin.bean.ServiceObj;
import org.apache.ideaplugin.frames.ServiceXMLEditPage;
import org.apache.ideaplugin.frames.table.ArchiveTableModel;

public class ServiceXMLGenerationPage
extends WizardPanel {
    private JTextField txtServiceName;
    private JTextField txtClassName;
    private JCheckBox chkBoxSearchMethod;
    private JButton btnLoad;
    private JButton btnBrowse;
    private JTable table;
    private JLabel lblTable;
    private JScrollPane scrollPane;
    private HashMap operations;
    private String fileName;
    private int count = 1;
    private ArrayList servicelsit;
    private String sgXMl;
    private final JFileChooser fileChooser = new JFileChooser();
    private ArchiveBean archiveBean;

    public ServiceXMLGenerationPage(WizardComponents wizardComponents, ArchiveBean archiveBean) {
        super(wizardComponents, "Axis2 Idea Plugin Service Archiver Creator Wizards");
        this.setPanelTopTitle("Service Archiver");
        this.setPanelBottomTitle("Service XML Generation");
        this.archiveBean = archiveBean;
        this.init();
    }

    private void init() {
        this.txtServiceName = new JTextField();
        this.txtClassName = new JTextField();
        this.btnBrowse = new JButton("Browse");
        this.btnLoad = new JButton("Load");
        this.chkBoxSearchMethod = new JCheckBox("Search declared method only", true);
        this.lblTable = new JLabel("Mark operation you do not want to publish ");
        this.operations = new HashMap();
        ArchiveTableModel myModel = new ArchiveTableModel(this.operations);
        this.table = new JTable(myModel);
        this.table.setOpaque(true);
        this.table.setBackground(this.getBackground());
        this.table.setShowGrid(true);
        this.table.setSize(this.getPreferredSize());
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.scrollPane.setSize(this.table.getSize());
        this.scrollPane.setOpaque(true);
        this.scrollPane.setBackground(this.getBackground());
        this.scrollPane.getViewport().setBackground(this.getBackground());
        this.scrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        this.setBackButtonEnabled(true);
        this.setNextButtonEnabled(false);
        this.setFinishButtonEnabled(false);
        this.setPageComplete(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("Class Name"), new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.txtClassName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.btnBrowse, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 11, 0, new Insets(5, 1, 1, 1), 0, 0));
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServiceXMLGenerationPage.this.browseClassFile();
                ServiceXMLGenerationPage.this.update();
            }
        });
        this.add((Component)this.btnLoad, new GridBagConstraints(3, 0, 1, 1, 0.1, 0.0, 11, 0, new Insets(5, 1, 1, 10), 0, 0));
        this.btnLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServiceXMLGenerationPage.this.updateTable();
                ServiceXMLGenerationPage.this.update();
            }
        });
        this.add((Component)new JLabel("Service Name"), new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.txtServiceName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.chkBoxSearchMethod, new GridBagConstraints(0, 2, -1, 1, 0.0, 0.0, 18, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.chkBoxSearchMethod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServiceXMLGenerationPage.this.updateTable();
                ServiceXMLGenerationPage.this.update();
            }
        });
        this.add((Component)this.lblTable, new GridBagConstraints(0, 3, -1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 4, 0, 1, 1.0, 1.0, 18, 1, new Insets(5, 10, 10, 10), 0, 0));
        this.setPageComplete(true);
    }

    public void back() {
        this.switchPanel(10);
    }

    public void next() {
        this.setNextButtonEnabled(false);
        this.checkautoGeneration();
        this.switchPanel(12);
        ((ServiceXMLEditPage)this.getWizardComponents().getWizardPanel(12)).setDescription(this.archiveBean.getServiceXML());
        ((ServiceXMLEditPage)this.getWizardComponents().getWizardPanel(12)).setDefaultEnabled();
    }

    public void update() {
    }

    public int getPageType() {
        return 3;
    }

    private void updateTable() {
        block9: {
            try {
                String classFileLocation = this.archiveBean.getClassLoc().getPath();
                URL classFileURL = new File(classFileLocation).toURL();
                ArrayList<URL> listofURLs = new ArrayList<URL>();
                listofURLs.add(classFileURL);
                ArrayList libList = this.archiveBean.getLibs();
                String[] libFileList = new String[libList.size()];
                for (int i = 0; i < libList.size(); ++i) {
                    libFileList[i] = (String)libList.get(i);
                }
                if (libFileList != null) {
                    int count = libFileList.length;
                    for (int i = 0; i < count; ++i) {
                        listofURLs.add(new File(libFileList[i]).toURL());
                    }
                }
                this.txtServiceName.setText("MyService" + this.count);
                URLClassLoader loader = new URLClassLoader(listofURLs.toArray(new URL[listofURLs.size()]));
                Class<?> clazz = Class.forName(this.fileName, true, loader);
                Method[] methods = null;
                methods = this.chkBoxSearchMethod.isSelected() ? clazz.getDeclaredMethods() : clazz.getMethods();
                int methodCount = methods.length;
                if (methodCount <= 0) break block9;
                try {
                    this.table.removeAll();
                    this.table.setVisible(true);
                    this.operations.clear();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                for (int i = 0; i < methodCount; ++i) {
                    Method method = methods[i];
                    OperationObj operationobj = new OperationObj(method.getName(), method.getReturnType().toString(), new Integer(method.getParameterTypes().length), new Boolean(true));
                    this.operations.put(method.getName(), operationobj);
                }
                ArchiveTableModel myModel = new ArchiveTableModel(this.operations);
                this.table.setModel(myModel);
                this.scrollPane.repaint();
                this.repaint();
                this.setNextButtonEnabled(true);
            }
            catch (MalformedURLException e) {
                this.setNextButtonEnabled(false);
                JOptionPane.showMessageDialog(this.btnLoad, "The specified file is not a valid java class", "Error!", 0);
            }
            catch (ClassNotFoundException e) {
                this.setNextButtonEnabled(false);
                JOptionPane.showMessageDialog(this.btnLoad, "The specified file is not a valid java class", "Error!", 0);
            }
        }
    }

    private void browseClassFile() {
        File tempfile;
        String newFile;
        int index;
        this.fileChooser.setFileFilter(new ClassFileFilter());
        this.fileChooser.setCurrentDirectory(this.archiveBean.getClassLoc());
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0 && (index = (newFile = (tempfile = this.fileChooser.getSelectedFile()).getPath()).indexOf(this.archiveBean.getClassLoc().getAbsolutePath().trim())) >= 0) {
            int lastindex = this.archiveBean.getClassLoc().getAbsolutePath().trim().length();
            newFile = newFile.substring(lastindex + 1);
            char ch = File.separatorChar;
            char newch = '.';
            int cindex = newFile.indexOf(ch);
            while (cindex >= 0) {
                newFile = newFile.replace(ch, newch);
                cindex = newFile.indexOf(ch);
            }
            this.fileName = newFile;
            int classIndex = this.fileName.lastIndexOf(".");
            this.fileName = this.fileName.substring(0, classIndex);
            this.txtClassName.setText(this.fileName);
        }
    }

    private void serviceGroupProcess() {
        ArrayList<String> ops = new ArrayList<String>();
        for (OperationObj operationObj : this.operations.values()) {
            if (!operationObj.getSelect().booleanValue()) continue;
            ops.add(operationObj.getOpName());
        }
        ServiceObj service = new ServiceObj(this.txtServiceName.getText(), this.fileName, ops);
        this.archiveBean.addToServicelsit(service);
        if (!this.archiveBean.isSingleService()) {
            int valu = JOptionPane.showConfirmDialog(this, "Do you want to add an another service to group", "Service Archive", 0);
            if (valu == 0) {
                this.fileName = "";
                this.txtClassName.setText("");
                this.txtServiceName.setText("");
                this.operations.clear();
                this.setNextButtonEnabled(false);
                this.switchPanel(7);
                ++this.count;
                this.repaint();
            } else {
                this.servicelsit = this.archiveBean.getServicelsit();
                System.out.println(this.servicelsit.size());
                this.sgXMl = "<serviceGroup>\n";
                for (int i = 0; i < this.servicelsit.size(); ++i) {
                    ServiceObj serviceObj = (ServiceObj)this.servicelsit.get(i);
                    this.sgXMl = this.sgXMl + serviceObj.toString();
                }
                this.sgXMl = this.sgXMl + "</serviceGroup>";
                this.archiveBean.setServiceXML(this.sgXMl);
                this.sgXMl = "";
                this.switchPanel(12);
            }
        } else {
            this.servicelsit = this.archiveBean.getServicelsit();
            this.sgXMl = "<serviceGroup>\n";
            for (int i = 0; i < this.servicelsit.size(); ++i) {
                ServiceObj serviceObj = (ServiceObj)this.servicelsit.get(i);
                this.sgXMl = this.sgXMl + serviceObj.toString();
            }
            this.sgXMl = this.sgXMl + "</serviceGroup>";
            this.archiveBean.setServiceXML(this.sgXMl);
            this.sgXMl = "";
            this.switchPanel(12);
        }
    }

    private void checkautoGeneration() {
        ArrayList<String> ops = new ArrayList<String>();
        for (OperationObj operationObj : this.operations.values()) {
            if (!operationObj.getSelect().booleanValue()) continue;
            ops.add(operationObj.getOpName());
        }
        this.txtServiceName.setText(this.txtServiceName.getText());
        ServiceObj service = new ServiceObj(this.txtServiceName.getText(), this.fileName, ops);
        this.archiveBean.addToServicelsit(service);
        this.servicelsit = this.archiveBean.getServicelsit();
        this.sgXMl = "<serviceGroup>";
        for (int i = 0; i < this.servicelsit.size(); ++i) {
            ServiceObj serviceObj = (ServiceObj)this.servicelsit.get(i);
            this.sgXMl = this.sgXMl + serviceObj.toString();
        }
        this.sgXMl = this.sgXMl + "</serviceGroup>";
        this.archiveBean.setServiceXML(this.sgXMl);
        this.sgXMl = "";
    }
}

