/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ideaplugin.frames;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.axis2.tools.component.WizardComponents;
import org.apache.axis2.tools.component.WizardPanel;
import org.apache.axis2.tools.java2wsdl.JarFileFilter;
import org.apache.ideaplugin.bean.ArchiveBean;

public class LibraryAddingPage
extends WizardPanel {
    private JTextField txtJarLocation;
    private JButton butSelect;
    private JButton butAdd;
    private JButton butRemove;
    private JList listPathDisply;
    private DefaultListModel listModel;
    private JButton btnHint;
    private JTextArea txaHint;
    private boolean flag = false;
    private String hint = "";
    private ArchiveBean archiveBean;
    private final JFileChooser fileChooser = new JFileChooser();

    public LibraryAddingPage(WizardComponents wizardComponents, ArchiveBean archiveBean) {
        super(wizardComponents, "Axis2 Idea Plugin Service Archiver Creator Wizards");
        this.setPanelTopTitle("Service Archiver");
        this.setPanelBottomTitle("Add any external Jar");
        this.archiveBean = archiveBean;
        this.init();
    }

    private void init() {
        this.txaHint = new JTextArea();
        this.txaHint.setBorder(null);
        this.txaHint.setFocusable(false);
        this.txaHint.setLineWrap(true);
        this.txaHint.setWrapStyleWord(true);
        this.txaHint.setOpaque(false);
        this.btnHint = new JButton("Hint >>");
        this.btnHint.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.txtJarLocation = new JTextField();
        this.butSelect = new JButton("Browse..");
        this.butAdd = new JButton("Add ->");
        this.butRemove = new JButton("Remove <-");
        this.listModel = new DefaultListModel();
        this.listPathDisply = new JList(this.listModel);
        this.listPathDisply.setAutoscrolls(true);
        this.listPathDisply.setOpaque(false);
        this.listPathDisply.setBorder(BorderFactory.createBevelBorder(1));
        this.listPathDisply.setFocusable(false);
        this.setBackButtonEnabled(true);
        this.setNextButtonEnabled(true);
        this.setFinishButtonEnabled(false);
        this.setPageComplete(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("Jar file location"), new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.txtJarLocation, new GridBagConstraints(1, 0, -1, 1, 1.0, 0.0, 10, 2, new Insets(5, 1, 0, 10), 0, 0));
        this.txtJarLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LibraryAddingPage.this.update();
            }
        });
        this.add((Component)this.butSelect, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 10, 0, new Insets(5, 10, 1, 10), 0, 0));
        this.butSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LibraryAddingPage.this.broswseJarFile();
                LibraryAddingPage.this.update();
            }
        });
        this.add((Component)this.butAdd, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 10, 1, 1), 0, 0));
        this.butAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LibraryAddingPage.this.listModel.addElement(LibraryAddingPage.this.txtJarLocation.getText());
                LibraryAddingPage.this.txtJarLocation.setText("");
                LibraryAddingPage.this.update();
            }
        });
        this.add((Component)this.butRemove, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 1, 1, 1), 2, 0));
        this.butRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LibraryAddingPage.this.handleRemove();
                LibraryAddingPage.this.update();
            }
        });
        this.add((Component)new JScrollPane(this.listPathDisply), new GridBagConstraints(0, 2, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 10, 1, 10), 0, 0));
        this.add((Component)this.btnHint, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.btnHint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (LibraryAddingPage.this.flag) {
                    LibraryAddingPage.this.btnHint.setText("Hint >>");
                    LibraryAddingPage.this.txaHint.setText("");
                    LibraryAddingPage.this.flag = false;
                } else {
                    LibraryAddingPage.this.btnHint.setText("Hint <<");
                    LibraryAddingPage.this.txaHint.setText(LibraryAddingPage.this.hint);
                    LibraryAddingPage.this.flag = true;
                }
                LibraryAddingPage.this.update();
            }
        });
        this.add((Component)this.txaHint, new GridBagConstraints(0, 4, 0, 1, 0.1, 1.0, 10, 1, new Insets(5, 10, 10, 10), 0, 0));
    }

    public void next() {
        this.switchPanel(10);
    }

    public void back() {
        this.switchPanel(8);
    }

    public void update() {
        this.fillBean();
        this.setPageComplete(true);
        this.setNextButtonEnabled(true);
    }

    public int getPageType() {
        return 3;
    }

    private void broswseJarFile() {
        this.fileChooser.setFileFilter(new JarFileFilter());
        int returnVal = this.fileChooser.showOpenDialog(this.butAdd);
        if (returnVal == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.txtJarLocation.setText(file.getAbsolutePath());
        }
    }

    private void handleRemove() {
        int[] selectionIndices = this.listPathDisply.getSelectedIndices();
        for (int i = 0; i < selectionIndices.length; ++i) {
            this.listModel.remove(selectionIndices[i]);
        }
    }

    private void fillBean() {
        ArrayList tempList = this.archiveBean.getLibs();
        tempList.addAll(this.getJarPathlist());
        this.archiveBean.addLibs(tempList);
        URL[] urllist = new URL[this.listModel.size() + 1];
        URLClassLoader cls = new URLClassLoader(urllist, LibraryAddingPage.class.getClassLoader());
        this.archiveBean.setClassLoader(cls);
    }

    public ArrayList getJarPathlist() {
        Object[] listObject = this.listModel.toArray();
        ArrayList<String> listString = new ArrayList<String>();
        for (int i = 0; i < listObject.length; ++i) {
            listString.add(listObject[i].toString());
        }
        return listString;
    }
}

