/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tools.idea;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class PluginClassLoader
extends URLClassLoader {
    private URL[] urls;
    private ArrayList lib_jars_list;

    public PluginClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.urls = urls;
        this.lib_jars_list = new ArrayList();
        this.findLibJars();
    }

    private void findLibJars() {
        File file = new File(this.urls[0].getFile());
        try {
            ZipEntry entry;
            ZipInputStream zin = new ZipInputStream(new FileInputStream(file));
            String entryName = "";
            while ((entry = zin.getNextEntry()) != null) {
                entryName = entry.getName();
                if (entryName == null || !entryName.startsWith("lib/") && !entryName.startsWith("Lib/") || !entryName.endsWith(".jar")) continue;
                this.lib_jars_list.add(entryName);
            }
            zin.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> cla = null;
        try {
            boolean foundClass = false;
            try {
                cla = super.findClass(name);
                foundClass = true;
                return cla;
            }
            catch (ClassNotFoundException e) {
                foundClass = false;
                if (!foundClass) {
                    byte[] raw = this.getBytes(name);
                    cla = this.defineClass(name, raw, 0, raw.length);
                    foundClass = true;
                    return cla;
                }
                if (!foundClass) {
                    throw new ClassNotFoundException("Class Not found : " + name);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private byte[] getBytes(String filename) throws Exception {
        String completeFileName = filename;
        completeFileName = completeFileName.replace('.', '/').concat(".class");
        byte[] raw = null;
        for (int i = 0; i < this.lib_jars_list.size(); ++i) {
            ZipEntry entry;
            String libjar_name = (String)this.lib_jars_list.get(i);
            InputStream in = this.getResourceAsStream(libjar_name);
            ZipInputStream zin = new ZipInputStream(in);
            String entryName = "";
            while ((entry = zin.getNextEntry()) != null) {
                int count;
                entryName = entry.getName();
                if (entryName == null || !entryName.endsWith(completeFileName)) continue;
                byte[] data = new byte[2048];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((count = zin.read(data, 0, 2048)) != -1) {
                    out.write(data, 0, count);
                }
                raw = out.toByteArray();
                out.close();
                zin.close();
                return raw;
            }
            continue;
        }
        throw new ClassNotFoundException("Class Not found : " + filename);
    }
}

