/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tools.wizardframe;

import com.intellij.openapi.project.Project;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.apache.axis2.tools.bean.CodegenBean;
import org.apache.axis2.tools.bean.SrcCompiler;
import org.apache.axis2.tools.bean.WsdlgenBean;
import org.apache.axis2.tools.component.CancelAction;
import org.apache.axis2.tools.component.DefaultWizardComponents;
import org.apache.axis2.tools.component.FinishAction;
import org.apache.axis2.tools.component.Utilities;
import org.apache.axis2.tools.component.WizardComponents;
import org.apache.axis2.tools.component.WizardPanel;
import org.apache.axis2.tools.idea.FirstPanel;
import org.apache.axis2.tools.idea.ProgressBarPanel;
import org.apache.axis2.tools.idea.SecondPanel;
import org.apache.axis2.tools.idea.WSDL2JavaOutputPanel;
import org.apache.ideaplugin.bean.ArchiveBean;
import org.apache.ideaplugin.bean.JarFileWriter;

public class WizardFrame
extends JFrame {
    private JLabel panelImageLabel;
    private JLabel panelTopTitleLabel;
    private JLabel panelBottomTitleLabel;
    private WizardComponents wizardComponents;
    protected WsdlgenBean wsdlgenBean;
    protected CodegenBean codegenBean;
    protected ArchiveBean archiveBean;
    protected Project project;
    private ProgressBarPanel progress;

    public WizardFrame() {
        this.init();
    }

    private void init() {
        this.wizardComponents = new DefaultWizardComponents();
        this.wsdlgenBean = new WsdlgenBean();
        this.codegenBean = new CodegenBean();
        this.archiveBean = new ArchiveBean();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.createTitlePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)new JSeparator(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.wizardComponents.getWizardPanelsContainer(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.progress = new ProgressBarPanel();
        this.getContentPane().add((Component)this.progress, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)new JSeparator(), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        this.getContentPane().add((Component)this.createButtonPanel(), new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        URL resource = WizardPanel.class.getResource("/icons/icon.png");
        this.setIconImage(new ImageIcon(resource).getImage());
        this.setFont(new Font("Helvetica", 0, 8));
        this.wizardComponents.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WizardFrame.this.setPanelTopTitle(((WizardPanel)event.getNewValue()).getPanelTopTitle());
                WizardFrame.this.setPanelTitleImage(((WizardPanel)event.getNewValue()).getPanelImage());
                WizardFrame.this.setPanelBottomTitle(((WizardPanel)event.getNewValue()).getPanelBottomTitle());
                WizardFrame.this.setTitle(((WizardPanel)event.getNewValue()).getFrameTitle());
            }
        });
        this.wizardComponents.setFinishAction(this.createFinishAction());
        this.wizardComponents.setCancelAction(this.createCancelAction());
        this.handleWindowClosing();
    }

    public WizardComponents getWizardComponents() {
        return this.wizardComponents;
    }

    public void setWizardComponents(WizardComponents aWizardComponents) {
        this.wizardComponents = aWizardComponents;
    }

    public void show() {
        this.wizardComponents.updateComponents();
        this.setSize(600, 600);
        Utilities.centerComponentOnScreen(this);
        super.show();
    }

    protected void setBottomVisible(boolean flag) {
        this.panelBottomTitleLabel.setVisible(flag);
    }

    protected void setPanelTopTitle(String title) {
        this.panelTopTitleLabel.setText(title);
    }

    protected void setPanelBottomTitle(String title) {
        this.panelBottomTitleLabel.setText(title);
    }

    protected void setPanelTitleImage(ImageIcon image) {
        this.panelImageLabel.setIcon(image);
    }

    protected JPanel createTitlePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(Color.white);
        this.panelTopTitleLabel = new JLabel();
        this.panelTopTitleLabel.setFont(new Font("Helvetica", 1, 12));
        this.panelBottomTitleLabel = new JLabel();
        this.panelBottomTitleLabel.setFont(new Font("Helvetica", 2, 10));
        this.panelImageLabel = new JLabel();
        panel.add((Component)this.panelTopTitleLabel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 21, 1, new Insets(10, 20, 0, 0), 0, 0));
        panel.add((Component)this.panelBottomTitleLabel, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 21, 1, new Insets(10, 20, 0, 0), 0, 0));
        panel.add((Component)this.panelImageLabel, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected JPanel createButtonPanel() {
        JPanel panel = new JPanel(new GridLayout());
        panel.add(this.wizardComponents.getBackButton());
        panel.add(this.wizardComponents.getNextButton());
        panel.add(this.wizardComponents.getFinishButton());
        panel.add(this.wizardComponents.getCancelButton());
        return panel;
    }

    protected FinishAction createFinishAction() {
        return new FinishAction(this.wizardComponents){

            public void performAction() {
                System.out.println("FinishAction performed");
                try {
                    WizardFrame.this.wizardComponents.getCurrentPanel().update();
                    switch (WizardFrame.this.wizardComponents.getCurrentPanel().getPageType()) {
                        case 1: {
                            WizardFrame.this.doFinishWSDL2Java();
                            System.out.println("FinishAction  WSDL2Java performed");
                            break;
                        }
                        case 2: {
                            WizardFrame.this.doFinishJava2WSDL();
                            System.out.println("FinishAction Java2WSDL performed");
                            break;
                        }
                        case 3: {
                            WizardFrame.this.doFinishServiceArchive();
                            System.out.println("FinishAction Servcie Archive performed");
                            break;
                        }
                        case 4: {
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid state!");
                        }
                    }
                }
                catch (Exception e) {
                    WizardFrame.this.wizardComponents.setCurrentIndex(0);
                    WizardFrame.this.dispose();
                }
            }
        };
    }

    protected CancelAction createCancelAction() {
        return new CancelAction(this.wizardComponents){

            public void performAction() {
                WizardFrame.this.wizardComponents.setCurrentIndex(0);
                System.out.println("CancelAction performed");
                WizardFrame.this.dispose();
            }
        };
    }

    protected void handleWindowClosing() {
        this.wizardComponents.setCurrentIndex(0);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                WizardFrame.this.wizardComponents.getCancelAction().performAction();
            }
        });
    }

    protected void handlePragress() {
        this.wizardComponents.getFinishButton().setEnabled(false);
        this.progress.setVisible(true);
        this.progress.aboutToDisplayPanel();
        this.progress.displayingPanel();
        new Timer(true).schedule(new TimerTask(){

            public void run() {
                WizardFrame.this.progress.requestStop();
            }
        }, 1000L);
    }

    protected void handleSuccess() {
        StringWriter writer = new StringWriter();
        JOptionPane.showMessageDialog(this, "Code genaration Successful !" + writer.toString(), "Axis2 code generation", 1);
        this.wizardComponents.setCurrentIndex(0);
        this.dispose();
    }

    protected void handleError() {
        this.wizardComponents.getFinishButton().setEnabled(true);
        StringWriter writer = new StringWriter();
        JOptionPane.showMessageDialog(this, "Code genaration failed! !" + writer.toString(), "Axis2 code generation", 0);
    }

    private void addLibsToProjectLib(String libDirectory, String outputLocation) {
        String newOutputLocation = outputLocation + File.separator + "lib";
        boolean success = new File(newOutputLocation).mkdir();
        if (!success) {
            // empty if block
        }
        try {
            this.copyDirectory(new File(libDirectory), new File(newOutputLocation));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] children = srcDir.list();
            for (int i = 0; i < children.length; ++i) {
                this.copyDirectory(new File(srcDir, children[i]), new File(dstDir, children[i]));
            }
        } else {
            this.copyFile(srcDir, dstDir);
        }
    }

    private void copyFile(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    protected void doFinishWSDL2Java() {
        this.handlePragress();
        new Timer(true).schedule(new TimerTask(){

            public void run() {
                try {
                    boolean isServiceXML;
                    boolean isServerside;
                    FirstPanel first = (FirstPanel)WizardFrame.this.wizardComponents.getWizardPanel(1);
                    SecondPanel option = (SecondPanel)WizardFrame.this.wizardComponents.getWizardPanel(3);
                    WSDL2JavaOutputPanel output = (WSDL2JavaOutputPanel)WizardFrame.this.wizardComponents.getWizardPanel(5);
                    boolean isGenerateServerSideInterface = false;
                    if (option.getGenerateAll()) {
                        isServerside = true;
                        isServiceXML = true;
                        isGenerateServerSideInterface = true;
                    } else {
                        isServerside = option.isServerside();
                        isServiceXML = option.isServerXML();
                        isGenerateServerSideInterface = option.getGenerateServerSideInterface();
                    }
                    WizardFrame.this.codegenBean.setPackageName(option.getPackageName());
                    WizardFrame.this.codegenBean.setLanguage(option.getSelectedLanguage());
                    WizardFrame.this.codegenBean.setPortName(option.getPortName());
                    WizardFrame.this.codegenBean.setServiceName(option.getServiceName());
                    WizardFrame.this.codegenBean.setDatabindingName(option.getDatabinderName());
                    WizardFrame.this.codegenBean.setAsyncOnly(option.isAsyncOnlyOn());
                    WizardFrame.this.codegenBean.setSyncOnly(option.isSyncOnlyOn());
                    WizardFrame.this.codegenBean.setTestCase(option.isGenerateTestCase());
                    WizardFrame.this.codegenBean.setGenerateAll(option.getGenerateAll());
                    WizardFrame.this.codegenBean.setServerXML(isServiceXML);
                    WizardFrame.this.codegenBean.setServerSide(isServerside);
                    WizardFrame.this.codegenBean.setServerSideInterface(isGenerateServerSideInterface);
                    WizardFrame.this.codegenBean.setOutput(output.getOutputLocation());
                    WizardFrame.this.codegenBean.setNamespace2packageList(option.getNs2PkgMapping());
                    WizardFrame.this.codegenBean.setWSDLFileName(first.getWSDLFileName());
                    WizardFrame.this.codegenBean.generate();
                    if (output.getAxis2PluginLibCopyCheckBoxSelection()) {
                        URL resource = (class$org$apache$axis2$tools$component$WizardPanel == null ? (class$org$apache$axis2$tools$component$WizardPanel = WizardFrame.class$("org.apache.axis2.tools.component.WizardPanel")) : class$org$apache$axis2$tools$component$WizardPanel).getResource("/icons/icon.png");
                        String path = new File(resource.getPath()).getParentFile().getParentFile().getParentFile().getPath();
                        System.out.println(path);
                        String pluginLibLocation = path + File.separator + "lib";
                        WizardFrame.this.addLibsToProjectLib(pluginLibLocation, output.getOutputLocation());
                    }
                    if (output.getAxisLibCopyCheckBoxSelection() && output.oktoLoadLibs()) {
                        String libDirectory = output.getAxisJarsLocation();
                        WizardFrame.this.addLibsToProjectLib(libDirectory, output.getOutputLocation());
                    }
                    if (output.getCreateJarCheckBoxSelection()) {
                        File tempClassFile = WizardFrame.this.codegenBean.getTemp();
                        tempClassFile.mkdir();
                        File srcTemp = new File(tempClassFile.getPath() + File.separator + "src");
                        srcTemp.mkdir();
                        WizardFrame.this.copyDirectory(new File(output.getOutputLocation() + File.separator + "src"), srcTemp);
                        SrcCompiler srcCompileTool = new SrcCompiler();
                        srcCompileTool.compileSource(tempClassFile.getPath());
                        String projectLib = output.getOutputLocation() + File.separator + "lib";
                        JarFileWriter jarFileWriter = new JarFileWriter();
                        String jarFileName = "CodegenResults.jar";
                        if (!output.getJarFilename().equals("")) {
                            jarFileName = output.getJarFilename();
                        }
                        output.setJarFileName(jarFileName);
                        File tempClass = new File(tempClassFile.getPath() + File.separator + "classes");
                        jarFileWriter.writeJarFile(new File(projectLib), jarFileName, tempClass);
                        WizardFrame.this.deleteDir(tempClassFile);
                    }
                    WizardFrame.this.progress.setVisible(false);
                    WizardFrame.this.handleSuccess();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    WizardFrame.this.progress.setVisible(false);
                    WizardFrame.this.handleError();
                }
            }
        }, 5000L);
    }

    protected void doFinishJava2WSDL() {
        this.handlePragress();
        new Timer(true).schedule(new TimerTask(){

            public void run() {
                try {
                    WizardFrame.this.wsdlgenBean.generate();
                    WizardFrame.this.progress.setVisible(false);
                    WizardFrame.this.handleSuccess();
                }
                catch (Exception e1) {
                    WizardFrame.this.progress.setVisible(false);
                    WizardFrame.this.handleError();
                }
            }
        }, 3100L);
    }

    protected void doFinishServiceArchive() {
        this.handlePragress();
        new Timer(true).schedule(new TimerTask(){

            public void run() {
                try {
                    WizardFrame.this.archiveBean.finsh();
                    WizardFrame.this.progress.setVisible(false);
                    WizardFrame.this.handleSuccess();
                }
                catch (Exception e1) {
                    WizardFrame.this.progress.setVisible(false);
                    WizardFrame.this.handleError();
                }
            }
        }, 3100L);
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public JComponent getRootComponent() {
        return this.getRootPane();
    }

    public void showUI() {
        this.pack();
        this.setVisible(true);
        this.show();
    }
}

