/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tools.java2wsdl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.axis2.tools.bean.WsdlgenBean;
import org.apache.axis2.tools.component.WizardComponents;
import org.apache.axis2.tools.component.WizardPanel;

public class OutputPanel
extends WizardPanel {
    private JRadioButton rbtnAdd;
    private JRadioButton rbtnSave;
    private JComboBox cmbCurrentProject;
    private JComboBox cmbModuleSrc;
    private JTextField txtLocation;
    private JTextField txtFileName;
    private JLabel lblModule;
    private JLabel lblDirect;
    private JLabel lblOutput;
    private JButton btnBrowes;
    final JFileChooser DirChooser = new JFileChooser();
    private Project project;
    private WsdlgenBean wsdlgenBean;
    private boolean flag = true;

    public OutputPanel(WizardComponents wizardComponents, WsdlgenBean wsdlgenBean, Project project) {
        super(wizardComponents, "Axis2 Idea Plugin Java2WSDL Wizards");
        this.setPanelTopTitle("WSDl file output location");
        this.setPanelBottomTitle("Select the location for the generated WSDL");
        this.wsdlgenBean = wsdlgenBean;
        this.project = project;
        this.init();
    }

    private void init() {
        this.rbtnAdd = new JRadioButton("Browes and Add the WSDL to a project on current Idea workspace", true);
        this.rbtnSave = new JRadioButton("Browes and Save the WSDL file on local file system", false);
        this.cmbCurrentProject = new JComboBox();
        this.cmbCurrentProject.setEnabled(true);
        this.cmbModuleSrc = new JComboBox();
        this.cmbModuleSrc.setEnabled(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbtnAdd);
        buttonGroup.add(this.rbtnSave);
        this.txtFileName = new JTextField("service.wsdl");
        this.txtLocation = new JTextField();
        this.btnBrowes = new JButton("Browse..");
        this.lblOutput = new JLabel("OutPut Location");
        this.lblModule = new JLabel("Select the Module");
        this.lblModule.setEnabled(false);
        this.lblDirect = new JLabel("Select the Directory");
        this.lblDirect.setEnabled(false);
        this.setBackButtonEnabled(true);
        this.setNextButtonEnabled(false);
        this.setFinishButtonEnabled(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("OutPut File Name"), new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.txtFileName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)new JLabel("Select the location where to put the output"), new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.rbtnAdd, new GridBagConstraints(0, 2, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.rbtnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OutputPanel.this.cmbCurrentProject.setEnabled(true);
                OutputPanel.this.cmbModuleSrc.setEnabled(true);
                OutputPanel.this.lblModule.setEnabled(true);
                OutputPanel.this.txtLocation.setEnabled(false);
                OutputPanel.this.btnBrowes.setEnabled(false);
                OutputPanel.this.loadCmbCurrentProject();
                OutputPanel.this.loadcmbModuleSrcProject();
                OutputPanel.this.setFinishButtonEnabled(true);
                OutputPanel.this.update();
            }
        });
        this.add((Component)this.lblModule, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.cmbCurrentProject, new GridBagConstraints(1, 3, -1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.cmbCurrentProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OutputPanel.this.loadcmbModuleSrcProject();
                OutputPanel.this.update();
            }
        });
        this.add((Component)this.lblDirect, new GridBagConstraints(0, 4, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.cmbModuleSrc, new GridBagConstraints(1, 4, -1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.cmbModuleSrc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OutputPanel.this.update();
            }
        });
        this.add((Component)this.rbtnSave, new GridBagConstraints(0, 5, 0, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.rbtnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OutputPanel.this.cmbCurrentProject.setEnabled(false);
                OutputPanel.this.cmbModuleSrc.setEnabled(false);
                OutputPanel.this.txtLocation.setEnabled(true);
                OutputPanel.this.btnBrowes.setEnabled(true);
                OutputPanel.this.setEnabledForCustomProject();
                OutputPanel.this.update();
            }
        });
        this.add((Component)this.lblOutput, new GridBagConstraints(0, 6, 1, 1, 0.1, 1.0, 18, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.txtLocation, new GridBagConstraints(1, 6, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.btnBrowes, new GridBagConstraints(2, 6, 1, 1, 0.1, 1.0, 18, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.btnBrowes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OutputPanel.this.DirChooser.setFileSelectionMode(1);
                int returnVal = OutputPanel.this.DirChooser.showOpenDialog(OutputPanel.this.btnBrowes);
                if (returnVal == 0) {
                    OutputPanel.this.DirChooser.setFileSelectionMode(0);
                    File newfile = OutputPanel.this.DirChooser.getSelectedFile();
                    OutputPanel.this.txtLocation.setText(newfile.getAbsolutePath());
                }
                OutputPanel.this.update();
            }
        });
        this.wsdlgenBean.setProject(this.project);
    }

    public void loadCmbCurrentProject() {
        Module[] modules = this.wsdlgenBean.getModules();
        if (modules != null) {
            for (int count = 0; count < modules.length; ++count) {
                this.cmbCurrentProject.addItem(modules[count].getName());
            }
        } else {
            this.rbtnSave.setSelected(true);
            this.rbtnAdd.setEnabled(false);
        }
    }

    public void loadcmbModuleSrcProject() {
        String module = null;
        module = (String)this.cmbCurrentProject.getSelectedItem();
        this.cmbModuleSrc.removeAllItems();
        int count = 0;
        if (module != null) {
            String[] src = this.wsdlgenBean.getModuleSrc(module);
            for (count = 0; count < src.length; ++count) {
                this.cmbModuleSrc.addItem(src[count]);
            }
            count = src.length;
        }
        if (this.flag) {
            if (count == 0) {
                this.flag = false;
                this.setEnabledForCustomProject();
            } else {
                this.setEnabledForCurrentProject();
            }
        }
    }

    public void back() {
        this.switchPanel(4);
    }

    public void next() {
    }

    public void update() {
        if (this.rbtnSave.isSelected()) {
            if (this.txtFileName.getText() != null && this.txtLocation.getText() != null) {
                this.wsdlgenBean.setOutputWSDLName(this.txtFileName.getText());
                this.wsdlgenBean.setOutputLocation(this.txtLocation.getText());
                this.setFinishButtonEnabled(true);
            } else if (this.txtLocation.getText() != null) {
                this.wsdlgenBean.setOutputLocation(this.txtLocation.getText());
                this.setFinishButtonEnabled(false);
            } else if (this.txtFileName.getText() != null) {
                this.wsdlgenBean.setOutputWSDLName(this.txtFileName.getText());
                this.setFinishButtonEnabled(false);
            } else {
                this.setFinishButtonEnabled(false);
            }
        } else if (this.rbtnAdd.isSelected()) {
            if (this.txtFileName.getText() != null && this.cmbModuleSrc.getSelectedItem() != null) {
                this.wsdlgenBean.setOutputWSDLName(this.txtFileName.getText());
                this.wsdlgenBean.setOutputLocation(this.cmbModuleSrc.getSelectedItem().toString());
                this.setFinishButtonEnabled(true);
            } else if (this.txtFileName.getText() != null) {
                this.wsdlgenBean.setOutputWSDLName(this.txtFileName.getText());
                this.setFinishButtonEnabled(false);
            } else {
                this.setFinishButtonEnabled(false);
            }
        }
        this.setBackButtonEnabled(true);
        this.setNextButtonEnabled(false);
    }

    public int getPageType() {
        return 2;
    }

    private void setEnabledForCurrentProject() {
        this.rbtnAdd.setSelected(true);
        this.rbtnAdd.setEnabled(true);
        this.cmbCurrentProject.setEnabled(true);
        this.cmbModuleSrc.setEnabled(true);
        this.lblDirect.setEnabled(true);
        this.lblModule.setEnabled(true);
        this.rbtnSave.setSelected(false);
        this.txtLocation.setEnabled(false);
        this.lblOutput.setEnabled(false);
        this.btnBrowes.setEnabled(false);
    }

    private void setEnabledForCustomProject() {
        if (this.flag) {
            this.rbtnAdd.setEnabled(false);
            this.rbtnAdd.setSelected(false);
        } else {
            this.rbtnSave.setEnabled(true);
            this.rbtnSave.setSelected(true);
        }
        this.cmbCurrentProject.setEnabled(false);
        this.cmbModuleSrc.setEnabled(false);
        this.lblDirect.setEnabled(false);
        this.lblModule.setEnabled(false);
        this.txtLocation.setEnabled(true);
        this.lblOutput.setEnabled(true);
        this.btnBrowes.setEnabled(true);
    }
}

