/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tools.bean;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.util.CommandLineOption;
import org.apache.axis2.util.URLProcessor;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationEngine;

public class CodegenBean {
    private String WSDLFileName = null;
    private String output = ".";
    private String packageName = "org.apache.axis2";
    private String language = "java";
    private boolean asyncOnly = false;
    private boolean syncOnly = false;
    private boolean serverSide = false;
    private boolean testcase = true;
    private boolean isServerXML;
    private boolean isGenerateAll;
    private boolean isTestCase;
    private String serviceName;
    private String portName;
    private String databindingName;
    private String namespace2packageList;
    private Definition wsdlDefinition = null;
    private boolean defaultClient = true;
    private Project project;
    private boolean isServerSideInterface = true;

    public void setNamespace2packageList(String namespace2packageList) {
        this.namespace2packageList = namespace2packageList;
    }

    public boolean isServerSideInterface() {
        return this.isServerSideInterface;
    }

    public void setServerSideInterface(boolean serverSideInterface) {
        this.isServerSideInterface = serverSideInterface;
    }

    public boolean isDefaultClient() {
        return this.defaultClient;
    }

    public void setDefaultClient(boolean defaultClient) {
        this.defaultClient = defaultClient;
    }

    public boolean isServerXML() {
        return this.isServerXML;
    }

    public void setServerXML(boolean serverXML) {
        this.isServerXML = serverXML;
    }

    public boolean isGenerateAll() {
        return this.isGenerateAll;
    }

    public void setGenerateAll(boolean generateAll) {
        this.isGenerateAll = generateAll;
    }

    public boolean isTestCase() {
        return this.isTestCase;
    }

    public void setTestCase(boolean testCase) {
        this.isTestCase = testCase;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getDatabindingName() {
        return this.databindingName;
    }

    public void setDatabindingName(String databindingName) {
        this.databindingName = databindingName;
    }

    private String mapLanguagesWithCombo(String UILangValue) {
        return UILangValue;
    }

    public Map fillOptionMap() {
        HashMap<String, CommandLineOption> optionMap = new HashMap<String, CommandLineOption>();
        optionMap.put("uri", new CommandLineOption("uri", this.getStringArray(this.WSDLFileName)));
        if (this.asyncOnly) {
            optionMap.put("a", new CommandLineOption("a", new String[0]));
        }
        if (this.syncOnly) {
            optionMap.put("s", new CommandLineOption("s", new String[0]));
        }
        if (this.serverSide) {
            optionMap.put("ss", new CommandLineOption("ss", new String[0]));
            if (this.isServerXML) {
                optionMap.put("sd", new CommandLineOption("sd", new String[0]));
            }
            if (this.isGenerateAll) {
                optionMap.put("g", new CommandLineOption("g", new String[0]));
            }
            if (this.isServerSideInterface) {
                optionMap.put("ssi", new CommandLineOption("ssi", new String[0]));
            }
        }
        if (this.isTestCase) {
            optionMap.put("t", new CommandLineOption("t", new String[0]));
        }
        optionMap.put("p", new CommandLineOption("p", this.getStringArray(this.packageName)));
        optionMap.put("l", new CommandLineOption("l", this.getStringArray(this.mapLanguagesWithCombo(this.language))));
        optionMap.put("o", new CommandLineOption("o", this.getStringArray(this.output)));
        optionMap.put("d", new CommandLineOption("d", this.getStringArray(this.databindingName)));
        if (this.portName != null) {
            optionMap.put("pn", new CommandLineOption("pn", this.getStringArray(this.portName)));
        }
        if (this.serviceName != null) {
            optionMap.put("sn", new CommandLineOption("sn", this.getStringArray(this.serviceName)));
        }
        if (this.isServerSideInterface) {
            optionMap.put("ssi", new CommandLineOption("ssi", new String[0]));
        }
        if (this.namespace2packageList != null) {
            optionMap.put("ns2p", new CommandLineOption("ns2p", this.getStringArray(this.namespace2packageList)));
        }
        return optionMap;
    }

    public String getBaseUri(String wsdlURI) {
        try {
            URL url = wsdlURI.indexOf("://") == -1 ? new URL("file", "", wsdlURI) : new URL(wsdlURI);
            String baseUri = "file".equals(url.getProtocol()) ? new File(url.getFile()).getParentFile().toURL().toExternalForm() : url.toExternalForm().substring(0, url.toExternalForm().lastIndexOf("/"));
            return baseUri;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public AxisService getAxisService(String wsdlURI) throws Exception {
        URL url = wsdlURI.indexOf("://") == -1 ? new URL("file", "", wsdlURI) : new URL(wsdlURI);
        WSDL11ToAxisServiceBuilder builder = new WSDL11ToAxisServiceBuilder(url.openConnection().getInputStream());
        builder.setDocumentBaseUri(url.toString());
        builder.setBaseUri(this.getBaseUri(wsdlURI));
        builder.setCodegen(true);
        return builder.populateService();
    }

    private String[] getStringArray(String value) {
        String[] values = new String[]{value};
        return values;
    }

    public String getWSDLFileName() {
        return this.WSDLFileName;
    }

    public void setWSDLFileName(String WSDLFileName) {
        this.WSDLFileName = WSDLFileName;
    }

    public boolean isSyncOnly() {
        return this.syncOnly;
    }

    public void setSyncOnly(boolean syncOnly) {
        this.syncOnly = syncOnly;
    }

    public boolean isAsyncOnly() {
        return this.asyncOnly;
    }

    public void setAsyncOnly(boolean asyncOnly) {
        this.asyncOnly = asyncOnly;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }

    public boolean isTestcase() {
        return this.testcase;
    }

    public void setTestcase(boolean testcase) {
        this.testcase = testcase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() throws Exception {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        try {
            if (!"xmlbeans".equals(this.getDatabindingName())) {
                Thread.currentThread().setContextClassLoader(Class.class.getClassLoader());
            }
            CodeGenConfiguration codegenConfig = new CodeGenConfiguration(this.fillOptionMap());
            codegenConfig.addAxisService(this.getAxisService(this.WSDLFileName));
            codegenConfig.setWsdlDefinition(this.wsdlDefinition);
            codegenConfig.setBaseURI(this.getBaseUri(this.WSDLFileName));
            new CodeGenerationEngine(codegenConfig).generate();
        }
        catch (Throwable e) {
            try {
                CodeGenConfiguration codegenConfig = new CodeGenConfiguration(this.fillOptionMap());
                codegenConfig.addAxisService(this.getAxisService(this.WSDLFileName));
                codegenConfig.setWsdlDefinition(this.wsdlDefinition);
                codegenConfig.setBaseURI(this.getBaseUri(this.WSDLFileName));
                new CodeGenerationEngine(codegenConfig).generate();
            }
            catch (Throwable e1) {
                throw new Exception("Code generation failed due to " + e.getLocalizedMessage());
            }
        }
        finally {
            if (!"xmlbeans".equals(this.getDatabindingName())) {
                Thread.currentThread().setContextClassLoader(tcl);
            }
        }
    }

    public void readWSDL() throws WSDLException {
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        this.wsdlDefinition = reader.readWSDL(this.WSDLFileName);
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.setDocumentBaseURI(this.WSDLFileName);
        }
    }

    public String packageFromTargetNamespace() {
        return URLProcessor.makePackageName((String)this.wsdlDefinition.getTargetNamespace());
    }

    public List getServiceList() {
        ArrayList<QName> returnList = new ArrayList<QName>();
        Service service = null;
        Map serviceMap = this.wsdlDefinition.getServices();
        if (serviceMap != null && !serviceMap.isEmpty()) {
            Iterator serviceIterator = serviceMap.values().iterator();
            while (serviceIterator.hasNext()) {
                service = (Service)serviceIterator.next();
                returnList.add(service.getQName());
            }
        }
        return returnList;
    }

    public List getPortNameList(QName serviceName) {
        Map portMap;
        ArrayList<String> returnList = new ArrayList<String>();
        Service service = this.wsdlDefinition.getService(serviceName);
        Port port = null;
        if (service != null && (portMap = service.getPorts()) != null && !portMap.isEmpty()) {
            Iterator portIterator = portMap.values().iterator();
            while (portIterator.hasNext()) {
                port = (Port)portIterator.next();
                returnList.add(port.getName());
            }
        }
        return returnList;
    }

    public Project getActiveProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public File getTemp() {
        String time = Calendar.getInstance().getTime().toString().replace(':', '-');
        return new File(this.getOutput() + File.separator + "temp-" + time);
    }

    public Module[] getModules() {
        Project project = this.getActiveProject();
        if (project != null) {
            return ModuleManager.getInstance((Project)project).getModules();
        }
        return null;
    }

    public String[] getModuleSrc(String name) {
        Project project = this.getActiveProject();
        if (project != null) {
            Module module = ModuleManager.getInstance((Project)project).findModuleByName(name);
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            VirtualFile[] virtualFiles = moduleRootManager.getSourceRoots();
            String[] src = new String[virtualFiles.length];
            for (int count = 0; count < src.length; ++count) {
                src[count] = virtualFiles[count].getPresentableUrl();
            }
            return src;
        }
        return null;
    }

    public Collection getDefinitionNamespaceMap() {
        Map namespaces = this.wsdlDefinition.getNamespaces();
        return namespaces.values();
    }
}

