/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.databinding.typemapping.SimpleTypeMapper;
import org.apache.axis2.databinding.utils.BeanUtil;

public class MultirefHelper {
    public static final String SOAP12_REF_ATTR = "ref";
    public static final String SOAP11_REF_ATTR = "href";
    private boolean filledTable;
    private OMElement parent;
    private HashMap objectmap = new HashMap();
    private HashMap elementMap = new HashMap();
    private HashMap omElementMap = new HashMap();

    public MultirefHelper(OMElement parent) {
        this.parent = parent;
    }

    public Object getObject(String id) {
        return this.objectmap.get(id);
    }

    public OMElement getOMElement(String id) {
        return (OMElement)this.omElementMap.get(id);
    }

    public OMElement processOMElementRef(String id) throws AxisFault {
        OMElement val;
        if (!this.filledTable) {
            this.readallChildElements();
        }
        if ((val = (OMElement)this.elementMap.get(id)) == null) {
            throw new AxisFault("Invalid reference :" + id);
        }
        OMElement ele = this.processElementforRefs(val);
        OMElement cloneele = this.elementClone(ele);
        this.omElementMap.put(id, cloneele);
        return cloneele;
    }

    public OMElement processElementforRefs(OMElement elemnts) throws AxisFault {
        Iterator itr = elemnts.getChildElements();
        while (itr.hasNext()) {
            OMElement omElement = (OMElement)itr.next();
            OMAttribute attri = MultirefHelper.processRefAtt(omElement);
            if (attri == null) continue;
            String ref = MultirefHelper.getAttvalue(attri);
            OMElement tempele = this.getOMElement(ref);
            if (tempele == null) {
                tempele = this.processOMElementRef(ref);
            }
            OMElement ele2 = this.elementClone(tempele);
            Iterator itrChild = ele2.getChildren();
            while (itrChild.hasNext()) {
                Object obj = itrChild.next();
                if (!(obj instanceof OMNode)) continue;
                omElement.addChild((OMNode)obj);
            }
        }
        return elemnts;
    }

    private OMElement elementClone(OMElement ele) {
        return new StAXOMBuilder(ele.getXMLStreamReader()).getDocumentElement();
    }

    public Object processRef(Class javatype, String id) throws AxisFault {
        OMElement val;
        if (!this.filledTable) {
            this.readallChildElements();
        }
        if ((val = (OMElement)this.elementMap.get(id)) == null) {
            throw new AxisFault("Invalid reference :" + id);
        }
        if (SimpleTypeMapper.isSimpleType(javatype)) {
            Object valObj = SimpleTypeMapper.getSimpleTypeObject(javatype, val);
            this.objectmap.put(id, valObj);
            return valObj;
        }
        if (SimpleTypeMapper.isArrayList(javatype)) {
            ArrayList valobj = SimpleTypeMapper.getArrayList(val);
            this.objectmap.put(id, valobj);
            return valobj;
        }
        Object obj = BeanUtil.deserialize(javatype, val, this);
        this.objectmap.put(id, obj);
        return obj;
    }

    private void readallChildElements() {
        Iterator childs = this.parent.getChildElements();
        while (childs.hasNext()) {
            OMElement omElement = (OMElement)childs.next();
            OMAttribute id = omElement.getAttribute(new QName("id"));
            if (id == null) continue;
            omElement.build();
            this.elementMap.put(id.getAttributeValue(), omElement);
        }
        this.filledTable = true;
    }

    public static String getAttvalue(OMAttribute omatribute) {
        String ref = omatribute.getAttributeValue();
        if (ref != null && ref.charAt(0) == '#') {
            ref = ref.substring(1);
        }
        return ref;
    }

    public static OMAttribute processRefAtt(OMElement omElement) {
        OMAttribute omatribute = omElement.getAttribute(new QName(SOAP11_REF_ATTR));
        if (omatribute == null) {
            omatribute = omElement.getAttribute(new QName(SOAP12_REF_ATTR));
        }
        return omatribute;
    }

    public void clean() {
        this.elementMap.clear();
        this.objectmap.clear();
    }
}

