/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.handlers.addressing;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingValidationHandler
extends AbstractHandler
implements AddressingConstants {
    private static final Log log = LogFactory.getLog(AddressingValidationHandler.class);

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        Object flag = msgContext.getLocalProperty("IsAddressingProcessed");
        if (log.isTraceEnabled()) {
            log.trace((Object)("invoke: IS_ADDR_INFO_ALREADY_PROCESSED=" + flag));
        }
        if (JavaUtils.isTrueExplicitly((Object)flag)) {
            this.checkMessageIDHeader(msgContext);
        } else {
            this.checkUsingAddressing(msgContext);
        }
        if (JavaUtils.isTrue((Object)msgContext.getProperty("addressing.validateInvocationPattern"), (boolean)true)) {
            this.checkWSAMInvocationPattern(msgContext);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void checkUsingAddressing(MessageContext msgContext) throws AxisFault {
        AxisService ad = msgContext.getAxisService();
        if (ad == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"checkUsingAddressing: axisService null, cannot check UsingAddressing");
            }
            return;
        }
        if (msgContext.getAxisOperation() != null) {
            ad = msgContext.getAxisOperation();
        }
        String addressingFlag = AddressingHelper.getAddressingRequirementParemeterValue((AxisDescription)ad);
        if (log.isTraceEnabled()) {
            log.trace((Object)("checkUsingAddressing: WSAddressingFlag=" + addressingFlag));
        }
        if ("required".equals(addressingFlag)) {
            AddressingFaultsHelper.triggerMessageAddressingRequiredFault((MessageContext)msgContext, (String)"Action");
        }
    }

    private void checkWSAMInvocationPattern(MessageContext msgContext) throws AxisFault {
        String value = AddressingHelper.getInvocationPatternParameterValue((AxisOperation)msgContext.getAxisOperation());
        if (log.isTraceEnabled()) {
            log.trace((Object)("checkWSAMInvocationPattern: value=" + value));
        }
        if (!"both".equals(value)) {
            if ("synchronous".equals(value)) {
                EndpointReference anonEPR;
                if (!AddressingHelper.isSyncReplyAllowed((MessageContext)msgContext)) {
                    anonEPR = new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous");
                    msgContext.setReplyTo(anonEPR);
                    msgContext.setFaultTo(anonEPR);
                    AddressingFaultsHelper.triggerOnlyAnonymousAddressSupportedFault((MessageContext)msgContext, (String)"ReplyTo");
                }
                if (!AddressingHelper.isSyncFaultAllowed((MessageContext)msgContext)) {
                    anonEPR = new EndpointReference("http://www.w3.org/2005/08/addressing/anonymous");
                    msgContext.setReplyTo(anonEPR);
                    msgContext.setFaultTo(anonEPR);
                    AddressingFaultsHelper.triggerOnlyAnonymousAddressSupportedFault((MessageContext)msgContext, (String)"FaultTo");
                }
            } else if ("asynchronous".equals(value)) {
                if (!AddressingHelper.isReplyRedirected((MessageContext)msgContext)) {
                    AddressingFaultsHelper.triggerOnlyNonAnonymousAddressSupportedFault((MessageContext)msgContext, (String)"ReplyTo");
                }
                if (!AddressingHelper.isFaultRedirected((MessageContext)msgContext)) {
                    AddressingFaultsHelper.triggerOnlyNonAnonymousAddressSupportedFault((MessageContext)msgContext, (String)"FaultTo");
                }
            }
        }
    }

    private void checkMessageIDHeader(MessageContext msgContext) throws AxisFault {
        String messageId;
        String mep;
        int mepConstant;
        String namespace = (String)msgContext.getLocalProperty("WSAddressingVersion");
        if (!"http://www.w3.org/2005/08/addressing".equals(namespace)) {
            return;
        }
        AxisOperation axisOperation = msgContext.getAxisOperation();
        if (!(axisOperation == null || (mepConstant = Utils.getAxisSpecifMEPConstant((String)(mep = axisOperation.getMessageExchangePattern()))) != 12 && mepConstant != 13 && mepConstant != 11 || (messageId = msgContext.getOptions().getMessageId()) != null && !"".equals(messageId))) {
            AddressingFaultsHelper.triggerMessageAddressingRequiredFault((MessageContext)msgContext, (String)"MessageID");
        }
    }
}

