/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.handlers.addressing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AttributeHelper;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.addressing.i18n.AddressingMessages;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingOutHandler
extends AbstractHandler
implements AddressingConstants {
    private static final Log log = LogFactory.getLog(AddressingOutHandler.class);
    private boolean includeOptionalHeaders;
    private boolean disableAddressing;

    public void init(HandlerDescription arg0) {
        super.init(arg0);
        Parameter param = arg0.getParameter("includeOptionalHeaders");
        String value = Utils.getParameterValue((Parameter)param);
        this.includeOptionalHeaders = JavaUtils.isTrueExplicitly((String)value);
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)("includeOptionalHeaders=" + this.includeOptionalHeaders));
        }
        param = arg0.getParameter("disableAddressingForOutMessages");
        value = Utils.getParameterValue((Parameter)param);
        this.disableAddressing = JavaUtils.isTrueExplicitly((String)value);
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)("disableAddressing=" + this.disableAddressing));
        }
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        boolean disableAddressing = msgContext.isPropertyTrue("disableAddressingForOutMessages", this.disableAddressing);
        if (disableAddressing) {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(msgContext.getLogIDString() + " Addressing is disabled. Not adding WS-Addressing headers."));
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        Object addressingVersionFromCurrentMsgCtxt = msgContext.getProperty("WSAddressingVersion");
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)("Addressing version string from messageContext=" + addressingVersionFromCurrentMsgCtxt));
        }
        boolean isSubmissionNamespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(addressingVersionFromCurrentMsgCtxt);
        boolean includeOptionalHeaders = msgContext.isPropertyTrue("includeOptionalHeaders", this.includeOptionalHeaders);
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)("includeOptionalHeaders=" + includeOptionalHeaders));
        }
        boolean addMustUnderstandAttribute = msgContext.isPropertyTrue("addMustUnderstandToAddressingHeaders");
        boolean replaceHeaders = msgContext.isPropertyTrue("ReplaceAddressingHeaders");
        String role = (String)msgContext.getProperty("wsaddressingRole");
        WSAHeaderWriter writer = new WSAHeaderWriter(msgContext, isSubmissionNamespace, addMustUnderstandAttribute, replaceHeaders, includeOptionalHeaders, role);
        writer.writeHeaders();
        return Handler.InvocationResponse.CONTINUE;
    }

    private class WSAHeaderWriter {
        private MessageContext messageContext;
        private SOAPEnvelope envelope;
        private SOAPHeader header;
        private SOAPFactory factory;
        private Options messageContextOptions;
        private OMNamespace addressingNamespaceObject;
        private String addressingNamespace;
        private String addressingRole;
        private boolean isFinalAddressingNamespace;
        private boolean addMustUnderstandAttribute;
        private boolean replaceHeaders;
        private boolean includeOptionalHeaders;
        private ArrayList existingWSAHeaders = null;

        public WSAHeaderWriter(MessageContext mc, boolean isSubmissionNamespace, boolean addMU, boolean replace, boolean includeOptional, String role) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)("WSAHeaderWriter: isFinal=" + !isSubmissionNamespace + " addMU=" + addMU + " replace=" + replace + " includeOptional=" + includeOptional + " role=" + role));
            }
            this.messageContext = mc;
            this.envelope = mc.getEnvelope();
            this.factory = (SOAPFactory)this.envelope.getOMFactory();
            this.messageContextOptions = this.messageContext.getOptions();
            this.addressingNamespace = isSubmissionNamespace ? "http://schemas.xmlsoap.org/ws/2004/08/addressing" : "http://www.w3.org/2005/08/addressing";
            this.header = this.envelope.getHeader();
            if (this.header == null) {
                this.header = this.factory.createSOAPHeader(this.envelope);
            } else {
                ArrayList addressingHeaders = this.header.getHeaderBlocksWithNSURI(this.addressingNamespace);
                if (addressingHeaders != null && !addressingHeaders.isEmpty()) {
                    this.existingWSAHeaders = new ArrayList(addressingHeaders.size());
                    for (SOAPHeaderBlock oe : addressingHeaders) {
                        if (this.addressingRole != null && this.addressingRole.length() != 0 && !this.addressingRole.equals(oe.getRole())) continue;
                        this.existingWSAHeaders.add(oe.getLocalName());
                    }
                }
                if (addressingHeaders != null && addressingHeaders.size() == 0) {
                    addressingHeaders = null;
                }
            }
            this.isFinalAddressingNamespace = !isSubmissionNamespace;
            this.addMustUnderstandAttribute = addMU;
            this.replaceHeaders = replace;
            this.includeOptionalHeaders = includeOptional;
            this.addressingRole = role;
            if (!this.isFinalAddressingNamespace && mc.getTo() == null) {
                mc.setTo(new EndpointReference("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous"));
            }
        }

        public void writeHeaders() throws AxisFault {
            this.addressingNamespaceObject = this.header.declareNamespace(this.addressingNamespace, "wsa");
            this.processToEPR();
            this.processReplyTo();
            this.processFromEPR();
            this.processFaultToEPR();
            this.processMessageID();
            this.processWSAAction();
            this.processRelatesTo();
            this.processFaultsInfoIfPresent();
            this.processMustUnderstandProperty();
        }

        private void processMessageID() {
            String messageID = this.messageContextOptions.getMessageId();
            if (messageID == null && this.includeOptionalHeaders) {
                messageID = UUIDGenerator.getUUID();
                this.messageContextOptions.setMessageId(messageID);
            }
            if (messageID != null && !this.isAddressingHeaderAlreadyAvailable("MessageID", false)) {
                ArrayList attributes = (ArrayList)this.messageContext.getLocalProperty("messageidAttributes");
                this.createSOAPHeaderBlock(messageID, "MessageID", attributes);
            }
        }

        private void processWSAAction() throws AxisFault {
            String action = this.messageContextOptions.getAction();
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(this.messageContext.getLogIDString() + " processWSAAction: action from messageContext: " + action));
            }
            if (action == null || action.length() == 0) {
                if (this.messageContext.getAxisOperation() != null) {
                    action = this.messageContext.getAxisOperation().getOutputAction();
                    if (action != null) {
                        this.messageContext.setWSAAction(action);
                    }
                    if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                        log.trace((Object)(this.messageContext.getLogIDString() + " processWSAAction: action from AxisOperation: " + action));
                    }
                }
            } else if (this.isFinalAddressingNamespace) {
                if ("http://schemas.xmlsoap.org/ws/2004/08/addressing/fault".equals(action)) {
                    action = "http://www.w3.org/2005/08/addressing/fault";
                    this.messageContextOptions.setAction(action);
                }
            } else if ("http://www.w3.org/2005/08/addressing/fault".equals(action)) {
                action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault";
                this.messageContextOptions.setAction(action);
            } else if ("http://www.w3.org/2005/08/addressing/soap/fault".equals(action)) {
                action = "http://schemas.xmlsoap.org/ws/2004/08/addressing/fault";
                this.messageContextOptions.setAction(action);
            }
            if (!this.isAddressingHeaderAlreadyAvailable("Action", false)) {
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)(this.messageContext.getLogIDString() + " processWSAAction: No existing wsa:Action header found"));
                }
                if (action == null || action.length() == 0) {
                    if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                        log.trace((Object)(this.messageContext.getLogIDString() + " processWSAAction: No action to add to header"));
                    }
                    if (!this.messageContext.isPropertyTrue("disableAddressingOutboundValidation")) {
                        throw new AxisFault(AddressingMessages.getMessage((String)"outboundNoAction"));
                    }
                } else {
                    if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                        log.trace((Object)(this.messageContext.getLogIDString() + " processWSAAction: Adding action to header: " + action));
                    }
                    ArrayList attributes = (ArrayList)this.messageContext.getLocalProperty("actionAttributes");
                    this.createSOAPHeaderBlock(action, "Action", attributes);
                }
            }
        }

        private void processFaultsInfoIfPresent() {
            OMElement detailElement = AddressingFaultsHelper.getDetailElementForAddressingFault((MessageContext)this.messageContext, (OMNamespace)this.addressingNamespaceObject);
            if (detailElement != null) {
                SOAPFault fault;
                if (this.isFinalAddressingNamespace && this.messageContext.isSOAP11()) {
                    if (!this.isAddressingHeaderAlreadyAvailable("FaultDetail", false)) {
                        SOAPHeaderBlock faultDetail = this.header.addHeaderBlock("FaultDetail", this.addressingNamespaceObject);
                        faultDetail.addChild((OMNode)ElementHelper.importOMElement((OMElement)detailElement, (OMFactory)this.factory));
                    }
                } else if (!this.messageContext.isSOAP11() && (fault = this.envelope.getBody().getFault()) != null && fault.getDetail() != null) {
                    fault.getDetail().addDetailEntry(ElementHelper.importOMElement((OMElement)detailElement, (OMFactory)this.factory));
                }
            }
        }

        private void processRelatesTo() {
            RelatesTo[] relatesTo;
            if (!this.isAddressingHeaderAlreadyAvailable("RelatesTo", true) && (relatesTo = this.messageContextOptions.getRelationships()) != null) {
                int length = relatesTo.length;
                for (int i = 0; i < length; ++i) {
                    OMElement relatesToHeader = this.createSOAPHeaderBlock(relatesTo[i].getValue(), "RelatesTo", relatesTo[i].getExtensibilityAttributes());
                    String relationshipType = relatesTo[i].getRelationshipType();
                    if (relatesToHeader == null) continue;
                    if (!this.includeOptionalHeaders && ("http://www.w3.org/2005/08/addressing/reply".equals(relationshipType) || "wsa:Reply".equals(relationshipType))) {
                        relationshipType = null;
                    }
                    if (relationshipType == null) continue;
                    relatesToHeader.addAttribute("RelationshipType", relationshipType, null);
                }
            }
        }

        private void processFaultToEPR() throws AxisFault {
            EndpointReference epr = this.messageContextOptions.getFaultTo();
            String headerName = "FaultTo";
            if (epr != null && !this.isAddressingHeaderAlreadyAvailable(headerName, false)) {
                this.addToSOAPHeader(epr, headerName);
            }
        }

        private void processFromEPR() throws AxisFault {
            EndpointReference epr = this.messageContextOptions.getFrom();
            String headerName = "From";
            if (epr != null && !this.isAddressingHeaderAlreadyAvailable(headerName, false)) {
                this.addToSOAPHeader(epr, headerName);
            }
        }

        private void processReplyTo() throws AxisFault {
            EndpointReference epr = this.messageContextOptions.getReplyTo();
            String headerName = "ReplyTo";
            if (!this.isAddressingHeaderAlreadyAvailable(headerName, false)) {
                this.addToSOAPHeader(epr, headerName);
            }
        }

        private void processToEPR() throws AxisFault {
            EndpointReference epr = this.messageContextOptions.getTo();
            if (epr != null && !this.isAddressingHeaderAlreadyAvailable("To", false)) {
                try {
                    this.processToEPRReferenceInformation(epr.getAllReferenceParameters());
                }
                catch (Exception e) {
                    throw new AxisFault(AddressingMessages.getMessage((String)"referenceParameterError"), (Throwable)e);
                }
                String address = epr.getAddress();
                if (address != null && address.length() != 0) {
                    if (!this.includeOptionalHeaders && this.isFinalAddressingNamespace && epr.isWSAddressingAnonymous()) {
                        return;
                    }
                    this.createSOAPHeaderBlock(address, "To", epr.getAddressAttributes());
                }
            }
        }

        private OMElement createSOAPHeaderBlock(String value, String headerName, ArrayList attributes) {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)("createSOAPHeaderBlock: value=" + value + " headerName=" + headerName));
            }
            if (value != null && value.length() != 0) {
                SOAPHeaderBlock soapHeaderBlock = this.header.addHeaderBlock(headerName, this.addressingNamespaceObject);
                soapHeaderBlock.addChild((OMNode)this.factory.createOMText(value));
                if (attributes != null && !attributes.isEmpty()) {
                    Iterator attrIterator = attributes.iterator();
                    while (attrIterator.hasNext()) {
                        AttributeHelper.importOMAttribute((OMAttribute)((OMAttribute)attrIterator.next()), (OMElement)soapHeaderBlock);
                    }
                }
                this.addRoleToHeader(soapHeaderBlock);
                return soapHeaderBlock;
            }
            return null;
        }

        private void addToSOAPHeader(EndpointReference epr, String headerName) throws AxisFault {
            String anonymous;
            String prefix = this.addressingNamespaceObject.getPrefix();
            String string = anonymous = this.isFinalAddressingNamespace ? "http://www.w3.org/2005/08/addressing/anonymous" : "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous";
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)("addToSOAPHeader: epr=" + epr + " headerName=" + headerName));
            }
            if (epr == null) {
                if (!this.includeOptionalHeaders && this.isFinalAddressingNamespace && "ReplyTo".equals(headerName)) {
                    return;
                }
                epr = new EndpointReference(anonymous);
            } else {
                if (!this.isFinalAddressingNamespace && epr.hasNoneAddress()) {
                    return;
                }
                if (epr.isWSAddressingAnonymous()) {
                    if (!this.includeOptionalHeaders && this.isFinalAddressingNamespace && "ReplyTo".equals(headerName)) {
                        return;
                    }
                    epr.setAddress(anonymous);
                }
            }
            OMElement soapHeaderBlock = EndpointReferenceHelper.toOM((OMFactory)this.factory, (EndpointReference)epr, (QName)new QName(this.addressingNamespace, headerName, prefix), (String)this.addressingNamespace);
            this.addRoleToHeader((SOAPHeaderBlock)soapHeaderBlock);
            this.header.addChild((OMNode)soapHeaderBlock);
        }

        private void processToEPRReferenceInformation(Map referenceInformation) throws Exception {
            AxisEndpoint endpoint;
            AxisService service;
            if (referenceInformation != null) {
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)("processToEPRReferenceInformation: " + referenceInformation));
                }
                for (OMElement omElement : referenceInformation.values()) {
                    SOAPHeaderBlock newElement = ElementHelper.toSOAPHeaderBlock((OMElement)omElement, (SOAPFactory)this.factory);
                    if (this.isFinalAddressingNamespace) {
                        newElement.addAttribute("IsReferenceParameter", "true", this.addressingNamespaceObject);
                    }
                    this.addRoleToHeader(newElement);
                    this.header.addChild((OMNode)newElement);
                }
            }
            if ((service = this.messageContext.getAxisService()) != null && (endpoint = service.getEndpoint(service.getEndpointName())) != null) {
                ArrayList referenceparameters = (ArrayList)endpoint.getParameterValue("referenceParameters");
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)("processToEPRReferenceInformation: Reference Parameters from WSDL:" + referenceparameters));
                }
                if (referenceparameters != null) {
                    for (OMElement omElement : referenceparameters) {
                        SOAPHeaderBlock newElement = ElementHelper.toSOAPHeaderBlock((OMElement)omElement, (SOAPFactory)this.factory);
                        if (this.isFinalAddressingNamespace) {
                            newElement.addAttribute("IsReferenceParameter", "true", this.addressingNamespaceObject);
                        }
                        this.addRoleToHeader(newElement);
                        this.header.addChild((OMNode)newElement);
                    }
                }
            }
        }

        private boolean isAddressingHeaderAlreadyAvailable(String name, boolean multipleHeaders) {
            boolean status = false;
            if (multipleHeaders) {
                if (this.replaceHeaders) {
                    QName qname = new QName(this.addressingNamespace, name, "wsa");
                    Iterator iterator = this.header.getChildrenWithName(qname);
                    while (iterator.hasNext()) {
                        iterator.next();
                        iterator.remove();
                    }
                }
            } else {
                boolean exists = this.didAddressingHeaderExist(name);
                if (exists && this.replaceHeaders) {
                    QName qname = new QName(this.addressingNamespace, name, "wsa");
                    OMElement addressingHeader = this.header.getFirstChildWithName(qname);
                    if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                        log.trace((Object)("isAddressingHeaderAlreadyAvailable: Removing existing header:" + addressingHeader.getLocalName()));
                    }
                    addressingHeader.detach();
                } else {
                    status = exists;
                }
            }
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)("isAddressingHeaderAlreadyAvailable: name=" + name + " status=" + status));
            }
            return status;
        }

        private boolean didAddressingHeaderExist(String headerName) {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)("didAddressingHeaderExist: headerName=" + headerName));
            }
            boolean result = false;
            if (this.existingWSAHeaders != null) {
                result = this.existingWSAHeaders.contains(headerName);
                if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                    log.trace((Object)("didAddressingHeaderExist: existingWSAHeaders=" + this.existingWSAHeaders + " result=" + result));
                }
            }
            return result;
        }

        private void processMustUnderstandProperty() {
            if (this.addMustUnderstandAttribute) {
                ArrayList headers = this.header.getHeaderBlocksWithNSURI(this.addressingNamespace);
                int size = headers.size();
                for (int i = 0; i < size; ++i) {
                    SOAPHeaderBlock soapHeaderBlock = (SOAPHeaderBlock)headers.get(i);
                    soapHeaderBlock.setMustUnderstand(true);
                    if (!LoggingControl.debugLoggingAllowed || !log.isTraceEnabled()) continue;
                    log.trace((Object)("processMustUnderstandProperty: Setting mustUnderstand=true on: " + soapHeaderBlock.getLocalName()));
                }
            }
        }

        private void addRoleToHeader(SOAPHeaderBlock header) {
            if (this.addressingRole == null || this.addressingRole.length() == 0) {
                return;
            }
            header.setRole(this.addressingRole);
        }
    }
}

