/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.codegentest;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.codegentest.CustomDecimal;

public class CustomDecimalConversion
extends Conversion<CustomDecimal> {
    public Class<CustomDecimal> getConvertedType() {
        return CustomDecimal.class;
    }

    public String getLogicalTypeName() {
        return "decimal";
    }

    public CustomDecimal fromBytes(ByteBuffer value, Schema schema, LogicalType type) {
        int scale = ((LogicalTypes.Decimal)type).getScale();
        byte[] bytes = value.get(new byte[value.remaining()]).array();
        return new CustomDecimal(new BigInteger(bytes), scale);
    }

    public ByteBuffer toBytes(CustomDecimal value, Schema schema, LogicalType type) {
        int scale = ((LogicalTypes.Decimal)type).getScale();
        return ByteBuffer.wrap(value.toByteArray(scale));
    }
}

