/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.jetty;

import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.TestProtocolSpecific;
import org.apache.avro.generic.GenericData;
import org.apache.avro.ipc.HttpTransceiver;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.ipc.jetty.HttpServer;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.test.Simple;
import org.junit.Assert;
import org.junit.Test;

public class TestProtocolHttp
extends TestProtocolSpecific {
    public Server createServer(Responder testResponder) throws Exception {
        return new HttpServer(testResponder, 0);
    }

    public Transceiver createTransceiver() throws Exception {
        return new HttpTransceiver(new URL("http://127.0.0.1:" + server.getPort() + "/"));
    }

    protected int getExpectedHandshakeCount() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeout() throws Throwable {
        ServerSocket s = new ServerSocket(0);
        HttpTransceiver client = new HttpTransceiver(new URL("http://127.0.0.1:" + s.getLocalPort() + "/"));
        client.setTimeout(100);
        Simple proxy = (Simple)SpecificRequestor.getClient(Simple.class, (Transceiver)client);
        try {
            proxy.hello("foo");
            Assert.fail((String)"Should have failed with an exception");
        }
        catch (AvroRuntimeException e) {
            Assert.assertTrue((String)("Got unwanted exception: " + e.getCause()), (boolean)(e.getCause() instanceof SocketTimeoutException));
        }
        finally {
            s.close();
        }
    }

    @Test
    public void testStatelessOneway() throws Exception {
        Protocol protocol = new Protocol("Simple", "org.apache.avro.test");
        Protocol.Message message = protocol.createMessage("ack", null, new LinkedHashMap(), Schema.createRecord(new ArrayList()), Schema.create((Schema.Type)Schema.Type.NULL), Schema.createUnion(new ArrayList()));
        protocol.getMessages().put("ack", message);
        GenericRequestor requestor = new GenericRequestor(protocol, this.createTransceiver());
        requestor.request("ack", (Object)new GenericData.Record(message.getRequest()));
        requestor.request("ack", (Object)new GenericData.Record(message.getRequest()));
    }
}

