/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.storm.hook;

import java.util.Map;
import org.apache.atlas.plugin.classloader.AtlasPluginClassLoader;
import org.apache.storm.ISubmitterHook;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.generated.TopologyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormAtlasHook
implements ISubmitterHook {
    private static final Logger LOG = LoggerFactory.getLogger(StormAtlasHook.class);
    private static final String ATLAS_PLUGIN_TYPE = "storm";
    private static final String ATLAS_STORM_HOOK_IMPL_CLASSNAME = "org.apache.atlas.storm.hook.StormAtlasHook";
    private AtlasPluginClassLoader atlasPluginClassLoader = null;
    private ISubmitterHook stormHook = null;

    public StormAtlasHook() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(TopologyInfo topologyInfo, Map stormConf, StormTopology stormTopology) throws IllegalAccessException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> StormAtlasHook.notify({}, {}, {})", new Object[]{topologyInfo, stormConf, stormTopology});
        }
        try {
            this.activatePluginClassLoader();
            this.stormHook.notify(topologyInfo, stormConf, stormTopology);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== StormAtlasHook.notify({}, {}, {})", new Object[]{topologyInfo, stormConf, stormTopology});
        }
    }

    private void initialize() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> StormAtlasHook.initialize()");
        }
        try {
            this.atlasPluginClassLoader = AtlasPluginClassLoader.getInstance((String)ATLAS_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(ATLAS_STORM_HOOK_IMPL_CLASSNAME, true, (ClassLoader)this.atlasPluginClassLoader);
            this.activatePluginClassLoader();
            this.stormHook = (ISubmitterHook)cls.newInstance();
        }
        catch (Exception excp) {
            LOG.error("Error instantiating Atlas hook implementation", (Throwable)excp);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== StormAtlasHook.initialize()");
        }
    }

    private void activatePluginClassLoader() {
        if (this.atlasPluginClassLoader != null) {
            this.atlasPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.atlasPluginClassLoader != null) {
            this.atlasPluginClassLoader.deactivate();
        }
    }
}

