/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.sqoop.hook;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.hive.bridge.HiveMetaStoreBridge;
import org.apache.atlas.hive.model.HiveDataTypes;
import org.apache.atlas.hook.AtlasHook;
import org.apache.atlas.hook.AtlasHookException;
import org.apache.atlas.sqoop.model.SqoopDataTypes;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.v1.model.notification.HookNotificationV1;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.sqoop.SqoopJobDataPublisher;
import org.apache.sqoop.util.ImportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopHook
extends SqoopJobDataPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(SqoopHook.class);
    public static final String CONF_PREFIX = "atlas.hook.sqoop.";
    public static final String HOOK_NUM_RETRIES = "atlas.hook.sqoop.numRetries";
    public static final String ATLAS_CLUSTER_NAME = "atlas.cluster.name";
    public static final String DEFAULT_CLUSTER_NAME = "primary";
    public static final String USER = "userName";
    public static final String DB_STORE_TYPE = "dbStoreType";
    public static final String DB_STORE_USAGE = "storeUse";
    public static final String SOURCE = "source";
    public static final String DESCRIPTION = "description";
    public static final String STORE_URI = "storeUri";
    public static final String OPERATION = "operation";
    public static final String START_TIME = "startTime";
    public static final String END_TIME = "endTime";
    public static final String CMD_LINE_OPTS = "commandlineOpts";
    public static final String INPUTS = "inputs";
    public static final String OUTPUTS = "outputs";

    public Referenceable createHiveDatabaseInstance(String clusterName, String dbName) {
        Referenceable dbRef = new Referenceable(HiveDataTypes.HIVE_DB.getName(), new String[0]);
        dbRef.set("clusterName", (Object)clusterName);
        dbRef.set("name", (Object)dbName);
        dbRef.set("qualifiedName", (Object)HiveMetaStoreBridge.getDBQualifiedName((String)clusterName, (String)dbName));
        return dbRef;
    }

    public Referenceable createHiveTableInstance(String clusterName, Referenceable dbRef, String tableName, String dbName) {
        Referenceable tableRef = new Referenceable(HiveDataTypes.HIVE_TABLE.getName(), new String[0]);
        tableRef.set("qualifiedName", (Object)HiveMetaStoreBridge.getTableQualifiedName((String)clusterName, (String)dbName, (String)tableName));
        tableRef.set("name", (Object)tableName.toLowerCase());
        tableRef.set("db", (Object)dbRef);
        return tableRef;
    }

    private Referenceable createDBStoreInstance(SqoopJobDataPublisher.Data data) throws ImportException {
        Referenceable storeRef = new Referenceable(SqoopDataTypes.SQOOP_DBDATASTORE.getName(), new String[0]);
        String table = data.getStoreTable();
        String query = data.getStoreQuery();
        if (StringUtils.isBlank((CharSequence)table) && StringUtils.isBlank((CharSequence)query)) {
            throw new ImportException("Both table and query cannot be empty for DBStoreInstance");
        }
        String usage = table != null ? "TABLE" : "QUERY";
        String source = table != null ? table : query;
        String name = SqoopHook.getSqoopDBStoreName(data);
        storeRef.set("name", (Object)name);
        storeRef.set("qualifiedName", (Object)name);
        storeRef.set(DB_STORE_TYPE, (Object)data.getStoreType());
        storeRef.set(DB_STORE_USAGE, (Object)usage);
        storeRef.set(STORE_URI, (Object)data.getUrl());
        storeRef.set(SOURCE, (Object)source);
        storeRef.set(DESCRIPTION, (Object)"");
        storeRef.set("owner", (Object)data.getUser());
        return storeRef;
    }

    private Referenceable createSqoopProcessInstance(Referenceable dbStoreRef, Referenceable hiveTableRef, SqoopJobDataPublisher.Data data, String clusterName) {
        Referenceable procRef = new Referenceable(SqoopDataTypes.SQOOP_PROCESS.getName(), new String[0]);
        String sqoopProcessName = SqoopHook.getSqoopProcessName(data, clusterName);
        procRef.set("name", (Object)sqoopProcessName);
        procRef.set("qualifiedName", (Object)sqoopProcessName);
        procRef.set(OPERATION, (Object)data.getOperation());
        if (SqoopHook.isImportOperation(data)) {
            procRef.set(INPUTS, (Object)dbStoreRef);
            procRef.set(OUTPUTS, (Object)hiveTableRef);
        } else {
            procRef.set(INPUTS, (Object)hiveTableRef);
            procRef.set(OUTPUTS, (Object)dbStoreRef);
        }
        procRef.set(USER, (Object)data.getUser());
        procRef.set(START_TIME, (Object)new Date(data.getStartTime()));
        procRef.set(END_TIME, (Object)new Date(data.getEndTime()));
        HashMap<String, String> sqoopOptionsMap = new HashMap<String, String>();
        Properties options = data.getOptions();
        for (Object k : options.keySet()) {
            sqoopOptionsMap.put((String)k, (String)options.get(k));
        }
        procRef.set(CMD_LINE_OPTS, sqoopOptionsMap);
        return procRef;
    }

    static String getSqoopProcessName(SqoopJobDataPublisher.Data data, String clusterName) {
        StringBuilder name = new StringBuilder(String.format("sqoop %s --connect %s", data.getOperation(), data.getUrl()));
        if (StringUtils.isNotEmpty((CharSequence)data.getStoreTable())) {
            name.append(" --table ").append(data.getStoreTable());
        }
        if (StringUtils.isNotEmpty((CharSequence)data.getStoreQuery())) {
            name.append(" --query ").append(data.getStoreQuery());
        }
        name.append(String.format(" --hive-%s --hive-database %s --hive-table %s --hive-cluster %s", data.getOperation(), data.getHiveDB().toLowerCase(), data.getHiveTable().toLowerCase(), clusterName));
        return name.toString();
    }

    static String getSqoopDBStoreName(SqoopJobDataPublisher.Data data) {
        StringBuilder name = new StringBuilder(String.format("%s --url %s", data.getStoreType(), data.getUrl()));
        if (StringUtils.isNotEmpty((CharSequence)data.getStoreTable())) {
            name.append(" --table ").append(data.getStoreTable());
        }
        if (StringUtils.isNotEmpty((CharSequence)data.getStoreQuery())) {
            name.append(" --query ").append(data.getStoreQuery());
        }
        return name.toString();
    }

    static boolean isImportOperation(SqoopJobDataPublisher.Data data) {
        return data.getOperation().toLowerCase().equals("import");
    }

    public void publish(SqoopJobDataPublisher.Data data) throws AtlasHookException {
        try {
            Configuration atlasProperties = ApplicationProperties.get();
            String clusterName = atlasProperties.getString(ATLAS_CLUSTER_NAME, DEFAULT_CLUSTER_NAME);
            Referenceable dbStoreRef = this.createDBStoreInstance(data);
            Referenceable dbRef = this.createHiveDatabaseInstance(clusterName, data.getHiveDB());
            Referenceable hiveTableRef = this.createHiveTableInstance(clusterName, dbRef, data.getHiveTable(), data.getHiveDB());
            Referenceable procRef = this.createSqoopProcessInstance(dbStoreRef, hiveTableRef, data, clusterName);
            int maxRetries = atlasProperties.getInt(HOOK_NUM_RETRIES, 3);
            HookNotificationV1.EntityCreateRequest message = new HookNotificationV1.EntityCreateRequest(AtlasHook.getUser(), new Referenceable[]{dbStoreRef, dbRef, hiveTableRef, procRef});
            AtlasHook.notifyEntities(Arrays.asList(message), (int)maxRetries);
        }
        catch (Exception e) {
            throw new AtlasHookException("SqoopHook.publish() failed.", (Throwable)e);
        }
    }

    static {
        org.apache.hadoop.conf.Configuration.addDefaultResource((String)"sqoop-site.xml");
    }
}

