/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.sqoop.hook;

import org.apache.atlas.plugin.classloader.AtlasPluginClassLoader;
import org.apache.sqoop.SqoopJobDataPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopHook
extends SqoopJobDataPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(SqoopHook.class);
    private static final String ATLAS_PLUGIN_TYPE = "sqoop";
    private static final String ATLAS_SQOOP_HOOK_IMPL_CLASSNAME = "org.apache.atlas.sqoop.hook.SqoopHook";
    private AtlasPluginClassLoader atlasPluginClassLoader = null;
    private SqoopJobDataPublisher sqoopHookImpl = null;

    public SqoopHook() {
        this.initialize();
    }

    public void publish(SqoopJobDataPublisher.Data data) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> SqoopHook.run({})", (Object)data);
        }
        try {
            this.activatePluginClassLoader();
            this.sqoopHookImpl.publish(data);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== SqoopHook.run({})", (Object)data);
        }
    }

    private void initialize() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HiveHook.initialize()");
        }
        try {
            this.atlasPluginClassLoader = AtlasPluginClassLoader.getInstance((String)ATLAS_PLUGIN_TYPE, ((Object)((Object)this)).getClass());
            Class<?> cls = Class.forName(ATLAS_SQOOP_HOOK_IMPL_CLASSNAME, true, (ClassLoader)this.atlasPluginClassLoader);
            this.activatePluginClassLoader();
            this.sqoopHookImpl = (SqoopJobDataPublisher)cls.newInstance();
        }
        catch (Exception excp) {
            LOG.error("Error instantiating Atlas hook implementation", (Throwable)excp);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HiveHook.initialize()");
        }
    }

    private void activatePluginClassLoader() {
        if (this.atlasPluginClassLoader != null) {
            this.atlasPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.atlasPluginClassLoader != null) {
            this.atlasPluginClassLoader.deactivate();
        }
    }
}

