/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.rewrite;

import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.hive.rewrite.ASTRewriter;
import org.apache.atlas.hive.rewrite.RewriteContext;
import org.apache.atlas.hive.rewrite.RewriteException;
import org.apache.hadoop.hive.ql.parse.ASTNode;

public class LiteralRewriter
implements ASTRewriter {
    public static Map<Integer, String> LITERAL_TOKENS = new HashMap<Integer, String>(){
        {
            this.put(302, "NUMBER_LITERAL");
            this.put(19, "DIGIT_LITERAL");
            this.put(25, "HEX_LITERAL");
            this.put(22, "EXPONENT_LITERAL");
            this.put(313, "'STRING_LITERAL'");
            this.put(7, "BIGINT_LITERAL");
            this.put(312, "SMALLINT_LITERAL");
            this.put(315, "TINYINT_LITERAL");
            this.put(18, "DECIMAL_LITERAL");
            this.put(8, "BYTE_LENGTH_LITERAL");
            this.put(861, "'STRING_LITERAL_SEQ'");
            this.put(653, "'CHARSET_LITERAL'");
            this.put(265, "BOOLEAN_LITERAL");
            this.put(107, "BOOLEAN_LITERAL");
        }
    };

    @Override
    public void rewrite(RewriteContext ctx, ASTNode node) throws RewriteException {
        try {
            this.processLiterals(ctx, node);
        }
        catch (Exception e) {
            throw new RewriteException("Could not normalize query", e);
        }
    }

    private void processLiterals(RewriteContext ctx, ASTNode node) {
        if (this.isLiteral(node)) {
            this.replaceLiteral(ctx, node);
        }
    }

    private boolean isLiteral(ASTNode node) {
        return LITERAL_TOKENS.containsKey(node.getType());
    }

    void replaceLiteral(RewriteContext ctx, ASTNode valueNode) {
        String literalVal = LITERAL_TOKENS.get(valueNode.getType());
        ctx.getTokenRewriteStream().replace(valueNode.getTokenStartIndex(), valueNode.getTokenStopIndex(), (Object)literalVal);
    }
}

