/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.rewrite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.hive.rewrite.ASTRewriter;
import org.apache.atlas.hive.rewrite.LiteralRewriter;
import org.apache.atlas.hive.rewrite.RewriteContext;
import org.apache.atlas.hive.rewrite.RewriteException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveASTRewriter {
    private Context queryContext;
    private RewriteContext rwCtx;
    private List<ASTRewriter> rewriters = new ArrayList<ASTRewriter>();
    private static final Logger LOG = LoggerFactory.getLogger(HiveASTRewriter.class);

    public HiveASTRewriter(HiveConf conf) throws RewriteException {
        try {
            this.queryContext = new Context((Configuration)conf);
            this.setUpRewriters();
        }
        catch (IOException e) {
            throw new RewriteException("Exception while rewriting query : ", e);
        }
    }

    private void setUpRewriters() throws RewriteException {
        LiteralRewriter rewriter = new LiteralRewriter();
        this.rewriters.add(rewriter);
    }

    public String rewrite(String sourceQry) throws RewriteException {
        String result = sourceQry;
        ASTNode tree = null;
        try {
            ParseDriver pd = new ParseDriver();
            tree = pd.parse(sourceQry, this.queryContext, true);
            tree = ParseUtils.findRootNonNullToken((ASTNode)tree);
            this.rwCtx = new RewriteContext(sourceQry, tree, this.queryContext.getTokenRewriteStream());
            this.rewrite(tree);
            result = this.toSQL();
        }
        catch (ParseException e) {
            LOG.error("Could not parse the query {} ", (Object)sourceQry, (Object)e);
            throw new RewriteException("Could not parse query : ", (Exception)((Object)e));
        }
        return result;
    }

    private void rewrite(ASTNode origin) throws RewriteException {
        ASTNode node = origin;
        if (node != null) {
            for (ASTRewriter rewriter : this.rewriters) {
                rewriter.rewrite(this.rwCtx, node);
            }
            if (node.getChildren() != null) {
                for (int i = 0; i < node.getChildren().size(); ++i) {
                    this.rewrite((ASTNode)node.getChild(i));
                }
            }
        }
    }

    public String toSQL() {
        return this.rwCtx.getTokenRewriteStream().toString();
    }

    public String printAST() {
        return this.rwCtx.getOriginNode().dump();
    }
}

