/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.AtlasException;
import org.apache.atlas.addons.ModelDefinitionDump;
import org.apache.atlas.hive.model.HiveDataTypes;
import org.apache.atlas.typesystem.TypesDef;
import org.apache.atlas.typesystem.json.TypesSerialization;
import org.apache.atlas.typesystem.types.AttributeDefinition;
import org.apache.atlas.typesystem.types.ClassType;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.EnumType;
import org.apache.atlas.typesystem.types.EnumTypeDefinition;
import org.apache.atlas.typesystem.types.EnumValue;
import org.apache.atlas.typesystem.types.HierarchicalTypeDefinition;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.Multiplicity;
import org.apache.atlas.typesystem.types.StructType;
import org.apache.atlas.typesystem.types.StructTypeDefinition;
import org.apache.atlas.typesystem.types.TraitType;
import org.apache.atlas.typesystem.types.utils.TypesUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveDataModelGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(HiveDataModelGenerator.class);
    private static final DataTypes.MapType STRING_MAP_TYPE = new DataTypes.MapType((IDataType)DataTypes.STRING_TYPE, (IDataType)DataTypes.STRING_TYPE);
    private final Map<String, HierarchicalTypeDefinition<ClassType>> classTypeDefinitions = new HashMap<String, HierarchicalTypeDefinition<ClassType>>();
    private final Map<String, EnumTypeDefinition> enumTypeDefinitionMap = new HashMap<String, EnumTypeDefinition>();
    private final Map<String, StructTypeDefinition> structTypeDefinitionMap = new HashMap<String, StructTypeDefinition>();
    public static final String COMMENT = "comment";
    public static final String PARAMETERS = "parameters";
    public static final String COLUMNS = "columns";
    public static final String POSITION = "position";
    public static final String PART_COLS = "partitionKeys";
    public static final String TABLE_ALIAS_LIST = "aliases";
    public static final String STORAGE_NUM_BUCKETS = "numBuckets";
    public static final String STORAGE_IS_STORED_AS_SUB_DIRS = "storedAsSubDirectories";
    public static final String TABLE = "table";
    public static final String DB = "db";
    public static final String STORAGE_DESC = "sd";
    public static final String STORAGE_DESC_INPUT_FMT = "inputFormat";
    public static final String STORAGE_DESC_OUTPUT_FMT = "outputFormat";
    public static final String LOCATION = "location";
    public static final String TABLE_TYPE_ATTR = "tableType";
    public static final String CREATE_TIME = "createTime";
    public static final String LAST_ACCESS_TIME = "lastAccessTime";

    public void createDataModel() throws AtlasException {
        LOG.info("Generating the Hive Data Model....");
        this.createHivePrincipalTypeEnum();
        this.createSerDeStruct();
        this.createOrderStruct();
        this.createStorageDescClass();
        this.createDBClass();
        this.createColumnClass();
        this.createTableClass();
        this.createProcessClass();
    }

    public TypesDef getTypesDef() {
        return TypesUtil.getTypesDef(this.getEnumTypeDefinitions(), this.getStructTypeDefinitions(), this.getTraitTypeDefinitions(), this.getClassTypeDefinitions());
    }

    public String getDataModelAsJSON() {
        return TypesSerialization.toJson((TypesDef)this.getTypesDef());
    }

    public ImmutableList<EnumTypeDefinition> getEnumTypeDefinitions() {
        return ImmutableList.copyOf(this.enumTypeDefinitionMap.values());
    }

    public ImmutableList<StructTypeDefinition> getStructTypeDefinitions() {
        return ImmutableList.copyOf(this.structTypeDefinitionMap.values());
    }

    public ImmutableList<HierarchicalTypeDefinition<ClassType>> getClassTypeDefinitions() {
        return ImmutableList.copyOf(this.classTypeDefinitions.values());
    }

    public ImmutableList<HierarchicalTypeDefinition<TraitType>> getTraitTypeDefinitions() {
        return ImmutableList.of();
    }

    private void createHivePrincipalTypeEnum() throws AtlasException {
        EnumValue[] values = new EnumValue[]{new EnumValue("USER", 1), new EnumValue("ROLE", 2), new EnumValue("GROUP", 3)};
        EnumTypeDefinition definition = new EnumTypeDefinition(HiveDataTypes.HIVE_PRINCIPAL_TYPE.getName(), values);
        this.enumTypeDefinitionMap.put(HiveDataTypes.HIVE_PRINCIPAL_TYPE.getName(), definition);
        LOG.debug("Created definition for " + HiveDataTypes.HIVE_PRINCIPAL_TYPE.getName());
    }

    private void createSerDeStruct() throws AtlasException {
        AttributeDefinition[] attributeDefinitions = new AttributeDefinition[]{new AttributeDefinition("name", DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("serializationLib", DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition(PARAMETERS, STRING_MAP_TYPE.getName(), Multiplicity.OPTIONAL, false, null)};
        StructTypeDefinition definition = new StructTypeDefinition(HiveDataTypes.HIVE_SERDE.getName(), attributeDefinitions);
        this.structTypeDefinitionMap.put(HiveDataTypes.HIVE_SERDE.getName(), definition);
        LOG.debug("Created definition for " + HiveDataTypes.HIVE_SERDE.getName());
    }

    private void createOrderStruct() throws AtlasException {
        AttributeDefinition[] attributeDefinitions = new AttributeDefinition[]{new AttributeDefinition("col", DataTypes.STRING_TYPE.getName(), Multiplicity.REQUIRED, false, null), new AttributeDefinition("order", DataTypes.INT_TYPE.getName(), Multiplicity.REQUIRED, false, null)};
        StructTypeDefinition definition = new StructTypeDefinition(HiveDataTypes.HIVE_ORDER.getName(), attributeDefinitions);
        this.structTypeDefinitionMap.put(HiveDataTypes.HIVE_ORDER.getName(), definition);
        LOG.debug("Created definition for " + HiveDataTypes.HIVE_ORDER.getName());
    }

    private void createStorageDescClass() throws AtlasException {
        AttributeDefinition[] attributeDefinitions = new AttributeDefinition[]{new AttributeDefinition(TABLE, HiveDataTypes.HIVE_TABLE.getName(), Multiplicity.OPTIONAL, false, STORAGE_DESC), new AttributeDefinition(LOCATION, DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition(STORAGE_DESC_INPUT_FMT, DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition(STORAGE_DESC_OUTPUT_FMT, DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("compressed", DataTypes.BOOLEAN_TYPE.getName(), Multiplicity.REQUIRED, false, null), new AttributeDefinition(STORAGE_NUM_BUCKETS, DataTypes.INT_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("serdeInfo", HiveDataTypes.HIVE_SERDE.getName(), Multiplicity.OPTIONAL, true, null), new AttributeDefinition("bucketCols", String.format("array<%s>", DataTypes.STRING_TYPE.getName()), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("sortCols", String.format("array<%s>", HiveDataTypes.HIVE_ORDER.getName()), Multiplicity.OPTIONAL, false, null), new AttributeDefinition(PARAMETERS, STRING_MAP_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition(STORAGE_IS_STORED_AS_SUB_DIRS, DataTypes.BOOLEAN_TYPE.getName(), Multiplicity.OPTIONAL, false, null)};
        HierarchicalTypeDefinition definition = new HierarchicalTypeDefinition(ClassType.class, HiveDataTypes.HIVE_STORAGEDESC.getName(), null, ImmutableSet.of((Object)"Referenceable"), attributeDefinitions);
        this.classTypeDefinitions.put(HiveDataTypes.HIVE_STORAGEDESC.getName(), (HierarchicalTypeDefinition<ClassType>)definition);
        LOG.debug("Created definition for " + HiveDataTypes.HIVE_STORAGEDESC.getName());
    }

    private void createDBClass() throws AtlasException {
        AttributeDefinition[] attributeDefinitions = new AttributeDefinition[]{new AttributeDefinition("clusterName", DataTypes.STRING_TYPE.getName(), Multiplicity.REQUIRED, false, false, true, null), new AttributeDefinition(LOCATION, DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition(PARAMETERS, STRING_MAP_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("ownerType", HiveDataTypes.HIVE_PRINCIPAL_TYPE.getName(), Multiplicity.OPTIONAL, false, null)};
        HierarchicalTypeDefinition definition = new HierarchicalTypeDefinition(ClassType.class, HiveDataTypes.HIVE_DB.getName(), null, ImmutableSet.of((Object)"Referenceable", (Object)"Asset"), attributeDefinitions);
        this.classTypeDefinitions.put(HiveDataTypes.HIVE_DB.getName(), (HierarchicalTypeDefinition<ClassType>)definition);
        LOG.debug("Created definition for " + HiveDataTypes.HIVE_DB.getName());
    }

    private void createColumnClass() throws AtlasException {
        AttributeDefinition[] attributeDefinitions = new AttributeDefinition[]{new AttributeDefinition("type", DataTypes.STRING_TYPE.getName(), Multiplicity.REQUIRED, false, false, true, null), new AttributeDefinition(COMMENT, DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition(TABLE, HiveDataTypes.HIVE_TABLE.getName(), Multiplicity.OPTIONAL, false, COLUMNS), new AttributeDefinition(POSITION, DataTypes.INT_TYPE.getName(), Multiplicity.OPTIONAL, false, false, false, null)};
        HierarchicalTypeDefinition definition = new HierarchicalTypeDefinition(ClassType.class, HiveDataTypes.HIVE_COLUMN.getName(), null, ImmutableSet.of((Object)"DataSet"), attributeDefinitions);
        this.classTypeDefinitions.put(HiveDataTypes.HIVE_COLUMN.getName(), (HierarchicalTypeDefinition<ClassType>)definition);
        LOG.debug("Created definition for " + HiveDataTypes.HIVE_COLUMN.getName());
    }

    private void createTableClass() throws AtlasException {
        AttributeDefinition[] attributeDefinitions = new AttributeDefinition[]{new AttributeDefinition(DB, HiveDataTypes.HIVE_DB.getName(), Multiplicity.REQUIRED, false, null), new AttributeDefinition(CREATE_TIME, DataTypes.DATE_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition(LAST_ACCESS_TIME, DataTypes.DATE_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition(COMMENT, DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("retention", DataTypes.INT_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition(STORAGE_DESC, HiveDataTypes.HIVE_STORAGEDESC.getName(), Multiplicity.OPTIONAL, true, null), new AttributeDefinition(PART_COLS, DataTypes.arrayTypeName((String)HiveDataTypes.HIVE_COLUMN.getName()), Multiplicity.OPTIONAL, true, null), new AttributeDefinition(TABLE_ALIAS_LIST, DataTypes.arrayTypeName((String)DataTypes.STRING_TYPE.getName()), Multiplicity.OPTIONAL, true, null), new AttributeDefinition(COLUMNS, DataTypes.arrayTypeName((String)HiveDataTypes.HIVE_COLUMN.getName()), Multiplicity.OPTIONAL, true, null), new AttributeDefinition(PARAMETERS, STRING_MAP_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("viewOriginalText", DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("viewExpandedText", DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition(TABLE_TYPE_ATTR, DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("temporary", DataTypes.BOOLEAN_TYPE.getName(), Multiplicity.OPTIONAL, false, false, true, null)};
        HierarchicalTypeDefinition definition = new HierarchicalTypeDefinition(ClassType.class, HiveDataTypes.HIVE_TABLE.getName(), null, ImmutableSet.of((Object)"DataSet"), attributeDefinitions);
        this.classTypeDefinitions.put(HiveDataTypes.HIVE_TABLE.getName(), (HierarchicalTypeDefinition<ClassType>)definition);
        LOG.debug("Created definition for " + HiveDataTypes.HIVE_TABLE.getName());
    }

    private void createProcessClass() throws AtlasException {
        AttributeDefinition[] attributeDefinitions = new AttributeDefinition[]{new AttributeDefinition("startTime", DataTypes.DATE_TYPE.getName(), Multiplicity.REQUIRED, false, null), new AttributeDefinition("endTime", DataTypes.DATE_TYPE.getName(), Multiplicity.REQUIRED, false, null), new AttributeDefinition("userName", DataTypes.STRING_TYPE.getName(), Multiplicity.REQUIRED, false, false, true, null), new AttributeDefinition("operationType", DataTypes.STRING_TYPE.getName(), Multiplicity.REQUIRED, false, false, true, null), new AttributeDefinition("queryText", DataTypes.STRING_TYPE.getName(), Multiplicity.REQUIRED, false, null), new AttributeDefinition("queryPlan", DataTypes.STRING_TYPE.getName(), Multiplicity.REQUIRED, false, null), new AttributeDefinition("queryId", DataTypes.STRING_TYPE.getName(), Multiplicity.REQUIRED, false, null), new AttributeDefinition("recentQueries", String.format("array<%s>", DataTypes.STRING_TYPE.getName()), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("clusterName", DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("queryGraph", DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null)};
        HierarchicalTypeDefinition definition = new HierarchicalTypeDefinition(ClassType.class, HiveDataTypes.HIVE_PROCESS.getName(), null, ImmutableSet.of((Object)"Process"), attributeDefinitions);
        this.classTypeDefinitions.put(HiveDataTypes.HIVE_PROCESS.getName(), (HierarchicalTypeDefinition<ClassType>)definition);
        LOG.debug("Created definition for " + HiveDataTypes.HIVE_PROCESS.getName());
    }

    public String getModelAsJson() throws AtlasException {
        this.createDataModel();
        return this.getDataModelAsJSON();
    }

    public static void main(String[] args) throws Exception {
        HiveDataModelGenerator hiveDataModelGenerator = new HiveDataModelGenerator();
        String modelAsJson = hiveDataModelGenerator.getModelAsJson();
        if (args.length == 1) {
            ModelDefinitionDump.dumpModelToFile((String)args[0], (String)modelAsJson);
            return;
        }
        System.out.println("hiveDataModelAsJSON = " + modelAsJson);
        TypesDef typesDef = hiveDataModelGenerator.getTypesDef();
        for (EnumTypeDefinition enumType : typesDef.enumTypesAsJavaList()) {
            System.out.println(String.format("%s(%s) - values %s", enumType.name, EnumType.class.getSimpleName(), Arrays.toString(enumType.enumValues)));
        }
        for (StructTypeDefinition structType : typesDef.structTypesAsJavaList()) {
            System.out.println(String.format("%s(%s) - attributes %s", structType.typeName, StructType.class.getSimpleName(), Arrays.toString(structType.attributeDefinitions)));
        }
        for (HierarchicalTypeDefinition classType : typesDef.classTypesAsJavaList()) {
            System.out.println(String.format("%s(%s) - super types [%s] - attributes %s", classType.typeName, ClassType.class.getSimpleName(), StringUtils.join((Collection)classType.superTypes, (String)","), Arrays.toString(classType.attributeDefinitions)));
        }
        for (HierarchicalTypeDefinition traitType : typesDef.traitTypesAsJavaList()) {
            System.out.println(String.format("%s(%s) - %s", traitType.typeName, TraitType.class.getSimpleName(), Arrays.toString(traitType.attributeDefinitions)));
        }
    }
}

