/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.hook;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.atlas.hive.bridge.HiveMetaStoreBridge;
import org.apache.atlas.hive.model.HiveDataTypes;
import org.apache.atlas.hook.AtlasHook;
import org.apache.atlas.notification.hook.HookNotification;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ShutdownHookManager;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveHook
extends AtlasHook
implements ExecuteWithHookContext {
    private static final Logger LOG = LoggerFactory.getLogger(HiveHook.class);
    public static final String CONF_PREFIX = "atlas.hook.hive.";
    private static final String MIN_THREADS = "atlas.hook.hive.minThreads";
    private static final String MAX_THREADS = "atlas.hook.hive.maxThreads";
    private static final String KEEP_ALIVE_TIME = "atlas.hook.hive.keepAliveTime";
    public static final String CONF_SYNC = "atlas.hook.hive.synchronous";
    public static final String QUEUE_SIZE = "atlas.hook.hive.queueSize";
    public static final String HOOK_NUM_RETRIES = "atlas.hook.hive.numRetries";
    public static final String SEP = ":".intern();
    static final String IO_SEP = "->".intern();
    private static final Map<String, HiveOperation> OPERATION_MAP = new HashMap<String, HiveOperation>();
    private static final int WAIT_TIME = 3;
    private static ExecutorService executor = null;
    private static final int minThreadsDefault = 1;
    private static final int maxThreadsDefault = 5;
    private static final long keepAliveTimeDefault = 10L;
    private static final int queueSizeDefault = 10000;
    private static final HiveConf hiveConf;
    @VisibleForTesting
    static final Comparator<Entity> entityComparator;

    private static void setupOperationMap() {
        for (HiveOperation hiveOperation : HiveOperation.values()) {
            OPERATION_MAP.put(hiveOperation.getOperationName(), hiveOperation);
        }
    }

    protected String getNumberOfRetriesPropertyKey() {
        return HOOK_NUM_RETRIES;
    }

    public void run(HookContext hookContext) throws Exception {
        try {
            final HiveEventContext event = new HiveEventContext();
            event.setInputs(hookContext.getInputs());
            event.setOutputs(hookContext.getOutputs());
            event.setJsonPlan(this.getQueryPlan(hookContext.getConf(), hookContext.getQueryPlan()));
            event.setHookType(hookContext.getHookType());
            final UserGroupInformation ugi = hookContext.getUgi() == null ? Utils.getUGI() : hookContext.getUgi();
            event.setUgi(ugi);
            event.setUser(HiveHook.getUser((String)hookContext.getUserName(), (UserGroupInformation)hookContext.getUgi()));
            event.setOperation(OPERATION_MAP.get(hookContext.getOperationName()));
            event.setQueryId(hookContext.getQueryPlan().getQueryId());
            event.setQueryStr(hookContext.getQueryPlan().getQueryStr());
            event.setQueryStartTime(hookContext.getQueryPlan().getQueryStartTime());
            event.setQueryType(hookContext.getQueryPlan().getQueryPlan().getQueryType());
            if (executor == null) {
                this.collect(event);
                this.notifyAsPrivilegedAction(event);
            } else {
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                                @Override
                                public Object run() throws Exception {
                                    HiveHook.this.collect(event);
                                    return event;
                                }
                            });
                            HiveHook.this.notifyAsPrivilegedAction(event);
                        }
                        catch (Throwable e) {
                            LOG.error("Atlas hook failed due to error ", e);
                        }
                    }
                });
            }
        }
        catch (Throwable t) {
            LOG.error("Submitting to thread pool failed due to error ", t);
        }
    }

    void notifyAsPrivilegedAction(final HiveEventContext event) {
        try {
            PrivilegedExceptionAction<Object> privilegedNotify = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    HiveHook.this.notifyEntities(event.getMessages());
                    return event;
                }
            };
            UserGroupInformation realUser = event.getUgi().getRealUser();
            if (realUser != null) {
                LOG.info("Sending notification for event {} as service user {} #messages {} ", new Object[]{event.getOperation(), realUser.getShortUserName(), event.getMessages().size()});
                realUser.doAs((PrivilegedExceptionAction)privilegedNotify);
            } else {
                LOG.info("Sending notification for event {} as current user {} #messages {} ", new Object[]{event.getOperation(), event.getUgi().getShortUserName(), event.getMessages().size()});
                event.getUgi().doAs((PrivilegedExceptionAction)privilegedNotify);
            }
        }
        catch (Throwable e) {
            LOG.error("Error during notify {} ", (Object)event.getOperation(), (Object)e);
        }
    }

    private void collect(HiveEventContext event) throws Exception {
        assert (event.getHookType() == HookContext.HookType.POST_EXEC_HOOK) : "Non-POST_EXEC_HOOK not supported!";
        LOG.info("Entered Atlas hook for hook type {}, operation {} , user {} as {}", new Object[]{event.getHookType(), event.getOperation(), event.getUgi().getRealUser(), event.getUgi().getShortUserName()});
        HiveMetaStoreBridge dgiBridge = new HiveMetaStoreBridge(atlasProperties, hiveConf);
        switch (event.getOperation()) {
            case CREATEDATABASE: {
                this.handleEventOutputs(dgiBridge, event, Entity.Type.DATABASE);
                break;
            }
            case CREATETABLE: {
                LinkedHashMap<Entity.Type, Referenceable> tablesCreated = this.handleEventOutputs(dgiBridge, event, Entity.Type.TABLE);
                if (tablesCreated.size() <= 0) break;
                this.handleExternalTables(dgiBridge, event, tablesCreated);
                break;
            }
            case CREATETABLE_AS_SELECT: 
            case CREATEVIEW: 
            case ALTERVIEW_AS: 
            case LOAD: 
            case EXPORT: 
            case IMPORT: 
            case QUERY: 
            case TRUNCATETABLE: {
                this.registerProcess(dgiBridge, event);
                break;
            }
            case ALTERTABLE_RENAME: 
            case ALTERVIEW_RENAME: {
                this.renameTable(dgiBridge, event);
                break;
            }
            case ALTERTABLE_FILEFORMAT: 
            case ALTERTABLE_CLUSTER_SORT: 
            case ALTERTABLE_BUCKETNUM: 
            case ALTERTABLE_PROPERTIES: 
            case ALTERVIEW_PROPERTIES: 
            case ALTERTABLE_SERDEPROPERTIES: 
            case ALTERTABLE_SERIALIZER: 
            case ALTERTABLE_ADDCOLS: 
            case ALTERTABLE_REPLACECOLS: 
            case ALTERTABLE_PARTCOLTYPE: {
                this.handleEventOutputs(dgiBridge, event, Entity.Type.TABLE);
                break;
            }
            case ALTERTABLE_RENAMECOL: {
                this.renameColumn(dgiBridge, event);
                break;
            }
            case ALTERTABLE_LOCATION: {
                LinkedHashMap<Entity.Type, Referenceable> tablesUpdated = this.handleEventOutputs(dgiBridge, event, Entity.Type.TABLE);
                if (tablesUpdated == null || tablesUpdated.size() <= 0) break;
                this.handleExternalTables(dgiBridge, event, tablesUpdated);
                break;
            }
            case ALTERDATABASE: 
            case ALTERDATABASE_OWNER: {
                this.handleEventOutputs(dgiBridge, event, Entity.Type.DATABASE);
                break;
            }
            case DROPTABLE: 
            case DROPVIEW: {
                this.deleteTable(dgiBridge, event);
                break;
            }
            case DROPDATABASE: {
                this.deleteDatabase(dgiBridge, event);
                break;
            }
        }
    }

    private void deleteTable(HiveMetaStoreBridge dgiBridge, HiveEventContext event) {
        for (WriteEntity output : event.getOutputs()) {
            if (!Entity.Type.TABLE.equals((Object)output.getType())) continue;
            this.deleteTable(dgiBridge, event, output);
        }
    }

    private void deleteTable(HiveMetaStoreBridge dgiBridge, HiveEventContext event, WriteEntity output) {
        String tblQualifiedName = HiveMetaStoreBridge.getTableQualifiedName(dgiBridge.getClusterName(), output.getTable());
        LOG.info("Deleting table {} ", (Object)tblQualifiedName);
        event.addMessage((HookNotification.HookNotificationMessage)new HookNotification.EntityDeleteRequest(event.getUser(), HiveDataTypes.HIVE_TABLE.getName(), "qualifiedName", tblQualifiedName));
    }

    private void deleteDatabase(HiveMetaStoreBridge dgiBridge, HiveEventContext event) {
        if (event.getOutputs().size() > 1) {
            LOG.info("Starting deletion of tables and databases with cascade {} ", (Object)event.getQueryStr());
        } else {
            LOG.info("Starting deletion of database {} ", (Object)event.getQueryStr());
        }
        for (WriteEntity output : event.getOutputs()) {
            if (Entity.Type.TABLE.equals((Object)output.getType())) {
                this.deleteTable(dgiBridge, event, output);
                continue;
            }
            if (!Entity.Type.DATABASE.equals((Object)output.getType())) continue;
            String dbQualifiedName = HiveMetaStoreBridge.getDBQualifiedName(dgiBridge.getClusterName(), output.getDatabase().getName());
            event.addMessage((HookNotification.HookNotificationMessage)new HookNotification.EntityDeleteRequest(event.getUser(), HiveDataTypes.HIVE_DB.getName(), "qualifiedName", dbQualifiedName));
        }
    }

    private Pair<String, String> findChangedColNames(List<FieldSchema> oldColList, List<FieldSchema> newColList) {
        int i;
        String changedColStringOldName;
        HashMap<FieldSchema, Integer> oldColHashMap = new HashMap<FieldSchema, Integer>();
        HashMap<FieldSchema, Integer> newColHashMap = new HashMap<FieldSchema, Integer>();
        for (int i2 = 0; i2 < oldColList.size(); ++i2) {
            oldColHashMap.put(oldColList.get(i2), i2);
            newColHashMap.put(newColList.get(i2), i2);
        }
        String changedColStringNewName = changedColStringOldName = oldColList.get(0).getName();
        for (i = 0; i < oldColList.size(); ++i) {
            if (newColHashMap.containsKey(oldColList.get(i))) continue;
            changedColStringOldName = oldColList.get(i).getName();
            break;
        }
        for (i = 0; i < newColList.size(); ++i) {
            if (oldColHashMap.containsKey(newColList.get(i))) continue;
            changedColStringNewName = newColList.get(i).getName();
            break;
        }
        return Pair.of((Object)changedColStringOldName, (Object)changedColStringNewName);
    }

    private void renameColumn(HiveMetaStoreBridge dgiBridge, HiveEventContext event) throws Exception {
        assert (event.getInputs() != null && event.getInputs().size() == 1);
        assert (event.getOutputs() != null && event.getOutputs().size() > 0);
        Table oldTable = event.getInputs().iterator().next().getTable();
        List oldColList = oldTable.getAllCols();
        Table outputTbl = event.getOutputs().iterator().next().getTable();
        outputTbl = dgiBridge.hiveClient.getTable(outputTbl.getDbName(), outputTbl.getTableName());
        List newColList = outputTbl.getAllCols();
        assert (oldColList.size() == newColList.size());
        Pair<String, String> changedColNamePair = this.findChangedColNames(oldColList, newColList);
        String oldColName = (String)changedColNamePair.getLeft();
        String newColName = (String)changedColNamePair.getRight();
        for (WriteEntity writeEntity : event.getOutputs()) {
            if (writeEntity.getType() != Entity.Type.TABLE) continue;
            Table newTable = writeEntity.getTable();
            this.createOrUpdateEntities(dgiBridge, event, (Entity)writeEntity, true, oldTable);
            String newQualifiedTableName = HiveMetaStoreBridge.getTableQualifiedName(dgiBridge.getClusterName(), newTable);
            String oldColumnQFName = HiveMetaStoreBridge.getColumnQualifiedName(newQualifiedTableName, oldColName);
            String newColumnQFName = HiveMetaStoreBridge.getColumnQualifiedName(newQualifiedTableName, newColName);
            Referenceable newColEntity = new Referenceable(HiveDataTypes.HIVE_COLUMN.getName(), new String[0]);
            newColEntity.set("qualifiedName", (Object)newColumnQFName);
            event.addMessage((HookNotification.HookNotificationMessage)new HookNotification.EntityPartialUpdateRequest(event.getUser(), HiveDataTypes.HIVE_COLUMN.getName(), "qualifiedName", oldColumnQFName, newColEntity));
        }
        this.handleEventOutputs(dgiBridge, event, Entity.Type.TABLE);
    }

    private void renameTable(HiveMetaStoreBridge dgiBridge, HiveEventContext event) throws Exception {
        assert (event.getInputs() != null && event.getInputs().size() == 1);
        assert (event.getOutputs() != null && event.getOutputs().size() > 0);
        ReadEntity oldEntity = event.getInputs().iterator().next();
        Table oldTable = oldEntity.getTable();
        for (WriteEntity writeEntity : event.getOutputs()) {
            Table newTable;
            if (writeEntity.getType() != Entity.Type.TABLE || (newTable = writeEntity.getTable()).getDbName().equals(oldTable.getDbName()) && newTable.getTableName().equals(oldTable.getTableName())) continue;
            String oldQualifiedName = HiveMetaStoreBridge.getTableQualifiedName(dgiBridge.getClusterName(), oldTable);
            String newQualifiedName = HiveMetaStoreBridge.getTableQualifiedName(dgiBridge.getClusterName(), newTable);
            LinkedHashMap<Entity.Type, Referenceable> tables = this.createOrUpdateEntities(dgiBridge, event, (Entity)writeEntity, true);
            Referenceable tableEntity = tables.get(Entity.Type.TABLE);
            this.replaceColumnQFName(event, (List)tableEntity.get("columns"), oldQualifiedName, newQualifiedName);
            this.replaceColumnQFName(event, (List)tableEntity.get("partitionKeys"), oldQualifiedName, newQualifiedName);
            this.replaceSDQFName(event, tableEntity, oldQualifiedName, newQualifiedName);
            this.replaceTableQFName(event, oldTable, newTable, tableEntity, oldQualifiedName, newQualifiedName);
        }
    }

    private Referenceable replaceTableQFName(HiveEventContext event, Table oldTable, Table newTable, Referenceable tableEntity, String oldTableQFName, String newTableQFName) throws HiveException {
        tableEntity.set("name", (Object)oldTable.getTableName().toLowerCase());
        tableEntity.set("qualifiedName", (Object)oldTableQFName);
        Referenceable newEntity = new Referenceable(HiveDataTypes.HIVE_TABLE.getName(), new String[0]);
        newEntity.set("name", (Object)newTable.getTableName().toLowerCase());
        newEntity.set("qualifiedName", (Object)newTableQFName);
        ArrayList<String> alias_list = new ArrayList<String>();
        alias_list.add(oldTable.getTableName().toLowerCase());
        newEntity.set("aliases", alias_list);
        event.addMessage((HookNotification.HookNotificationMessage)new HookNotification.EntityPartialUpdateRequest(event.getUser(), HiveDataTypes.HIVE_TABLE.getName(), "qualifiedName", oldTableQFName, newEntity));
        return newEntity;
    }

    private List<Referenceable> replaceColumnQFName(HiveEventContext event, List<Referenceable> cols, String oldTableQFName, String newTableQFName) {
        ArrayList<Referenceable> newColEntities = new ArrayList<Referenceable>();
        for (Referenceable col : cols) {
            String colName = (String)col.get("name");
            String oldColumnQFName = HiveMetaStoreBridge.getColumnQualifiedName(oldTableQFName, colName);
            String newColumnQFName = HiveMetaStoreBridge.getColumnQualifiedName(newTableQFName, colName);
            col.set("qualifiedName", (Object)oldColumnQFName);
            Referenceable newColEntity = new Referenceable(HiveDataTypes.HIVE_COLUMN.getName(), new String[0]);
            newColEntity.set("qualifiedName", (Object)newColumnQFName);
            event.addMessage((HookNotification.HookNotificationMessage)new HookNotification.EntityPartialUpdateRequest(event.getUser(), HiveDataTypes.HIVE_COLUMN.getName(), "qualifiedName", oldColumnQFName, newColEntity));
            newColEntities.add(newColEntity);
        }
        return newColEntities;
    }

    private Referenceable replaceSDQFName(HiveEventContext event, Referenceable tableEntity, String oldTblQFName, String newTblQFName) {
        Referenceable sdRef = (Referenceable)tableEntity.get("sd");
        sdRef.set("qualifiedName", (Object)HiveMetaStoreBridge.getStorageDescQFName(oldTblQFName));
        String oldSDQFName = HiveMetaStoreBridge.getStorageDescQFName(oldTblQFName);
        String newSDQFName = HiveMetaStoreBridge.getStorageDescQFName(newTblQFName);
        Referenceable newSDEntity = new Referenceable(HiveDataTypes.HIVE_STORAGEDESC.getName(), new String[0]);
        newSDEntity.set("qualifiedName", (Object)newSDQFName);
        event.addMessage((HookNotification.HookNotificationMessage)new HookNotification.EntityPartialUpdateRequest(event.getUser(), HiveDataTypes.HIVE_STORAGEDESC.getName(), "qualifiedName", oldSDQFName, newSDEntity));
        return newSDEntity;
    }

    private LinkedHashMap<Entity.Type, Referenceable> createOrUpdateEntities(HiveMetaStoreBridge dgiBridge, HiveEventContext event, Entity entity, boolean skipTempTables, Table existTable) throws Exception {
        Database db = null;
        Table table = null;
        Partition partition = null;
        LinkedHashMap<Entity.Type, Referenceable> result = new LinkedHashMap<Entity.Type, Referenceable>();
        ArrayList<Referenceable> entities = new ArrayList<Referenceable>();
        switch (entity.getType()) {
            case DATABASE: {
                db = entity.getDatabase();
                break;
            }
            case TABLE: {
                table = entity.getTable();
                db = dgiBridge.hiveClient.getDatabase(table.getDbName());
                break;
            }
            case PARTITION: {
                partition = entity.getPartition();
                table = partition.getTable();
                db = dgiBridge.hiveClient.getDatabase(table.getDbName());
                break;
            }
            default: {
                LOG.info("{}: entity-type not handled by Atlas hook. Ignored", (Object)entity.getType());
            }
        }
        if (db != null) {
            db = dgiBridge.hiveClient.getDatabase(db.getName());
        }
        if (db != null) {
            Referenceable dbEntity = dgiBridge.createDBInstance(db);
            entities.add(dbEntity);
            result.put(Entity.Type.DATABASE, dbEntity);
            Referenceable tableEntity = null;
            if (table != null) {
                table = existTable != null ? existTable : dgiBridge.hiveClient.getTable(table.getDbName(), table.getTableName());
                if (skipTempTables && table.isTemporary() && !TableType.EXTERNAL_TABLE.equals((Object)table.getTableType())) {
                    LOG.debug("Skipping temporary table registration {} since it is not an external table {} ", (Object)table.getTableName(), (Object)table.getTableType().name());
                } else {
                    tableEntity = dgiBridge.createTableInstance(dbEntity, table);
                    entities.add(tableEntity);
                    result.put(Entity.Type.TABLE, tableEntity);
                }
            }
            event.addMessage((HookNotification.HookNotificationMessage)new HookNotification.EntityUpdateRequest(event.getUser(), entities));
        }
        return result;
    }

    private LinkedHashMap<Entity.Type, Referenceable> createOrUpdateEntities(HiveMetaStoreBridge dgiBridge, HiveEventContext event, Entity entity, boolean skipTempTables) throws Exception {
        return this.createOrUpdateEntities(dgiBridge, event, entity, skipTempTables, null);
    }

    private LinkedHashMap<Entity.Type, Referenceable> handleEventOutputs(HiveMetaStoreBridge dgiBridge, HiveEventContext event, Entity.Type entityType) throws Exception {
        for (Entity entity : event.getOutputs()) {
            if (entity.getType() != entityType) continue;
            return this.createOrUpdateEntities(dgiBridge, event, entity, true);
        }
        return null;
    }

    private static Entity getEntityByType(Set<? extends Entity> entities, Entity.Type entityType) {
        for (Entity entity : entities) {
            if (entity.getType() != entityType) continue;
            return entity;
        }
        return null;
    }

    public static String lower(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        return str.toLowerCase().trim();
    }

    private void registerProcess(HiveMetaStoreBridge dgiBridge, HiveEventContext event) throws Exception {
        Set<ReadEntity> inputs = event.getInputs();
        Set<WriteEntity> outputs = event.getOutputs();
        if (inputs.isEmpty() && outputs.isEmpty()) {
            LOG.info("Explain statement. Skipping...");
            return;
        }
        if (event.getQueryId() == null) {
            LOG.info("Query id/plan is missing for {}", (Object)event.getQueryStr());
        }
        TreeMap source = new TreeMap(entityComparator);
        TreeMap target = new TreeMap(entityComparator);
        HashSet<String> dataSets = new HashSet<String>();
        LinkedHashSet<Referenceable> entities = new LinkedHashSet<Referenceable>();
        boolean isSelectQuery = this.isSelectQuery(event);
        if (!isSelectQuery) {
            TreeSet<Entity> sortedHiveInputs = new TreeSet<Entity>(entityComparator);
            if (event.getInputs() != null) {
                sortedHiveInputs.addAll(event.getInputs());
            }
            TreeSet<Entity> sortedHiveOutputs = new TreeSet<Entity>(entityComparator);
            if (event.getOutputs() != null) {
                sortedHiveOutputs.addAll(event.getOutputs());
            }
            for (ReadEntity readEntity : sortedHiveInputs) {
                this.processHiveEntity(dgiBridge, event, (Entity)readEntity, (Set<String>)dataSets, source, (Set<Referenceable>)entities);
            }
            for (WriteEntity writeEntity : sortedHiveOutputs) {
                this.processHiveEntity(dgiBridge, event, (Entity)writeEntity, (Set<String>)dataSets, target, (Set<Referenceable>)entities);
            }
            if (source.size() > 0 || target.size() > 0) {
                Referenceable processReferenceable = this.getProcessReferenceable(dgiBridge, event, sortedHiveInputs, sortedHiveOutputs, source, target);
                entities.add(processReferenceable);
                event.addMessage((HookNotification.HookNotificationMessage)new HookNotification.EntityUpdateRequest(event.getUser(), new ArrayList<Referenceable>(entities)));
            } else {
                LOG.info("Skipped query {} since it has no getInputs() or resulting getOutputs()", (Object)event.getQueryStr());
            }
        } else {
            LOG.info("Skipped query {} for processing since it is a select query ", (Object)event.getQueryStr());
        }
    }

    private <T extends Entity> void processHiveEntity(HiveMetaStoreBridge dgiBridge, HiveEventContext event, T entity, Set<String> dataSetsProcessed, SortedMap<T, Referenceable> dataSets, Set<Referenceable> entities) throws Exception {
        URI location;
        if (entity.getType() == Entity.Type.TABLE || entity.getType() == Entity.Type.PARTITION) {
            String tblQFName = HiveMetaStoreBridge.getTableQualifiedName(dgiBridge.getClusterName(), entity.getTable());
            if (!dataSetsProcessed.contains(tblQFName)) {
                LinkedHashMap<Entity.Type, Referenceable> result = this.createOrUpdateEntities(dgiBridge, event, entity, false);
                dataSets.put(entity, result.get(Entity.Type.TABLE));
                dataSetsProcessed.add(tblQFName);
                entities.addAll(result.values());
            }
        } else if (entity.getType() == Entity.Type.DFS_DIR && (location = entity.getLocation()) != null) {
            String pathUri = HiveHook.lower(new Path(location).toString());
            LOG.debug("Registering DFS Path {} ", (Object)pathUri);
            if (!dataSetsProcessed.contains(pathUri)) {
                Referenceable hdfsPath = dgiBridge.fillHDFSDataSet(pathUri);
                dataSets.put(entity, hdfsPath);
                dataSetsProcessed.add(pathUri);
                entities.add(hdfsPath);
            }
        }
    }

    private JSONObject getQueryPlan(HiveConf hiveConf, QueryPlan queryPlan) throws Exception {
        try {
            ExplainTask explain = new ExplainTask();
            explain.initialize(hiveConf, queryPlan, null);
            ArrayList rootTasks = queryPlan.getRootTasks();
            return explain.getJSONPlan(null, null, (List)rootTasks, (Task)queryPlan.getFetchTask(), true, false, false);
        }
        catch (Throwable e) {
            LOG.info("Failed to get queryplan", e);
            return new JSONObject();
        }
    }

    private boolean isSelectQuery(HiveEventContext event) {
        WriteEntity output;
        return event.getOperation() == HiveOperation.QUERY && event.getOutputs().size() == 1 && ((output = event.getOutputs().iterator().next()).getType() == Entity.Type.DFS_DIR || output.getType() == Entity.Type.LOCAL_DIR) && output.getWriteType() == WriteEntity.WriteType.PATH_WRITE && output.isTempURI();
    }

    private void handleExternalTables(final HiveMetaStoreBridge dgiBridge, HiveEventContext event, final LinkedHashMap<Entity.Type, Referenceable> tables) throws HiveException, MalformedURLException {
        Table hiveTable;
        ArrayList<Referenceable> entities = new ArrayList<Referenceable>();
        final WriteEntity hiveEntity = (WriteEntity)HiveHook.getEntityByType(event.getOutputs(), Entity.Type.TABLE);
        Table table = hiveTable = hiveEntity == null ? null : hiveEntity.getTable();
        if (hiveTable != null) {
            hiveTable = dgiBridge.hiveClient.getTable(hiveTable.getDbName(), hiveTable.getTableName());
        }
        if (hiveTable != null && TableType.EXTERNAL_TABLE.equals((Object)hiveTable.getTableType())) {
            LOG.info("Registering external table process {} ", (Object)event.getQueryStr());
            final String location = HiveHook.lower(hiveTable.getDataLocation().toString());
            final ReadEntity dfsEntity = new ReadEntity();
            dfsEntity.setTyp(Entity.Type.DFS_DIR);
            dfsEntity.setName(location);
            TreeMap<ReadEntity, Referenceable> hiveInputsMap = new TreeMap<ReadEntity, Referenceable>(entityComparator){
                {
                    super(x0);
                    this.put(dfsEntity, dgiBridge.fillHDFSDataSet(location));
                }
            };
            TreeMap<WriteEntity, Referenceable> hiveOutputsMap = new TreeMap<WriteEntity, Referenceable>(entityComparator){
                {
                    super(x0);
                    this.put(hiveEntity, tables.get(Entity.Type.TABLE));
                }
            };
            TreeSet<Entity> sortedIps = new TreeSet<Entity>(entityComparator);
            sortedIps.addAll(hiveInputsMap.keySet());
            TreeSet<Entity> sortedOps = new TreeSet<Entity>(entityComparator);
            sortedOps.addAll(hiveOutputsMap.keySet());
            Referenceable processReferenceable = this.getProcessReferenceable(dgiBridge, event, sortedIps, sortedOps, (SortedMap<ReadEntity, Referenceable>)hiveInputsMap, (SortedMap<WriteEntity, Referenceable>)hiveOutputsMap);
            entities.addAll(tables.values());
            entities.add(processReferenceable);
            event.addMessage((HookNotification.HookNotificationMessage)new HookNotification.EntityUpdateRequest(event.getUser(), entities));
        }
    }

    private static boolean isCreateOp(HiveEventContext hiveEvent) {
        return HiveOperation.CREATETABLE.equals((Object)hiveEvent.getOperation()) || HiveOperation.CREATEVIEW.equals((Object)hiveEvent.getOperation()) || HiveOperation.ALTERVIEW_AS.equals((Object)hiveEvent.getOperation()) || HiveOperation.ALTERTABLE_LOCATION.equals((Object)hiveEvent.getOperation()) || HiveOperation.CREATETABLE_AS_SELECT.equals((Object)hiveEvent.getOperation());
    }

    private Referenceable getProcessReferenceable(HiveMetaStoreBridge dgiBridge, HiveEventContext hiveEvent, SortedSet<ReadEntity> sortedHiveInputs, SortedSet<WriteEntity> sortedHiveOutputs, SortedMap<ReadEntity, Referenceable> source, SortedMap<WriteEntity, Referenceable> target) throws HiveException {
        Referenceable processReferenceable = new Referenceable(HiveDataTypes.HIVE_PROCESS.getName(), new String[0]);
        String queryStr = HiveHook.lower(hiveEvent.getQueryStr());
        processReferenceable.set("qualifiedName", (Object)HiveHook.getProcessQualifiedName(dgiBridge, hiveEvent, sortedHiveInputs, sortedHiveOutputs, source, target));
        LOG.debug("Registering query: {}", (Object)queryStr);
        ArrayList<Referenceable> sourceList = new ArrayList<Referenceable>(source.values());
        ArrayList<Referenceable> targetList = new ArrayList<Referenceable>(target.values());
        if (sourceList != null && !sourceList.isEmpty()) {
            processReferenceable.set("inputs", sourceList);
        }
        if (targetList != null && !targetList.isEmpty()) {
            processReferenceable.set("outputs", targetList);
        }
        processReferenceable.set("name", (Object)queryStr);
        processReferenceable.set("operationType", (Object)hiveEvent.getOperation().getOperationName());
        processReferenceable.set("startTime", (Object)new Date(hiveEvent.getQueryStartTime()));
        processReferenceable.set("userName", (Object)hiveEvent.getUser());
        processReferenceable.set("queryText", (Object)queryStr);
        processReferenceable.set("queryId", (Object)hiveEvent.getQueryId());
        processReferenceable.set("queryPlan", (Object)hiveEvent.getJsonPlan());
        processReferenceable.set("clusterName", (Object)dgiBridge.getClusterName());
        ArrayList<String> recentQueries = new ArrayList<String>(1);
        recentQueries.add(queryStr);
        processReferenceable.set("recentQueries", recentQueries);
        processReferenceable.set("endTime", (Object)new Date(System.currentTimeMillis()));
        return processReferenceable;
    }

    @VisibleForTesting
    static String getProcessQualifiedName(HiveMetaStoreBridge dgiBridge, HiveEventContext eventContext, SortedSet<ReadEntity> sortedHiveInputs, SortedSet<WriteEntity> sortedHiveOutputs, SortedMap<ReadEntity, Referenceable> hiveInputsMap, SortedMap<WriteEntity, Referenceable> hiveOutputsMap) throws HiveException {
        Entity entity;
        HiveOperation op = eventContext.getOperation();
        if (HiveHook.isCreateOp(eventContext) && (entity = HiveHook.getEntityByType(sortedHiveOutputs, Entity.Type.TABLE)) != null) {
            Table outTable = entity.getTable();
            outTable = dgiBridge.hiveClient.getTable(outTable.getDbName(), outTable.getTableName());
            return HiveMetaStoreBridge.getTableProcessQualifiedName(dgiBridge.getClusterName(), outTable);
        }
        StringBuilder buffer = new StringBuilder(op.getOperationName());
        boolean ignoreHDFSPathsinQFName = HiveHook.ignoreHDFSPathsinQFName(op, sortedHiveInputs, sortedHiveOutputs);
        if (ignoreHDFSPathsinQFName && LOG.isDebugEnabled()) {
            LOG.debug("Ignoring HDFS paths in qualifiedName for {} {} ", (Object)op, (Object)eventContext.getQueryStr());
        }
        HiveHook.addInputs(dgiBridge, op, sortedHiveInputs, buffer, hiveInputsMap, ignoreHDFSPathsinQFName);
        buffer.append(IO_SEP);
        HiveHook.addOutputs(dgiBridge, op, sortedHiveOutputs, buffer, hiveOutputsMap, ignoreHDFSPathsinQFName);
        LOG.info("Setting process qualified name to {}", (Object)buffer);
        return buffer.toString();
    }

    private static boolean ignoreHDFSPathsinQFName(HiveOperation op, Set<ReadEntity> inputs, Set<WriteEntity> outputs) {
        switch (op) {
            case LOAD: 
            case IMPORT: {
                return HiveHook.isPartitionBasedQuery(outputs);
            }
            case EXPORT: {
                return HiveHook.isPartitionBasedQuery(inputs);
            }
            case QUERY: {
                return true;
            }
        }
        return false;
    }

    private static boolean isPartitionBasedQuery(Set<? extends Entity> entities) {
        for (Entity entity : entities) {
            if (!Entity.Type.PARTITION.equals((Object)entity.getType())) continue;
            return true;
        }
        return false;
    }

    private static void addInputs(HiveMetaStoreBridge hiveBridge, HiveOperation op, SortedSet<ReadEntity> sortedInputs, StringBuilder buffer, Map<ReadEntity, Referenceable> refs, boolean ignoreHDFSPathsInQFName) throws HiveException {
        if (refs != null && sortedInputs != null) {
            LinkedHashSet<String> dataSetsProcessed = new LinkedHashSet<String>();
            for (Entity entity : sortedInputs) {
                if (dataSetsProcessed.contains(entity.getName().toLowerCase())) continue;
                if (ignoreHDFSPathsInQFName && (Entity.Type.DFS_DIR.equals((Object)entity.getType()) || Entity.Type.LOCAL_DIR.equals((Object)entity.getType()))) {
                    LOG.debug("Skipping dfs dir input addition to process qualified name {} ", (Object)entity.getName());
                } else if (refs.containsKey(entity)) {
                    if (entity.getType() == Entity.Type.PARTITION || entity.getType() == Entity.Type.TABLE) {
                        Date createTime = HiveMetaStoreBridge.getTableCreatedTime(hiveBridge.hiveClient.getTable(entity.getTable().getDbName(), entity.getTable().getTableName()));
                        HiveHook.addDataset(buffer, refs.get(entity), createTime.getTime());
                    } else {
                        HiveHook.addDataset(buffer, refs.get(entity));
                    }
                }
                dataSetsProcessed.add(entity.getName().toLowerCase());
            }
        }
    }

    private static void addDataset(StringBuilder buffer, Referenceable ref, long createTime) {
        HiveHook.addDataset(buffer, ref);
        buffer.append(SEP);
        buffer.append(createTime);
    }

    private static void addDataset(StringBuilder buffer, Referenceable ref) {
        buffer.append(SEP);
        String dataSetQlfdName = (String)ref.get("qualifiedName");
        buffer.append(dataSetQlfdName.toLowerCase().replaceAll("/", ""));
    }

    private static void addOutputs(HiveMetaStoreBridge hiveBridge, HiveOperation op, SortedSet<WriteEntity> sortedOutputs, StringBuilder buffer, Map<WriteEntity, Referenceable> refs, boolean ignoreHDFSPathsInQFName) throws HiveException {
        if (refs != null) {
            LinkedHashSet<String> dataSetsProcessed = new LinkedHashSet<String>();
            if (sortedOutputs != null) {
                Iterator i$ = sortedOutputs.iterator();
                while (i$.hasNext()) {
                    WriteEntity output;
                    WriteEntity entity = output = (WriteEntity)i$.next();
                    if (dataSetsProcessed.contains(output.getName().toLowerCase())) continue;
                    if (HiveHook.addQueryType(op, entity)) {
                        buffer.append(SEP);
                        buffer.append(entity.getWriteType().name());
                    }
                    if (ignoreHDFSPathsInQFName && (Entity.Type.DFS_DIR.equals((Object)output.getType()) || Entity.Type.LOCAL_DIR.equals((Object)output.getType()))) {
                        LOG.debug("Skipping dfs dir output addition to process qualified name {} ", (Object)output.getName());
                    } else if (refs.containsKey(output)) {
                        if (output.getType() == Entity.Type.PARTITION || output.getType() == Entity.Type.TABLE) {
                            Date createTime = HiveMetaStoreBridge.getTableCreatedTime(hiveBridge.hiveClient.getTable(output.getTable().getDbName(), output.getTable().getTableName()));
                            HiveHook.addDataset(buffer, refs.get(output), createTime.getTime());
                        } else {
                            HiveHook.addDataset(buffer, refs.get(output));
                        }
                    }
                    dataSetsProcessed.add(output.getName().toLowerCase());
                }
            }
        }
    }

    private static boolean addQueryType(HiveOperation op, WriteEntity entity) {
        if (entity.getWriteType() != null && HiveOperation.QUERY.equals((Object)op)) {
            switch (entity.getWriteType()) {
                case INSERT: 
                case INSERT_OVERWRITE: 
                case UPDATE: 
                case DELETE: {
                    return true;
                }
                case PATH_WRITE: {
                    if (Entity.Type.LOCAL_DIR.equals((Object)entity.getType())) break;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        try {
            boolean isSync = atlasProperties.getBoolean(CONF_SYNC, Boolean.FALSE);
            if (!isSync) {
                int minThreads = atlasProperties.getInt(MIN_THREADS, 1);
                int maxThreads = atlasProperties.getInt(MAX_THREADS, 5);
                long keepAliveTime = atlasProperties.getLong(KEEP_ALIVE_TIME, 10L);
                int queueSize = atlasProperties.getInt(QUEUE_SIZE, 10000);
                executor = new ThreadPoolExecutor(minThreads, maxThreads, keepAliveTime, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new ThreadFactoryBuilder().setNameFormat("Atlas Logger %d").build());
                ShutdownHookManager.get().addShutdownHook((Runnable)new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            LOG.info("==> Shutdown of Atlas Hive Hook");
                            executor.shutdown();
                            executor.awaitTermination(3L, TimeUnit.SECONDS);
                            executor = null;
                        }
                        catch (InterruptedException ie) {
                            LOG.info("Interrupt received in shutdown.");
                        }
                        finally {
                            LOG.info("<== Shutdown of Atlas Hive Hook");
                        }
                    }
                }, 30);
            }
            HiveHook.setupOperationMap();
        }
        catch (Exception e) {
            LOG.info("Attempting to send msg while shutdown in progress.", (Throwable)e);
        }
        hiveConf = new HiveConf();
        LOG.info("Created Atlas Hook");
        entityComparator = new EntityComparator();
    }

    @VisibleForTesting
    static final class EntityComparator
    implements Comparator<Entity> {
        EntityComparator() {
        }

        @Override
        public int compare(Entity o1, Entity o2) {
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    }

    public static class HiveEventContext {
        private Set<ReadEntity> inputs;
        private Set<WriteEntity> outputs;
        private String user;
        private UserGroupInformation ugi;
        private HiveOperation operation;
        private HookContext.HookType hookType;
        private JSONObject jsonPlan;
        private String queryId;
        private String queryStr;
        private Long queryStartTime;
        private List<HookNotification.HookNotificationMessage> messages = new ArrayList<HookNotification.HookNotificationMessage>();
        private String queryType;

        public void setInputs(Set<ReadEntity> inputs) {
            this.inputs = inputs;
        }

        public void setOutputs(Set<WriteEntity> outputs) {
            this.outputs = outputs;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setUgi(UserGroupInformation ugi) {
            this.ugi = ugi;
        }

        public void setOperation(HiveOperation operation) {
            this.operation = operation;
        }

        public void setHookType(HookContext.HookType hookType) {
            this.hookType = hookType;
        }

        public void setJsonPlan(JSONObject jsonPlan) {
            this.jsonPlan = jsonPlan;
        }

        public void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        public void setQueryStr(String queryStr) {
            this.queryStr = queryStr;
        }

        public void setQueryStartTime(Long queryStartTime) {
            this.queryStartTime = queryStartTime;
        }

        public void setQueryType(String queryType) {
            this.queryType = queryType;
        }

        public Set<ReadEntity> getInputs() {
            return this.inputs;
        }

        public Set<WriteEntity> getOutputs() {
            return this.outputs;
        }

        public String getUser() {
            return this.user;
        }

        public UserGroupInformation getUgi() {
            return this.ugi;
        }

        public HiveOperation getOperation() {
            return this.operation;
        }

        public HookContext.HookType getHookType() {
            return this.hookType;
        }

        public JSONObject getJsonPlan() {
            return this.jsonPlan;
        }

        public String getQueryId() {
            return this.queryId;
        }

        public String getQueryStr() {
            return this.queryStr;
        }

        public Long getQueryStartTime() {
            return this.queryStartTime;
        }

        public String getQueryType() {
            return this.queryType;
        }

        public void addMessage(HookNotification.HookNotificationMessage message) {
            this.messages.add(message);
        }

        public List<HookNotification.HookNotificationMessage> getMessages() {
            return this.messages;
        }
    }
}

