/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hive.bridge;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.ClientResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasClient;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.fs.model.FSDataModel;
import org.apache.atlas.fs.model.FSDataTypes;
import org.apache.atlas.hive.hook.HiveHook;
import org.apache.atlas.hive.model.HiveDataModelGenerator;
import org.apache.atlas.hive.model.HiveDataTypes;
import org.apache.atlas.typesystem.IStruct;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.atlas.typesystem.Struct;
import org.apache.atlas.typesystem.TypesDef;
import org.apache.atlas.typesystem.json.InstanceSerialization;
import org.apache.atlas.typesystem.json.TypesSerialization;
import org.apache.atlas.typesystem.persistence.Id;
import org.apache.atlas.utils.AuthenticationUtil;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStoreBridge {
    private static final String DEFAULT_DGI_URL = "http://localhost:21000/";
    public static final String HIVE_CLUSTER_NAME = "atlas.cluster.name";
    public static final String DEFAULT_CLUSTER_NAME = "primary";
    public static final String DESCRIPTION_ATTR = "description";
    public static final String TEMP_TABLE_PREFIX = "_temp-";
    private final String clusterName;
    public static final long MILLIS_CONVERT_FACTOR = 1000L;
    public static final String ATLAS_ENDPOINT = "atlas.rest.address";
    private static final Logger LOG = LoggerFactory.getLogger(HiveMetaStoreBridge.class);
    public final Hive hiveClient;
    private AtlasClient atlasClient = null;

    HiveMetaStoreBridge(String clusterName, Hive hiveClient, AtlasClient atlasClient) {
        this.clusterName = clusterName;
        this.hiveClient = hiveClient;
        this.atlasClient = atlasClient;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public HiveMetaStoreBridge(Configuration atlasProperties, HiveConf hiveConf) throws Exception {
        this(atlasProperties, hiveConf, null);
    }

    public HiveMetaStoreBridge(Configuration atlasProperties, HiveConf hiveConf, AtlasClient atlasClient) throws Exception {
        this(atlasProperties.getString(HIVE_CLUSTER_NAME, DEFAULT_CLUSTER_NAME), Hive.get((HiveConf)hiveConf), atlasClient);
    }

    AtlasClient getAtlasClient() {
        return this.atlasClient;
    }

    void importHiveMetadata(boolean failOnError) throws Exception {
        LOG.info("Importing hive metadata");
        this.importDatabases(failOnError);
    }

    private void importDatabases(boolean failOnError) throws Exception {
        List databases = this.hiveClient.getAllDatabases();
        for (String databaseName : databases) {
            Referenceable dbReference = this.registerDatabase(databaseName);
            if (dbReference == null) continue;
            this.importTables(dbReference, databaseName, failOnError);
        }
    }

    public Referenceable createDBInstance(Database hiveDB) throws HiveException {
        return this.createOrUpdateDBInstance(hiveDB, null);
    }

    private Referenceable registerDatabase(String databaseName) throws Exception {
        Referenceable dbRef = this.getDatabaseReference(this.clusterName, databaseName);
        Database db = this.hiveClient.getDatabase(databaseName);
        if (db != null) {
            if (dbRef == null) {
                dbRef = this.createDBInstance(db);
                dbRef = this.registerInstance(dbRef);
            } else {
                LOG.info("Database {} is already registered with id {}. Updating it.", (Object)databaseName, (Object)dbRef.getId().id);
                dbRef = this.createOrUpdateDBInstance(db, dbRef);
                this.updateInstance(dbRef);
            }
        }
        return dbRef;
    }

    private Referenceable createOrUpdateDBInstance(Database hiveDB, Referenceable dbRef) {
        LOG.info("Importing objects from databaseName : " + hiveDB.getName());
        if (dbRef == null) {
            dbRef = new Referenceable(HiveDataTypes.HIVE_DB.getName(), new String[0]);
        }
        String dbName = hiveDB.getName().toLowerCase();
        dbRef.set("qualifiedName", (Object)HiveMetaStoreBridge.getDBQualifiedName(this.clusterName, dbName));
        dbRef.set("name", (Object)dbName);
        dbRef.set("clusterName", (Object)this.clusterName);
        dbRef.set(DESCRIPTION_ATTR, (Object)hiveDB.getDescription());
        dbRef.set("location", (Object)hiveDB.getLocationUri());
        dbRef.set("parameters", (Object)hiveDB.getParameters());
        dbRef.set("owner", (Object)hiveDB.getOwnerName());
        if (hiveDB.getOwnerType() != null) {
            dbRef.set("ownerType", (Object)hiveDB.getOwnerType().getValue());
        }
        return dbRef;
    }

    private Referenceable registerInstance(Referenceable referenceable) throws Exception {
        String typeName = referenceable.getTypeName();
        LOG.debug("creating instance of type " + typeName);
        String entityJSON = InstanceSerialization.toJson((IStruct)referenceable, (boolean)true);
        LOG.debug("Submitting new entity {} = {}", (Object)referenceable.getTypeName(), (Object)entityJSON);
        List guids = this.getAtlasClient().createEntity(new String[]{entityJSON});
        LOG.debug("created instance for type " + typeName + ", guid: " + guids);
        return new Referenceable((String)guids.get(guids.size() - 1), referenceable.getTypeName(), null);
    }

    private Referenceable getDatabaseReference(String clusterName, String databaseName) throws Exception {
        LOG.debug("Getting reference for database {}", (Object)databaseName);
        String typeName = HiveDataTypes.HIVE_DB.getName();
        return this.getEntityReference(typeName, HiveMetaStoreBridge.getDBQualifiedName(clusterName, databaseName));
    }

    public static String getDBQualifiedName(String clusterName, String dbName) {
        return String.format("%s@%s", dbName.toLowerCase(), clusterName);
    }

    private String getCreateTableString(Table table, String location) {
        String colString = "";
        List colList = table.getAllCols();
        if (colList != null) {
            for (FieldSchema col : colList) {
                colString = colString + col.getName() + " " + col.getType() + ",";
            }
            if (colList.size() > 0) {
                colString = colString.substring(0, colString.length() - 1);
                colString = "(" + colString + ")";
            }
        }
        String query = "create external table " + table.getTableName() + colString + " location '" + location + "'";
        return query;
    }

    private int importTables(Referenceable databaseReferenceable, String databaseName, boolean failOnError) throws Exception {
        int tablesImported = 0;
        List hiveTables = this.hiveClient.getAllTables(databaseName);
        LOG.info("Importing tables {} for db {}", (Object)hiveTables.toString(), (Object)databaseName);
        for (String tableName : hiveTables) {
            int imported = this.importTable(databaseReferenceable, databaseName, tableName, failOnError);
            tablesImported += imported;
        }
        if (tablesImported == hiveTables.size()) {
            LOG.info("Successfully imported all {} tables from {} ", (Object)tablesImported, (Object)databaseName);
        } else {
            LOG.error("Able to import {} tables out of {} tables from {}. Please check logs for import errors", new Object[]{tablesImported, hiveTables.size(), databaseName});
        }
        return tablesImported;
    }

    @VisibleForTesting
    public int importTable(Referenceable databaseReferenceable, String databaseName, String tableName, boolean failOnError) throws Exception {
        try {
            Table table = this.hiveClient.getTable(databaseName, tableName);
            Referenceable tableReferenceable = this.registerTable(databaseReferenceable, table);
            if (table.getTableType() == TableType.EXTERNAL_TABLE) {
                String tableQualifiedName = HiveMetaStoreBridge.getTableProcessQualifiedName(this.clusterName, table);
                Referenceable process = this.getProcessReference(tableQualifiedName);
                if (process == null) {
                    LOG.info("Attempting to register create table process for {}", (Object)tableQualifiedName);
                    Referenceable lineageProcess = new Referenceable(HiveDataTypes.HIVE_PROCESS.getName(), new String[0]);
                    ArrayList<Referenceable> sourceList = new ArrayList<Referenceable>();
                    ArrayList<Referenceable> targetList = new ArrayList<Referenceable>();
                    String tableLocation = table.getDataLocation().toString();
                    Referenceable path = this.fillHDFSDataSet(tableLocation);
                    String query = this.getCreateTableString(table, tableLocation);
                    sourceList.add(path);
                    targetList.add(tableReferenceable);
                    lineageProcess.set("inputs", sourceList);
                    lineageProcess.set("outputs", targetList);
                    lineageProcess.set("userName", (Object)table.getOwner());
                    lineageProcess.set("startTime", (Object)new Date(System.currentTimeMillis()));
                    lineageProcess.set("endTime", (Object)new Date(System.currentTimeMillis()));
                    lineageProcess.set("operationType", (Object)"CREATETABLE");
                    lineageProcess.set("queryText", (Object)query);
                    lineageProcess.set("queryId", (Object)query);
                    lineageProcess.set("queryPlan", (Object)"{}");
                    lineageProcess.set("clusterName", (Object)this.clusterName);
                    ArrayList<String> recentQueries = new ArrayList<String>(1);
                    recentQueries.add(query);
                    lineageProcess.set("recentQueries", recentQueries);
                    String processQualifiedName = HiveMetaStoreBridge.getTableProcessQualifiedName(this.clusterName, table);
                    lineageProcess.set("qualifiedName", (Object)processQualifiedName);
                    lineageProcess.set("name", (Object)query);
                    this.registerInstance(lineageProcess);
                } else {
                    LOG.info("Process {} is already registered", (Object)process.toString());
                }
            }
            return 1;
        }
        catch (Exception e) {
            LOG.error("Import failed for hive_table {} ", (Object)tableName, (Object)e);
            if (failOnError) {
                throw e;
            }
            return 0;
        }
    }

    private Referenceable getTableReference(Table hiveTable) throws Exception {
        LOG.debug("Getting reference for table {}.{}", (Object)hiveTable.getDbName(), (Object)hiveTable.getTableName());
        String typeName = HiveDataTypes.HIVE_TABLE.getName();
        String tblQualifiedName = HiveMetaStoreBridge.getTableQualifiedName(this.getClusterName(), hiveTable.getDbName(), hiveTable.getTableName());
        return this.getEntityReference(typeName, tblQualifiedName);
    }

    private Referenceable getEntityReference(String typeName, String tblQualifiedName) throws AtlasServiceException {
        AtlasClient dgiClient = this.getAtlasClient();
        try {
            return dgiClient.getEntity(typeName, "qualifiedName", tblQualifiedName);
        }
        catch (AtlasServiceException e) {
            if (e.getStatus() == ClientResponse.Status.NOT_FOUND) {
                return null;
            }
            throw e;
        }
    }

    private Referenceable getProcessReference(String qualifiedName) throws Exception {
        LOG.debug("Getting reference for process {}", (Object)qualifiedName);
        String typeName = HiveDataTypes.HIVE_PROCESS.getName();
        return this.getEntityReference(typeName, qualifiedName);
    }

    public static String getTableQualifiedName(String clusterName, String dbName, String tableName, boolean isTemporaryTable) {
        String tableTempName = tableName;
        if (isTemporaryTable) {
            tableTempName = SessionState.get() != null && SessionState.get().getSessionId() != null ? tableName + TEMP_TABLE_PREFIX + SessionState.get().getSessionId() : tableName + TEMP_TABLE_PREFIX + RandomStringUtils.random((int)10);
        }
        return String.format("%s.%s@%s", dbName.toLowerCase(), tableTempName.toLowerCase(), clusterName);
    }

    public static String getTableQualifiedName(String clusterName, Table table) {
        return HiveMetaStoreBridge.getTableQualifiedName(clusterName, table.getDbName(), table.getTableName(), table.isTemporary());
    }

    public static String getTableProcessQualifiedName(String clusterName, Table table) {
        String tableQualifiedName = HiveMetaStoreBridge.getTableQualifiedName(clusterName, table);
        Date createdTime = HiveMetaStoreBridge.getTableCreatedTime(table);
        return tableQualifiedName + HiveHook.SEP + createdTime.getTime();
    }

    public static String getTableQualifiedName(String clusterName, String dbName, String tableName) {
        return HiveMetaStoreBridge.getTableQualifiedName(clusterName, dbName, tableName, false);
    }

    public Referenceable createTableInstance(Referenceable dbReference, Table hiveTable) throws Exception {
        return this.createOrUpdateTableInstance(dbReference, null, hiveTable);
    }

    public static Date getTableCreatedTime(Table table) {
        return new Date((long)table.getTTable().getCreateTime() * 1000L);
    }

    private Referenceable createOrUpdateTableInstance(Referenceable dbReference, Referenceable tableReference, Table hiveTable) throws Exception {
        LOG.info("Importing objects from {}.{}", (Object)hiveTable.getDbName(), (Object)hiveTable.getTableName());
        if (tableReference == null) {
            tableReference = new Referenceable(HiveDataTypes.HIVE_TABLE.getName(), new String[0]);
        }
        String tableQualifiedName = HiveMetaStoreBridge.getTableQualifiedName(this.clusterName, hiveTable);
        tableReference.set("qualifiedName", (Object)tableQualifiedName);
        tableReference.set("name", (Object)hiveTable.getTableName().toLowerCase());
        tableReference.set("owner", (Object)hiveTable.getOwner());
        Date createDate = new Date();
        if (hiveTable.getTTable() != null) {
            try {
                createDate = HiveMetaStoreBridge.getTableCreatedTime(hiveTable);
                LOG.debug("Setting create time to {} ", (Object)createDate);
                tableReference.set("createTime", (Object)createDate);
            }
            catch (Exception ne) {
                LOG.error("Error while setting createTime for the table {} ", (Object)hiveTable.getCompleteName(), (Object)ne);
            }
        }
        Date lastAccessTime = createDate;
        if (hiveTable.getLastAccessTime() > 0) {
            lastAccessTime = new Date((long)hiveTable.getLastAccessTime() * 1000L);
        }
        tableReference.set("lastAccessTime", (Object)lastAccessTime);
        tableReference.set("retention", (Object)hiveTable.getRetention());
        tableReference.set("comment", hiveTable.getParameters().get("comment"));
        tableReference.set("db", (Object)dbReference);
        Referenceable sdReferenceable = this.fillStorageDesc(hiveTable.getSd(), tableQualifiedName, HiveMetaStoreBridge.getStorageDescQFName(tableQualifiedName), tableReference.getId());
        tableReference.set("sd", (Object)sdReferenceable);
        tableReference.set("parameters", (Object)hiveTable.getParameters());
        if (hiveTable.getViewOriginalText() != null) {
            tableReference.set("viewOriginalText", (Object)hiveTable.getViewOriginalText());
        }
        if (hiveTable.getViewExpandedText() != null) {
            tableReference.set("viewExpandedText", (Object)hiveTable.getViewExpandedText());
        }
        tableReference.set("tableType", (Object)hiveTable.getTableType().name());
        tableReference.set("temporary", (Object)hiveTable.isTemporary());
        List<Referenceable> partKeys = this.getColumns(hiveTable.getPartitionKeys(), tableReference);
        tableReference.set("partitionKeys", partKeys);
        tableReference.set("columns", this.getColumns(hiveTable.getCols(), tableReference));
        return tableReference;
    }

    public static String getStorageDescQFName(String entityQualifiedName) {
        return entityQualifiedName + "_storage";
    }

    private Referenceable registerTable(Referenceable dbReference, Table table) throws Exception {
        String dbName = table.getDbName();
        String tableName = table.getTableName();
        LOG.info("Attempting to register table [" + tableName + "]");
        Referenceable tableReference = this.getTableReference(table);
        LOG.info("Found result " + tableReference);
        if (tableReference == null) {
            tableReference = this.createTableInstance(dbReference, table);
            tableReference = this.registerInstance(tableReference);
        } else {
            LOG.info("Table {}.{} is already registered with id {}. Updating entity.", new Object[]{dbName, tableName, tableReference.getId().id});
            tableReference = this.createOrUpdateTableInstance(dbReference, tableReference, table);
            this.updateInstance(tableReference);
        }
        return tableReference;
    }

    private void updateInstance(Referenceable referenceable) throws AtlasServiceException {
        String typeName = referenceable.getTypeName();
        LOG.debug("updating instance of type " + typeName);
        String entityJSON = InstanceSerialization.toJson((IStruct)referenceable, (boolean)true);
        LOG.debug("Updating entity {} = {}", (Object)referenceable.getTypeName(), (Object)entityJSON);
        this.atlasClient.updateEntity(referenceable.getId().id, referenceable);
    }

    public Referenceable fillStorageDesc(StorageDescriptor storageDesc, String tableQualifiedName, String sdQualifiedName, Id tableId) throws Exception {
        LOG.debug("Filling storage descriptor information for " + storageDesc);
        Referenceable sdReferenceable = new Referenceable(HiveDataTypes.HIVE_STORAGEDESC.getName(), new String[0]);
        sdReferenceable.set("qualifiedName", (Object)sdQualifiedName);
        SerDeInfo serdeInfo = storageDesc.getSerdeInfo();
        LOG.debug("serdeInfo = " + serdeInfo);
        String serdeInfoName = HiveDataTypes.HIVE_SERDE.getName();
        Struct serdeInfoStruct = new Struct(serdeInfoName);
        serdeInfoStruct.set("name", (Object)serdeInfo.getName());
        serdeInfoStruct.set("serializationLib", (Object)serdeInfo.getSerializationLib());
        serdeInfoStruct.set("parameters", (Object)serdeInfo.getParameters());
        sdReferenceable.set("serdeInfo", (Object)serdeInfoStruct);
        sdReferenceable.set("numBuckets", (Object)storageDesc.getNumBuckets());
        sdReferenceable.set("storedAsSubDirectories", (Object)storageDesc.isStoredAsSubDirectories());
        ArrayList<Struct> sortColsStruct = new ArrayList<Struct>();
        for (Order sortcol : storageDesc.getSortCols()) {
            String hiveOrderName = HiveDataTypes.HIVE_ORDER.getName();
            Struct colStruct = new Struct(hiveOrderName);
            colStruct.set("col", (Object)sortcol.getCol());
            colStruct.set("order", (Object)sortcol.getOrder());
            sortColsStruct.add(colStruct);
        }
        if (sortColsStruct.size() > 0) {
            sdReferenceable.set("sortCols", sortColsStruct);
        }
        sdReferenceable.set("location", (Object)storageDesc.getLocation());
        sdReferenceable.set("inputFormat", (Object)storageDesc.getInputFormat());
        sdReferenceable.set("outputFormat", (Object)storageDesc.getOutputFormat());
        sdReferenceable.set("compressed", (Object)storageDesc.isCompressed());
        if (storageDesc.getBucketCols().size() > 0) {
            sdReferenceable.set("bucketCols", (Object)storageDesc.getBucketCols());
        }
        sdReferenceable.set("parameters", (Object)storageDesc.getParameters());
        sdReferenceable.set("storedAsSubDirectories", (Object)storageDesc.isStoredAsSubDirectories());
        sdReferenceable.set("table", (Object)tableId);
        return sdReferenceable;
    }

    public Referenceable fillHDFSDataSet(String pathUri) {
        Referenceable ref = new Referenceable(FSDataTypes.HDFS_PATH().toString(), new String[0]);
        ref.set("path", (Object)pathUri);
        Path path = new Path(pathUri);
        ref.set("name", (Object)path.getName());
        ref.set("qualifiedName", (Object)pathUri);
        return ref;
    }

    public static String getColumnQualifiedName(String tableQualifiedName, String colName) {
        String[] parts = tableQualifiedName.split("@");
        String tableName = parts[0];
        String clusterName = parts[1];
        return String.format("%s.%s@%s", tableName, colName.toLowerCase(), clusterName);
    }

    public List<Referenceable> getColumns(List<FieldSchema> schemaList, Referenceable tableReference) throws Exception {
        ArrayList<Referenceable> colList = new ArrayList<Referenceable>();
        int columnPosition = 0;
        for (FieldSchema fs : schemaList) {
            LOG.debug("Processing field " + fs);
            Referenceable colReferenceable = new Referenceable(HiveDataTypes.HIVE_COLUMN.getName(), new String[0]);
            colReferenceable.set("qualifiedName", (Object)HiveMetaStoreBridge.getColumnQualifiedName((String)tableReference.get("qualifiedName"), fs.getName()));
            colReferenceable.set("name", (Object)fs.getName());
            colReferenceable.set("owner", tableReference.get("owner"));
            colReferenceable.set("type", (Object)fs.getType());
            colReferenceable.set("position", (Object)columnPosition++);
            colReferenceable.set("comment", (Object)fs.getComment());
            colReferenceable.set("table", (Object)tableReference.getId());
            colList.add(colReferenceable);
        }
        return colList;
    }

    public synchronized void registerHiveDataModel() throws Exception {
        block5: {
            AtlasClient dgiClient;
            HiveDataModelGenerator dataModelGenerator;
            block4: {
                dataModelGenerator = new HiveDataModelGenerator();
                dgiClient = this.getAtlasClient();
                try {
                    dgiClient.getType(FSDataTypes.HDFS_PATH().toString());
                    LOG.info("HDFS data model is already registered!");
                }
                catch (AtlasServiceException ase) {
                    if (ase.getStatus() != ClientResponse.Status.NOT_FOUND) break block4;
                    FSDataModel.main(null);
                    String hdfsModelJson = TypesSerialization.toJson((TypesDef)FSDataModel.typesDef());
                    LOG.info("Registering HDFS data model : " + hdfsModelJson);
                    dgiClient.createType(hdfsModelJson);
                }
            }
            try {
                dgiClient.getType(HiveDataTypes.HIVE_PROCESS.getName());
                LOG.info("Hive data model is already registered!");
            }
            catch (AtlasServiceException ase) {
                if (ase.getStatus() != ClientResponse.Status.NOT_FOUND) break block5;
                LOG.info("Registering Hive data model");
                dgiClient.createType(dataModelGenerator.getModelAsJson());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        AtlasClient atlasClient;
        Configuration atlasConf = ApplicationProperties.get();
        String[] atlasEndpoint = atlasConf.getStringArray(ATLAS_ENDPOINT);
        if (atlasEndpoint == null || atlasEndpoint.length == 0) {
            atlasEndpoint = new String[]{DEFAULT_DGI_URL};
        }
        if (!AuthenticationUtil.isKerberosAuthenticationEnabled()) {
            String[] basicAuthUsernamePassword = AuthenticationUtil.getBasicAuthenticationInput();
            atlasClient = new AtlasClient(atlasEndpoint, basicAuthUsernamePassword);
        } else {
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            atlasClient = new AtlasClient(ugi, ugi.getShortUserName(), atlasEndpoint);
        }
        Options options = new Options();
        BasicParser parser = new BasicParser();
        CommandLine cmd = parser.parse(options, args);
        boolean failOnError = false;
        if (cmd.hasOption("failOnError")) {
            failOnError = true;
        }
        HiveMetaStoreBridge hiveMetaStoreBridge = new HiveMetaStoreBridge(atlasConf, new HiveConf(), atlasClient);
        hiveMetaStoreBridge.registerHiveDataModel();
        hiveMetaStoreBridge.importHiveMetadata(failOnError);
    }
}

