/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hbase.hook;

import java.io.IOException;
import java.util.Optional;
import org.apache.atlas.plugin.classloader.AtlasPluginClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;

public class HBaseAtlasCoprocessor
implements MasterCoprocessor,
MasterObserver,
RegionObserver,
RegionServerObserver {
    public static final Log LOG = LogFactory.getLog(HBaseAtlasCoprocessor.class);
    private static final String ATLAS_PLUGIN_TYPE = "hbase";
    private static final String ATLAS_HBASE_HOOK_IMPL_CLASSNAME = "org.apache.atlas.hbase.hook.HBaseAtlasCoprocessor";
    private AtlasPluginClassLoader atlasPluginClassLoader = null;
    private Object impl = null;
    private MasterObserver implMasterObserver = null;
    private RegionObserver implRegionObserver = null;
    private RegionServerObserver implRegionServerObserver = null;
    private MasterCoprocessor implMasterCoprocessor = null;

    public HBaseAtlasCoprocessor() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.HBaseAtlasCoprocessor()");
        }
        this.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.HBaseAtlasCoprocessor()");
        }
    }

    private void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.init()");
        }
        try {
            this.atlasPluginClassLoader = AtlasPluginClassLoader.getInstance((String)ATLAS_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(ATLAS_HBASE_HOOK_IMPL_CLASSNAME, true, (ClassLoader)this.atlasPluginClassLoader);
            this.activatePluginClassLoader();
            this.impl = cls.newInstance();
            this.implMasterObserver = (MasterObserver)this.impl;
            this.implRegionObserver = (RegionObserver)this.impl;
            this.implRegionServerObserver = (RegionServerObserver)this.impl;
            this.implMasterCoprocessor = (MasterCoprocessor)this.impl;
        }
        catch (Exception e) {
            LOG.error((Object)"Error Enabling RangerHbasePlugin", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.init()");
        }
    }

    public Optional<MasterObserver> getMasterObserver() {
        return Optional.of(this);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.start()");
        }
        try {
            this.activatePluginClassLoader();
            if (env instanceof MasterCoprocessorEnvironment) {
                this.implMasterCoprocessor.start(env);
            }
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.start()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postCreateTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCreateTable(ctx, desc, regions);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postCreateTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, TableDescriptor htd) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postModifyTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postModifyTable(ctx, tableName, htd);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postModifyTable()");
        }
    }

    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postDeleteTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteTable(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postDeleteTable()");
        }
    }

    public void postCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preCreateNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCreateNamespace(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preCreateNamespace()");
        }
    }

    public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preDeleteNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteNamespace(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preDeleteNamespace()");
        }
    }

    public void postModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preModifyNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preModifyNamespace(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preModifyNamespace()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> observerContext, SnapshotDescription snapshot, TableDescriptor tableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postCloneSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCloneSnapshot(observerContext, snapshot, tableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postCloneSnapshot()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> observerContext, SnapshotDescription snapshot, TableDescriptor tableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postRestoreSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postRestoreSnapshot(observerContext, snapshot, tableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postRestoreSnapshot()");
        }
    }

    private void activatePluginClassLoader() {
        if (this.atlasPluginClassLoader != null) {
            this.atlasPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.atlasPluginClassLoader != null) {
            this.atlasPluginClassLoader.deactivate();
        }
    }
}

