/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.hbase.hook;

import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.atlas.plugin.classloader.AtlasPluginClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BulkLoadObserver;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerObserver;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.protobuf.generated.SecureBulkLoadProtos;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WALKey;

public class HBaseAtlasCoprocessor
implements MasterObserver,
RegionObserver,
RegionServerObserver,
BulkLoadObserver {
    public static final Log LOG = LogFactory.getLog(HBaseAtlasCoprocessor.class);
    private static final String ATLAS_PLUGIN_TYPE = "hbase";
    private static final String ATLAS_HBASE_HOOK_IMPL_CLASSNAME = "org.apache.atlas.hbase.hook.HBaseAtlasCoprocessor";
    private AtlasPluginClassLoader atlasPluginClassLoader = null;
    private Object impl = null;
    private MasterObserver implMasterObserver = null;
    private RegionObserver implRegionObserver = null;
    private RegionServerObserver implRegionServerObserver = null;
    private BulkLoadObserver implBulkLoadObserver = null;

    public HBaseAtlasCoprocessor() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.HBaseAtlasCoprocessor()");
        }
        this.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.HBaseAtlasCoprocessor()");
        }
    }

    private void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.init()");
        }
        try {
            this.atlasPluginClassLoader = AtlasPluginClassLoader.getInstance((String)ATLAS_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(ATLAS_HBASE_HOOK_IMPL_CLASSNAME, true, (ClassLoader)this.atlasPluginClassLoader);
            this.activatePluginClassLoader();
            this.impl = cls.newInstance();
            this.implMasterObserver = (MasterObserver)this.impl;
            this.implRegionObserver = (RegionObserver)this.impl;
            this.implRegionServerObserver = (RegionServerObserver)this.impl;
            this.implBulkLoadObserver = (BulkLoadObserver)this.impl;
        }
        catch (Exception e) {
            LOG.error((Object)"Error Enabling RangerHbasePlugin", (Throwable)e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.init()");
        }
    }

    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postScannerClose()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postScannerClose(c, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postScannerClose()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        RegionScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postScannerOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postScannerOpen(c, scan, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postScannerOpen()");
        }
        return ret;
    }

    public void postStartMaster(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postStartMaster()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postStartMaster(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postStartMaster()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preAddColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor column) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preAddColumn()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preAddColumn(c, tableName, column);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preAddColumn()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preAppend()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preAppend(c, append);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preAppend()");
        }
        return ret;
    }

    public void preAssign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preAssign()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preAssign(c, regionInfo);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preAssign()");
        }
    }

    public void preBalance(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preBalance()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preBalance(c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preBalance()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> c, boolean newValue) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preBalanceSwitch()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implMasterObserver.preBalanceSwitch(c, newValue);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preBalanceSwitch()");
        }
        return ret;
    }

    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preBulkLoadHFile()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preBulkLoadHFile(ctx, familyPaths);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preBulkLoadHFile()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preCheckAndDelete()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCheckAndDelete(c, row, family, qualifier, compareOp, comparator, delete, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preCheckAndDelete()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preCheckAndPut()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCheckAndPut(c, row, family, qualifier, compareOp, comparator, put, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preCheckAndPut()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preCloneSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preCloneSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preCloneSnapshot()");
        }
    }

    public void preClose(ObserverContext<RegionCoprocessorEnvironment> e, boolean abortRequested) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preClose()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preClose(e, abortRequested);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preClose()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> e, Store store, InternalScanner scanner, ScanType scanType) throws IOException {
        InternalScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preCompact()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCompact(e, store, scanner, scanType);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preCompact()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> e, Store store, List<StoreFile> candidates) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preCompactSelection()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preCompactSelection(e, store, candidates);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preCompactSelection()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCreateTable(ObserverContext<MasterCoprocessorEnvironment> c, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preCreateTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preCreateTable(c, desc, regions);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preCreateTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preDelete()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preDelete(c, delete, edit, durability);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preDelete()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, byte[] col) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preDeleteColumn()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDeleteColumn(c, tableName, col);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preDeleteColumn()");
        }
    }

    public void preDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preDeleteSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDeleteSnapshot(ctx, snapshot);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preDeleteSnapshot()");
        }
    }

    public void preDeleteTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preDeleteTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDeleteTable(c, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preDeleteTable()");
        }
    }

    public void preDisableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preDisableTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDisableTable(c, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preDisableTable()");
        }
    }

    public void preEnableTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preEnableTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preEnableTable(c, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preEnableTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get, boolean exists) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preExists()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preExists(c, get, exists);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preExists()");
        }
        return ret;
    }

    public void preFlush(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preFlush()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preFlush(e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preFlush()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preGetClosestRowBefore(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, Result result) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preGetClosestRowBefore()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preGetClosestRowBefore(c, row, family, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preGetClosestRowBefore()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preIncrement()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preIncrement(c, increment);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preIncrement()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long preIncrementColumnValue(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        long ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preIncrementColumnValue()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preIncrementColumnValue(c, row, family, qualifier, amount, writeToWAL);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preIncrementColumnValue()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preModifyColumn(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HColumnDescriptor descriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preModifyColumn()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preModifyColumn(c, tableName, descriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preModifyColumn()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preModifyTable(ObserverContext<MasterCoprocessorEnvironment> c, TableName tableName, HTableDescriptor htd) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preModifyTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preModifyTable(c, tableName, htd);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preModifyTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preMove(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preMove()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preMove(c, region, srcServer, destServer);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preMove()");
        }
    }

    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preOpen()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preOpen(e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preOpen()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preRestoreSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preRestoreSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preRestoreSnapshot()");
        }
    }

    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preScannerClose()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preScannerClose(c, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preScannerClose()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preScannerNext()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preScannerNext(c, s, result, limit, hasNext);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preScannerNext()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionScanner preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        RegionScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preScannerOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preScannerOpen(c, scan, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preScannerOpen()");
        }
        return ret;
    }

    public void preShutdown(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preShutdown()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preShutdown(c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preShutdown()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preSnapshot()");
        }
    }

    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> e) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preSplit()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preSplit(e);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preSplit()");
        }
    }

    public void preStopMaster(ObserverContext<MasterCoprocessorEnvironment> c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preStopMaster()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preStopMaster(c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preStopMaster()");
        }
    }

    public void preStopRegionServer(ObserverContext<RegionServerCoprocessorEnvironment> env) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preStopRegionServer()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.preStopRegionServer(env);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preStopRegionServer()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preUnassign(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo, boolean force) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preUnassign()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preUnassign(c, regionInfo, force);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preUnassign()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSetUserQuota(ctx, userName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, TableName tableName, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSetUserQuota(ctx, userName, tableName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSetUserQuota(ctx, userName, namespace, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSetTableQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preSetTableQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSetTableQuota(ctx, tableName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preSetTableQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSetNamespaceQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preSetNamespaceQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preSetNamespaceQuota(ctx, namespace, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preSetNamespaceQuota()");
        }
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.start()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.start(env);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.start()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.prePut()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.prePut(c, put, edit, durability);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.prePut()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> rEnv, Get get, List<Cell> result) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preGetOp()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preGetOp(rEnv, get, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preGetOp()");
        }
    }

    public void preRegionOffline(ObserverContext<MasterCoprocessorEnvironment> c, HRegionInfo regionInfo) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preRegionOffline()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preRegionOffline(c, regionInfo);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preRegionOffline()");
        }
    }

    public void preCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preCreateNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preCreateNamespace(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preCreateNamespace()");
        }
    }

    public void preDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preDeleteNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDeleteNamespace(ctx, namespace);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preDeleteNamespace()");
        }
    }

    public void preModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preModifyNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preModifyNamespace(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preModifyNamespace()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors, String regex) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postGetTableDescriptors()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postGetTableDescriptors(ctx, tableNamesList, descriptors, regex);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postGetTableDescriptors()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preMerge()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.preMerge(ctx, regionA, regionB);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preMerge()");
        }
    }

    public void prePrepareBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx, SecureBulkLoadProtos.PrepareBulkLoadRequest request) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.prePrepareBulkLoad()");
        }
        try {
            this.activatePluginClassLoader();
            this.implBulkLoadObserver.prePrepareBulkLoad(ctx, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.prePrepareBulkLoad()");
        }
    }

    public void preCleanupBulkLoad(ObserverContext<RegionCoprocessorEnvironment> ctx, SecureBulkLoadProtos.CleanupBulkLoadRequest request) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preCleanupBulkLoad()");
        }
        try {
            this.activatePluginClassLoader();
            this.implBulkLoadObserver.preCleanupBulkLoad(ctx, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preCleanupBulkLoad()");
        }
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.stop()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.stop(env);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.stop()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMerge(ObserverContext<RegionServerCoprocessorEnvironment> c, Region regionA, Region regionB, Region mergedRegion) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postMerge()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.postMerge(c, regionA, regionB, mergedRegion);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postMerge()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preMergeCommit(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB, List<Mutation> metaEntries) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preMergeCommit()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.preMergeCommit(ctx, regionA, regionB, metaEntries);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preMergeCommit()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMergeCommit(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB, Region mergedRegion) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postMergeCommit()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.postMergeCommit(ctx, regionA, regionB, mergedRegion);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postMergeCommit()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRollBackMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preRollBackMerge()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.preRollBackMerge(ctx, regionA, regionB);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preRollBackMerge()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRollBackMerge(ObserverContext<RegionServerCoprocessorEnvironment> ctx, Region regionA, Region regionB) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postRollBackMerge()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.postRollBackMerge(ctx, regionA, regionB);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postRollBackMerge()");
        }
    }

    public void preRollWALWriterRequest(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preRollWALWriterRequest()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.preRollWALWriterRequest(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preRollWALWriterRequest()");
        }
    }

    public void postRollWALWriterRequest(ObserverContext<RegionServerCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postRollWALWriterRequest()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.postRollWALWriterRequest(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postRollWALWriterRequest()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationEndpoint postCreateReplicationEndPoint(ObserverContext<RegionServerCoprocessorEnvironment> ctx, ReplicationEndpoint endpoint) {
        ReplicationEndpoint ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postCreateReplicationEndPoint()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionServerObserver.postCreateReplicationEndPoint(ctx, endpoint);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postCreateReplicationEndPoint()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preReplicateLogEntries(ObserverContext<RegionServerCoprocessorEnvironment> ctx, List<AdminProtos.WALEntry> entries, CellScanner cells) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preReplicateLogEntries()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.preReplicateLogEntries(ctx, entries, cells);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preReplicateLogEntries()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postReplicateLogEntries(ObserverContext<RegionServerCoprocessorEnvironment> ctx, List<AdminProtos.WALEntry> entries, CellScanner cells) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postReplicateLogEntries()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionServerObserver.postReplicateLogEntries(ctx, entries, cells);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postReplicateLogEntries()");
        }
    }

    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postOpen()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postOpen(c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postOpen()");
        }
    }

    public void postLogReplay(ObserverContext<RegionCoprocessorEnvironment> c) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postLogReplay()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postLogReplay(c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postLogReplay()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preFlushScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, KeyValueScanner memstoreScanner, InternalScanner s) throws IOException {
        InternalScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preFlushScannerOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preFlushScannerOpen(c, store, memstoreScanner, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preFlushScannerOpen()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner) throws IOException {
        InternalScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preFlush()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preFlush(c, store, scanner);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preFlush()");
        }
        return ret;
    }

    public void postFlush(ObserverContext<RegionCoprocessorEnvironment> c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postFlush()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postFlush(c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postFlush()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postFlush()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postFlush(c, store, resultFile);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postFlush()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<StoreFile> candidates, CompactionRequest request) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preCompactSelection()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preCompactSelection(c, store, candidates, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preCompactSelection()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ImmutableList<StoreFile> selected, CompactionRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postCompactSelection()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postCompactSelection(c, store, selected, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postCompactSelection()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ImmutableList<StoreFile> selected) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postCompactSelection()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postCompactSelection(c, store, selected);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postCompactSelection()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, ScanType scanType, CompactionRequest request) throws IOException {
        InternalScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preCompact()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCompact(c, store, scanner, scanType, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preCompact()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends KeyValueScanner> scanners, ScanType scanType, long earliestPutTs, InternalScanner s, CompactionRequest request) throws IOException {
        InternalScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preCompactScannerOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCompactScannerOpen(c, store, scanners, scanType, earliestPutTs, s, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preCompactScannerOpen()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends KeyValueScanner> scanners, ScanType scanType, long earliestPutTs, InternalScanner s) throws IOException {
        InternalScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preCompactScannerOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCompactScannerOpen(c, store, scanners, scanType, earliestPutTs, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preCompactScannerOpen()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile, CompactionRequest request) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postCompact()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postCompact(c, store, resultFile, request);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postCompact()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postCompact()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postCompact(c, store, resultFile);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postCompact()");
        }
    }

    public void preSplit(ObserverContext<RegionCoprocessorEnvironment> c, byte[] splitRow) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preSplit()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preSplit(c, splitRow);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preSplit()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSplit(ObserverContext<RegionCoprocessorEnvironment> c, Region l, Region r) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postSplit()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postSplit(c, l, r);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postSplit()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSplitBeforePONR(ObserverContext<RegionCoprocessorEnvironment> ctx, byte[] splitKey, List<Mutation> metaEntries) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preSplitBeforePONR()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preSplitBeforePONR(ctx, splitKey, metaEntries);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preSplitBeforePONR()");
        }
    }

    public void preSplitAfterPONR(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preSplitAfterPONR()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preSplitAfterPONR(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preSplitAfterPONR()");
        }
    }

    public void preRollBackSplit(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preRollBackSplit()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preRollBackSplit(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preRollBackSplit()");
        }
    }

    public void postRollBackSplit(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postRollBackSplit()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postRollBackSplit(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postRollBackSplit()");
        }
    }

    public void postCompleteSplit(ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postCompleteSplit()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postCompleteSplit(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postCompleteSplit()");
        }
    }

    public void postClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postClose()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postClose(c, abortRequested);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postClose()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postGetClosestRowBefore(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, Result result) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postGetClosestRowBefore()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postGetClosestRowBefore(c, row, family, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postGetClosestRowBefore()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postGetOp()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postGetOp(c, get, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postGetOp()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postExists(ObserverContext<RegionCoprocessorEnvironment> c, Get get, boolean exists) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postExists()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postExists(c, get, exists);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postExists()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postPut()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postPut(c, put, edit, durability);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postPut()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prePrepareTimeStampForDeleteVersion(ObserverContext<RegionCoprocessorEnvironment> c, Mutation mutation, Cell cell, byte[] byteNow, Get get) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.prePrepareTimeStampForDeleteVersion()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.prePrepareTimeStampForDeleteVersion(c, mutation, cell, byteNow, get);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.prePrepareTimeStampForDeleteVersion()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postDelete()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postDelete(c, delete, edit, durability);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postDelete()");
        }
    }

    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preBatchMutate()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preBatchMutate(c, miniBatchOp);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preBatchMutate()");
        }
    }

    public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postBatchMutate()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postBatchMutate(c, miniBatchOp);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postBatchMutate()");
        }
    }

    public void postStartRegionOperation(ObserverContext<RegionCoprocessorEnvironment> ctx, Region.Operation operation) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postStartRegionOperation()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postStartRegionOperation(ctx, operation);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postStartRegionOperation()");
        }
    }

    public void postCloseRegionOperation(ObserverContext<RegionCoprocessorEnvironment> ctx, Region.Operation operation) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postCloseRegionOperation()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postCloseRegionOperation(ctx, operation);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postCloseRegionOperation()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBatchMutateIndispensably(ObserverContext<RegionCoprocessorEnvironment> ctx, MiniBatchOperationInProgress<Mutation> miniBatchOp, boolean success) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postBatchMutateIndispensably()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postBatchMutateIndispensably(ctx, miniBatchOp, success);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postBatchMutateIndispensably()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preCheckAndPutAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preCheckAndPutAfterRowLock()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCheckAndPutAfterRowLock(c, row, family, qualifier, compareOp, comparator, put, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preCheckAndPutAfterRowLock()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postCheckAndPut()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postCheckAndPut(c, row, family, qualifier, compareOp, comparator, put, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postCheckAndPut()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preCheckAndDeleteAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preCheckAndDeleteAfterRowLock()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preCheckAndDeleteAfterRowLock(c, row, family, qualifier, compareOp, comparator, delete, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preCheckAndDeleteAfterRowLock()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postCheckAndDelete()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postCheckAndDelete(c, row, family, qualifier, compareOp, comparator, delete, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postCheckAndDelete()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long postIncrementColumnValue(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL, long result) throws IOException {
        long ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postIncrementColumnValue()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postIncrementColumnValue(c, row, family, qualifier, amount, writeToWAL, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postIncrementColumnValue()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result preAppendAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, Append append) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preAppendAfterRowLock()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preAppendAfterRowLock(c, append);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preAppendAfterRowLock()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result postAppend(ObserverContext<RegionCoprocessorEnvironment> c, Append append, Result result) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postAppend()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postAppend(c, append, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postAppend()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result preIncrementAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preIncrementAfterRowLock()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preIncrementAfterRowLock(c, increment);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preIncrementAfterRowLock()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result postIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment, Result result) throws IOException {
        Result ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postIncrement()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postIncrement(c, increment, result);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postIncrement()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyValueScanner preStoreScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, Scan scan, NavigableSet<byte[]> targetCols, KeyValueScanner s) throws IOException {
        KeyValueScanner ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preStoreScannerOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preStoreScannerOpen(c, store, scan, targetCols, s);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preStoreScannerOpen()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> result, int limit, boolean hasNext) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postScannerNext()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postScannerNext(c, s, result, limit, hasNext);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postScannerNext()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postScannerFilterRow(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, byte[] currentRow, int offset, short length, boolean hasMore) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postScannerFilterRow()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postScannerFilterRow(c, s, currentRow, offset, length, hasMore);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postScannerFilterRow()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preWALRestore(ObserverContext<? extends RegionCoprocessorEnvironment> ctx, HRegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preWALRestore()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preWALRestore(ctx, info, logKey, logEdit);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preWALRestore()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postWALRestore(ObserverContext<? extends RegionCoprocessorEnvironment> ctx, HRegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postWALRestore()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postWALRestore(ctx, info, logKey, logEdit);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postWALRestore()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths, boolean hasLoaded) throws IOException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postBulkLoadHFile()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postBulkLoadHFile(ctx, familyPaths, hasLoaded);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postBulkLoadHFile()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreFile.Reader preStoreFileReaderOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, StoreFile.Reader reader) throws IOException {
        StoreFile.Reader ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preStoreFileReaderOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.preStoreFileReaderOpen(ctx, fs, p, in, size, cacheConf, r, reader);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preStoreFileReaderOpen()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreFile.Reader postStoreFileReaderOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, StoreFile.Reader reader) throws IOException {
        StoreFile.Reader ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postStoreFileReaderOpen()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postStoreFileReaderOpen(ctx, fs, p, in, size, cacheConf, r, reader);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postStoreFileReaderOpen()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cell postMutationBeforeWAL(ObserverContext<RegionCoprocessorEnvironment> ctx, RegionObserver.MutationType opType, Mutation mutation, Cell oldCell, Cell newCell) throws IOException {
        Cell ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postMutationBeforeWAL()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postMutationBeforeWAL(ctx, opType, mutation, oldCell, newCell);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postMutationBeforeWAL()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeleteTracker postInstantiateDeleteTracker(ObserverContext<RegionCoprocessorEnvironment> ctx, DeleteTracker delTracker) throws IOException {
        DeleteTracker ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postInstantiateDeleteTracker()");
        }
        try {
            this.activatePluginClassLoader();
            ret = this.implRegionObserver.postInstantiateDeleteTracker(ctx, delTracker);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postInstantiateDeleteTracker()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postCreateTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCreateTable(ctx, desc, regions);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postCreateTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preCreateTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preCreateTableHandler(ctx, desc, regions);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preCreateTableHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, HTableDescriptor desc, HRegionInfo[] regions) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postCreateTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCreateTableHandler(ctx, desc, regions);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postCreateTableHandler()");
        }
    }

    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postDeleteTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteTable(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postDeleteTable()");
        }
    }

    public void preDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preDeleteTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDeleteTableHandler(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preDeleteTableHandler()");
        }
    }

    public void postDeleteTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postDeleteTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteTableHandler(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postDeleteTableHandler()");
        }
    }

    public void preTruncateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preTruncateTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preTruncateTable(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preTruncateTable()");
        }
    }

    public void postTruncateTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postTruncateTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postTruncateTable(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postTruncateTable()");
        }
    }

    public void preTruncateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preTruncateTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preTruncateTableHandler(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preTruncateTableHandler()");
        }
    }

    public void postTruncateTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postTruncateTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postTruncateTableHandler(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postTruncateTableHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postModifyTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postModifyTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postModifyTable(ctx, tableName, htd);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postModifyTable()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preModifyTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preModifyTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preModifyTableHandler(ctx, tableName, htd);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preModifyTableHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postModifyTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HTableDescriptor htd) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postModifyTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postModifyTableHandler(ctx, tableName, htd);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postModifyTableHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAddColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postAddColumn()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postAddColumn(ctx, tableName, column);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postAddColumn()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preAddColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preAddColumnHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preAddColumnHandler(ctx, tableName, column);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preAddColumnHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postAddColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor column) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postAddColumnHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postAddColumnHandler(ctx, tableName, column);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postAddColumnHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postModifyColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postModifyColumn()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postModifyColumn(ctx, tableName, descriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postModifyColumn()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preModifyColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preModifyColumnHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preModifyColumnHandler(ctx, tableName, descriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preModifyColumnHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postModifyColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, HColumnDescriptor descriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postModifyColumnHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postModifyColumnHandler(ctx, tableName, descriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postModifyColumnHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeleteColumn(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postDeleteColumn()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteColumn(ctx, tableName, c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postDeleteColumn()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDeleteColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preDeleteColumnHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDeleteColumnHandler(ctx, tableName, c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preDeleteColumnHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeleteColumnHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, byte[] c) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postDeleteColumnHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteColumnHandler(ctx, tableName, c);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postDeleteColumnHandler()");
        }
    }

    public void postEnableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postEnableTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postEnableTable(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postEnableTable()");
        }
    }

    public void preEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preEnableTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preEnableTableHandler(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preEnableTableHandler()");
        }
    }

    public void postEnableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postEnableTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postEnableTableHandler(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postEnableTableHandler()");
        }
    }

    public void postDisableTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postDisableTable()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDisableTable(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postDisableTable()");
        }
    }

    public void preDisableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preDisableTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preDisableTableHandler(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preDisableTableHandler()");
        }
    }

    public void postDisableTableHandler(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postDisableTableHandler()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDisableTableHandler(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postDisableTableHandler()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMove(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo region, ServerName srcServer, ServerName destServer) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postMove()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postMove(ctx, region, srcServer, destServer);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postMove()");
        }
    }

    public void postAssign(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postAssign()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postAssign(ctx, regionInfo);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postAssign()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postUnassign(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo, boolean force) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postUnassign()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postUnassign(ctx, regionInfo, force);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postUnassign()");
        }
    }

    public void postRegionOffline(ObserverContext<MasterCoprocessorEnvironment> ctx, HRegionInfo regionInfo) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postRegionOffline()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postRegionOffline(ctx, regionInfo);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postRegionOffline()");
        }
    }

    public void postBalance(ObserverContext<MasterCoprocessorEnvironment> ctx, List<RegionPlan> plans) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postBalance()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postBalance(ctx, plans);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postBalance()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postBalanceSwitch(ObserverContext<MasterCoprocessorEnvironment> ctx, boolean oldValue, boolean newValue) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postBalanceSwitch()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postBalanceSwitch(ctx, oldValue, newValue);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postBalanceSwitch()");
        }
    }

    public void preMasterInitialization(ObserverContext<MasterCoprocessorEnvironment> ctx) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preMasterInitialization()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preMasterInitialization(ctx);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preMasterInitialization()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postSnapshot()");
        }
    }

    public void preListSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preListSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preListSnapshot(ctx, snapshot);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preListSnapshot()");
        }
    }

    public void postListSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postListSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postListSnapshot(ctx, snapshot);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postListSnapshot()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postCloneSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCloneSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postCloneSnapshot()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRestoreSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot, HTableDescriptor hTableDescriptor) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postRestoreSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postRestoreSnapshot(ctx, snapshot, hTableDescriptor);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postRestoreSnapshot()");
        }
    }

    public void postDeleteSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, HBaseProtos.SnapshotDescription snapshot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postDeleteSnapshot()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteSnapshot(ctx, snapshot);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postDeleteSnapshot()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preGetTableDescriptors()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preGetTableDescriptors(ctx, tableNamesList, descriptors);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preGetTableDescriptors()");
        }
    }

    public void postGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postGetTableDescriptors()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postGetTableDescriptors(ctx, descriptors);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postGetTableDescriptors()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preGetTableDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<TableName> tableNamesList, List<HTableDescriptor> descriptors, String regex) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preGetTableDescriptors()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preGetTableDescriptors(ctx, tableNamesList, descriptors, regex);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preGetTableDescriptors()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors, String regex) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preGetTableNames()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preGetTableNames(ctx, descriptors, regex);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preGetTableNames()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postGetTableNames(ObserverContext<MasterCoprocessorEnvironment> ctx, List<HTableDescriptor> descriptors, String regex) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postGetTableNames()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postGetTableNames(ctx, descriptors, regex);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postGetTableNames()");
        }
    }

    public void postCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postCreateNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postCreateNamespace(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postCreateNamespace()");
        }
    }

    public void postDeleteNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postDeleteNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postDeleteNamespace(ctx, namespace);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postDeleteNamespace()");
        }
    }

    public void postModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postModifyNamespace()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postModifyNamespace(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postModifyNamespace()");
        }
    }

    public void preGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preGetNamespaceDescriptor()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preGetNamespaceDescriptor(ctx, namespace);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preGetNamespaceDescriptor()");
        }
    }

    public void postGetNamespaceDescriptor(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postGetNamespaceDescriptor()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postGetNamespaceDescriptor(ctx, ns);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postGetNamespaceDescriptor()");
        }
    }

    public void preListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<NamespaceDescriptor> descriptors) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preListNamespaceDescriptors()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preListNamespaceDescriptors(ctx, descriptors);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preListNamespaceDescriptors()");
        }
    }

    public void postListNamespaceDescriptors(ObserverContext<MasterCoprocessorEnvironment> ctx, List<NamespaceDescriptor> descriptors) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postListNamespaceDescriptors()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postListNamespaceDescriptors(ctx, descriptors);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postListNamespaceDescriptors()");
        }
    }

    public void preTableFlush(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preTableFlush()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.preTableFlush(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preTableFlush()");
        }
    }

    public void postTableFlush(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postTableFlush()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postTableFlush(ctx, tableName);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postTableFlush()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSetUserQuota(ctx, userName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, TableName tableName, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSetUserQuota(ctx, userName, tableName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetUserQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String userName, String namespace, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postSetUserQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSetUserQuota(ctx, userName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postSetUserQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetTableQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postSetTableQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSetTableQuota(ctx, tableName, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postSetTableQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSetNamespaceQuota(ObserverContext<MasterCoprocessorEnvironment> ctx, String namespace, QuotaProtos.Quotas quotas) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postSetNamespaceQuota()");
        }
        try {
            this.activatePluginClassLoader();
            this.implMasterObserver.postSetNamespaceQuota(ctx, namespace, quotas);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postSetNamespaceQuota()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preWALRestore(ObserverContext<RegionCoprocessorEnvironment> ctx, HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.preWALRestore()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.preWALRestore(ctx, info, logKey, logEdit);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.preWALRestore()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postWALRestore(ObserverContext<RegionCoprocessorEnvironment> ctx, HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HBaseAtlasCoprocessor.postWALRestore()");
        }
        try {
            this.activatePluginClassLoader();
            this.implRegionObserver.postWALRestore(ctx, info, logKey, logEdit);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== HBaseAtlasCoprocessor.postWALRestore()");
        }
    }

    private void activatePluginClassLoader() {
        if (this.atlasPluginClassLoader != null) {
            this.atlasPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.atlasPluginClassLoader != null) {
            this.atlasPluginClassLoader.deactivate();
        }
    }

    public void preMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<HostAndPort> servers, String targetGroup) throws IOException {
    }

    public void postMoveServers(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<HostAndPort> servers, String targetGroup) throws IOException {
    }

    public void preMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
    }

    public void postMoveTables(ObserverContext<MasterCoprocessorEnvironment> ctx, Set<TableName> tables, String targetGroup) throws IOException {
    }

    public void preRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void postRemoveRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void preBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName) throws IOException {
    }

    public void postBalanceRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String groupName, boolean balancerRan) throws IOException {
    }

    public void preAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }

    public void postAddRSGroup(ObserverContext<MasterCoprocessorEnvironment> ctx, String name) throws IOException {
    }
}

