/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.falcon.bridge;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.falcon.Util.EventUtil;
import org.apache.atlas.falcon.model.FalconDataTypes;
import org.apache.atlas.hive.bridge.HiveMetaStoreBridge;
import org.apache.atlas.hive.model.HiveDataTypes;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.CatalogStorage;
import org.apache.falcon.entity.FeedHelper;
import org.apache.falcon.entity.FileSystemStorage;
import org.apache.falcon.entity.ProcessHelper;
import org.apache.falcon.entity.store.ConfigurationStore;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.cluster.Cluster;
import org.apache.falcon.entity.v0.feed.CatalogTable;
import org.apache.falcon.entity.v0.feed.ClusterType;
import org.apache.falcon.entity.v0.feed.Feed;
import org.apache.falcon.entity.v0.feed.Location;
import org.apache.falcon.entity.v0.feed.LocationType;
import org.apache.falcon.entity.v0.process.Output;
import org.apache.falcon.entity.v0.process.Process;
import org.apache.falcon.entity.v0.process.Workflow;
import org.apache.falcon.workflow.WorkflowExecutionArgs;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FalconBridge {
    private static final Logger LOG = LoggerFactory.getLogger(FalconBridge.class);
    public static final String COLO = "colo";
    public static final String TAGS = "tags";
    public static final String GROUPS = "groups";
    public static final String PIPELINES = "pipelines";
    public static final String WFPROPERTIES = "workflow-properties";
    public static final String RUNSON = "runs-on";
    public static final String STOREDIN = "stored-in";
    public static final String FREQUENCY = "frequency";

    public static Referenceable createClusterEntity(Cluster cluster) {
        LOG.info("Creating cluster Entity : {}", (Object)cluster.getName());
        Referenceable clusterRef = new Referenceable(FalconDataTypes.FALCON_CLUSTER.getName(), new String[0]);
        clusterRef.set("name", (Object)cluster.getName());
        clusterRef.set("description", (Object)cluster.getDescription());
        clusterRef.set("qualifiedName", (Object)cluster.getName());
        clusterRef.set(COLO, (Object)cluster.getColo());
        if (cluster.getACL() != null) {
            clusterRef.set("owner", (Object)cluster.getACL().getGroup());
        }
        if (StringUtils.isNotEmpty((CharSequence)cluster.getTags())) {
            clusterRef.set(TAGS, EventUtil.convertKeyValueStringToMap(cluster.getTags()));
        }
        return clusterRef;
    }

    private static Referenceable createFeedEntity(Feed feed, Referenceable clusterReferenceable) {
        LOG.info("Creating feed dataset: {}", (Object)feed.getName());
        Referenceable feedEntity = new Referenceable(FalconDataTypes.FALCON_FEED.getName(), new String[0]);
        feedEntity.set("name", (Object)feed.getName());
        feedEntity.set("description", (Object)feed.getDescription());
        String feedQualifiedName = FalconBridge.getFeedQualifiedName(feed.getName(), (String)clusterReferenceable.get("name"));
        feedEntity.set("qualifiedName", (Object)feedQualifiedName);
        feedEntity.set(FREQUENCY, (Object)feed.getFrequency().toString());
        feedEntity.set(STOREDIN, (Object)clusterReferenceable);
        if (feed.getACL() != null) {
            feedEntity.set("owner", (Object)feed.getACL().getOwner());
        }
        if (StringUtils.isNotEmpty((CharSequence)feed.getTags())) {
            feedEntity.set(TAGS, EventUtil.convertKeyValueStringToMap(feed.getTags()));
        }
        if (feed.getGroups() != null) {
            feedEntity.set(GROUPS, (Object)feed.getGroups());
        }
        return feedEntity;
    }

    public static List<Referenceable> createFeedCreationEntity(Feed feed, ConfigurationStore falconStore) throws FalconException, URISyntaxException {
        LOG.info("Creating feed : {}", (Object)feed.getName());
        ArrayList<Referenceable> entities = new ArrayList<Referenceable>();
        if (feed.getClusters() != null) {
            ArrayList<Referenceable> replicationInputs = new ArrayList<Referenceable>();
            ArrayList<Referenceable> replicationOutputs = new ArrayList<Referenceable>();
            for (org.apache.falcon.entity.v0.feed.Cluster feedCluster : feed.getClusters().getClusters()) {
                Cluster cluster = (Cluster)falconStore.get(EntityType.CLUSTER, feedCluster.getName());
                Referenceable clusterReferenceable = FalconBridge.getClusterEntityReference(cluster.getName(), cluster.getColo());
                entities.add(clusterReferenceable);
                ArrayList<Referenceable> inputs = new ArrayList<Referenceable>();
                List<Referenceable> inputReferenceables = FalconBridge.getInputEntities(cluster, feed);
                if (inputReferenceables != null) {
                    entities.addAll(inputReferenceables);
                    inputs.add(inputReferenceables.get(inputReferenceables.size() - 1));
                }
                ArrayList<Referenceable> outputs = new ArrayList<Referenceable>();
                Referenceable feedEntity = FalconBridge.createFeedEntity(feed, clusterReferenceable);
                if (feedEntity != null) {
                    entities.add(feedEntity);
                    outputs.add(feedEntity);
                }
                if (!inputs.isEmpty() || !outputs.isEmpty()) {
                    Referenceable feedCreateEntity = new Referenceable(FalconDataTypes.FALCON_FEED_CREATION.getName(), new String[0]);
                    String feedQualifiedName = FalconBridge.getFeedQualifiedName(feed.getName(), cluster.getName());
                    feedCreateEntity.set("name", (Object)feed.getName());
                    feedCreateEntity.set("description", (Object)("Feed creation - " + feed.getName()));
                    feedCreateEntity.set("qualifiedName", (Object)feedQualifiedName);
                    if (!inputs.isEmpty()) {
                        feedCreateEntity.set("inputs", inputs);
                    }
                    if (!outputs.isEmpty()) {
                        feedCreateEntity.set("outputs", outputs);
                    }
                    feedCreateEntity.set(STOREDIN, (Object)clusterReferenceable);
                    entities.add(feedCreateEntity);
                }
                if (ClusterType.SOURCE == feedCluster.getType()) {
                    replicationInputs.add(feedEntity);
                    continue;
                }
                if (ClusterType.TARGET != feedCluster.getType()) continue;
                replicationOutputs.add(feedEntity);
            }
            if (!replicationInputs.isEmpty() && !replicationInputs.isEmpty()) {
                Referenceable feedReplicationEntity = new Referenceable(FalconDataTypes.FALCON_FEED_REPLICATION.getName(), new String[0]);
                feedReplicationEntity.set("name", (Object)feed.getName());
                feedReplicationEntity.set("qualifiedName", (Object)feed.getName());
                feedReplicationEntity.set("inputs", replicationInputs);
                feedReplicationEntity.set("outputs", replicationOutputs);
                entities.add(feedReplicationEntity);
            }
        }
        return entities;
    }

    public static List<Referenceable> createProcessEntity(Process process, ConfigurationStore falconStore) throws FalconException {
        LOG.info("Creating process Entity : {}", (Object)process.getName());
        ArrayList<Referenceable> entities = new ArrayList<Referenceable>();
        if (process.getClusters() != null) {
            for (org.apache.falcon.entity.v0.process.Cluster processCluster : process.getClusters().getClusters()) {
                Cluster cluster = (Cluster)falconStore.get(EntityType.CLUSTER, processCluster.getName());
                Referenceable clusterReferenceable = FalconBridge.getClusterEntityReference(cluster.getName(), cluster.getColo());
                entities.add(clusterReferenceable);
                ArrayList<Referenceable> inputs = new ArrayList<Referenceable>();
                if (process.getInputs() != null) {
                    for (Object input : process.getInputs().getInputs()) {
                        Feed feed = (Feed)falconStore.get(EntityType.FEED, input.getFeed());
                        Referenceable inputReferenceable = FalconBridge.getFeedDataSetReference(feed, clusterReferenceable);
                        entities.add(inputReferenceable);
                        inputs.add(inputReferenceable);
                    }
                }
                ArrayList<Referenceable> outputs = new ArrayList<Referenceable>();
                if (process.getOutputs() != null) {
                    Object input;
                    input = process.getOutputs().getOutputs().iterator();
                    while (input.hasNext()) {
                        Output output = (Output)input.next();
                        Feed feed = (Feed)falconStore.get(EntityType.FEED, output.getFeed());
                        Referenceable outputReferenceable = FalconBridge.getFeedDataSetReference(feed, clusterReferenceable);
                        entities.add(outputReferenceable);
                        outputs.add(outputReferenceable);
                    }
                }
                if (inputs.isEmpty() && outputs.isEmpty()) continue;
                Referenceable processEntity = new Referenceable(FalconDataTypes.FALCON_PROCESS.getName(), new String[0]);
                processEntity.set("name", (Object)process.getName());
                processEntity.set("qualifiedName", (Object)FalconBridge.getProcessQualifiedName(process.getName(), cluster.getName()));
                processEntity.set(FREQUENCY, (Object)process.getFrequency().toString());
                if (!inputs.isEmpty()) {
                    processEntity.set("inputs", inputs);
                }
                if (!outputs.isEmpty()) {
                    processEntity.set("outputs", outputs);
                }
                processEntity.set(RUNSON, (Object)clusterReferenceable);
                if (process.getACL() != null) {
                    processEntity.set("owner", (Object)process.getACL().getOwner());
                }
                if (StringUtils.isNotEmpty((CharSequence)process.getTags())) {
                    processEntity.set(TAGS, EventUtil.convertKeyValueStringToMap(process.getTags()));
                }
                if (process.getPipelines() != null) {
                    processEntity.set(PIPELINES, (Object)process.getPipelines());
                }
                processEntity.set(WFPROPERTIES, FalconBridge.getProcessEntityWFProperties(process.getWorkflow(), process.getName()));
                entities.add(processEntity);
            }
        }
        return entities;
    }

    private static List<Referenceable> getInputEntities(Cluster cluster, Feed feed) throws URISyntaxException {
        org.apache.falcon.entity.v0.feed.Cluster feedCluster = FeedHelper.getCluster((Feed)feed, (String)cluster.getName());
        if (feedCluster != null) {
            Location dataLocation;
            CatalogTable table = FalconBridge.getTable(feedCluster, feed);
            if (table != null) {
                CatalogStorage storage = new CatalogStorage(cluster, table);
                return FalconBridge.createHiveTableInstance(cluster.getName(), storage.getDatabase().toLowerCase(), storage.getTable().toLowerCase());
            }
            List locations = FeedHelper.getLocations((org.apache.falcon.entity.v0.feed.Cluster)feedCluster, (Feed)feed);
            if (CollectionUtils.isNotEmpty((Collection)locations) && (dataLocation = FileSystemStorage.getLocation((List)locations, (LocationType)LocationType.DATA)) != null) {
                String pathUri = FalconBridge.normalize(dataLocation.getPath());
                LOG.info("Registering DFS Path {} ", (Object)pathUri);
                return FalconBridge.fillHDFSDataSet(pathUri, cluster.getName());
            }
        }
        return null;
    }

    private static CatalogTable getTable(org.apache.falcon.entity.v0.feed.Cluster cluster, Feed feed) {
        if (cluster.getTable() != null) {
            return cluster.getTable();
        }
        return feed.getTable();
    }

    private static List<Referenceable> fillHDFSDataSet(String pathUri, String clusterName) {
        ArrayList<Referenceable> entities = new ArrayList<Referenceable>();
        Referenceable ref = new Referenceable("hdfs_path", new String[0]);
        ref.set("path", (Object)pathUri);
        Path path = new Path(pathUri);
        ref.set("name", (Object)Path.getPathWithoutSchemeAndAuthority((Path)path).toString().toLowerCase());
        ref.set("qualifiedName", (Object)pathUri);
        ref.set("clusterName", (Object)clusterName);
        entities.add(ref);
        return entities;
    }

    private static Referenceable createHiveDatabaseInstance(String clusterName, String dbName) {
        Referenceable dbRef = new Referenceable(HiveDataTypes.HIVE_DB.getName(), new String[0]);
        dbRef.set("clusterName", (Object)clusterName);
        dbRef.set("name", (Object)dbName);
        dbRef.set("qualifiedName", (Object)HiveMetaStoreBridge.getDBQualifiedName((String)clusterName, (String)dbName));
        return dbRef;
    }

    private static List<Referenceable> createHiveTableInstance(String clusterName, String dbName, String tableName) {
        ArrayList<Referenceable> entities = new ArrayList<Referenceable>();
        Referenceable dbRef = FalconBridge.createHiveDatabaseInstance(clusterName, dbName);
        entities.add(dbRef);
        Referenceable tableRef = new Referenceable(HiveDataTypes.HIVE_TABLE.getName(), new String[0]);
        tableRef.set("qualifiedName", (Object)HiveMetaStoreBridge.getTableQualifiedName((String)clusterName, (String)dbName, (String)tableName));
        tableRef.set("name", (Object)tableName.toLowerCase());
        tableRef.set("db", (Object)dbRef);
        entities.add(tableRef);
        return entities;
    }

    private static Referenceable getClusterEntityReference(String clusterName, String colo) {
        LOG.info("Getting reference for entity {}", (Object)clusterName);
        Referenceable clusterRef = new Referenceable(FalconDataTypes.FALCON_CLUSTER.getName(), new String[0]);
        clusterRef.set("name", (Object)String.format("%s", clusterName));
        clusterRef.set("qualifiedName", (Object)clusterName);
        clusterRef.set(COLO, (Object)colo);
        return clusterRef;
    }

    private static Referenceable getFeedDataSetReference(Feed feed, Referenceable clusterReference) {
        LOG.info("Getting reference for entity {}", (Object)feed.getName());
        Referenceable feedDatasetRef = new Referenceable(FalconDataTypes.FALCON_FEED.getName(), new String[0]);
        feedDatasetRef.set("name", (Object)feed.getName());
        feedDatasetRef.set("qualifiedName", (Object)FalconBridge.getFeedQualifiedName(feed.getName(), (String)clusterReference.get("qualifiedName")));
        feedDatasetRef.set(STOREDIN, (Object)clusterReference);
        feedDatasetRef.set(FREQUENCY, (Object)feed.getFrequency());
        return feedDatasetRef;
    }

    private static Map<String, String> getProcessEntityWFProperties(Workflow workflow, String processName) {
        HashMap<String, String> wfProperties = new HashMap<String, String>();
        wfProperties.put(WorkflowExecutionArgs.USER_WORKFLOW_NAME.getName(), ProcessHelper.getProcessWorkflowName((String)workflow.getName(), (String)processName));
        wfProperties.put(WorkflowExecutionArgs.USER_WORKFLOW_VERSION.getName(), workflow.getVersion());
        wfProperties.put(WorkflowExecutionArgs.USER_WORKFLOW_ENGINE.getName(), workflow.getEngine().value());
        return wfProperties;
    }

    public static String getFeedQualifiedName(String feedName, String clusterName) {
        return String.format("%s@%s", feedName, clusterName);
    }

    public static String getProcessQualifiedName(String processName, String clusterName) {
        return String.format("%s@%s", processName, clusterName);
    }

    public static String normalize(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        return str.toLowerCase().trim();
    }
}

