/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.falcon.service;

import org.apache.atlas.plugin.classloader.AtlasPluginClassLoader;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.store.ConfigurationStore;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.service.ConfigurationChangeListener;
import org.apache.falcon.service.FalconService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasService
implements FalconService,
ConfigurationChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasService.class);
    private static final String ATLAS_PLUGIN_TYPE = "falcon";
    private static final String ATLAS_FALCON_HOOK_IMPL_CLASSNAME = "org.apache.atlas.falcon.service.AtlasService";
    private AtlasPluginClassLoader atlasPluginClassLoader = null;
    private FalconService falconServiceImpl = null;
    private ConfigurationChangeListener configChangeListenerImpl = null;

    public AtlasService() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasService.getName()");
        }
        String ret = null;
        try {
            this.activatePluginClassLoader();
            ret = this.falconServiceImpl.getName();
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasService.getName()");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws FalconException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasService.init()");
        }
        try {
            this.activatePluginClassLoader();
            ConfigurationStore.get().registerListener((ConfigurationChangeListener)this);
            this.falconServiceImpl.init();
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasService.init()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws FalconException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasService.destroy()");
        }
        try {
            this.activatePluginClassLoader();
            ConfigurationStore.get().unregisterListener((ConfigurationChangeListener)this);
            this.falconServiceImpl.destroy();
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasService.destroy()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAdd(Entity entity) throws FalconException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasService.onAdd(" + entity + ")");
        }
        try {
            this.activatePluginClassLoader();
            this.configChangeListenerImpl.onAdd(entity);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasService.onAdd(" + entity + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemove(Entity entity) throws FalconException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasService.onRemove(" + entity + ")");
        }
        try {
            this.activatePluginClassLoader();
            this.configChangeListenerImpl.onRemove(entity);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasService.onRemove(" + entity + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChange(Entity entity, Entity entity1) throws FalconException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasService.onChange(" + entity + ", " + entity1 + ")");
        }
        try {
            this.activatePluginClassLoader();
            this.configChangeListenerImpl.onChange(entity, entity1);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasService.onChange(" + entity + ", " + entity1 + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReload(Entity entity) throws FalconException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasService.onReload(" + entity + ")");
        }
        try {
            this.activatePluginClassLoader();
            this.configChangeListenerImpl.onReload(entity);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasService.onReload(" + entity + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasService.initialize()");
        }
        try {
            this.atlasPluginClassLoader = AtlasPluginClassLoader.getInstance((String)ATLAS_PLUGIN_TYPE, this.getClass());
            Class<?> cls = Class.forName(ATLAS_FALCON_HOOK_IMPL_CLASSNAME, true, (ClassLoader)this.atlasPluginClassLoader);
            this.activatePluginClassLoader();
            Object atlasService = cls.newInstance();
            this.falconServiceImpl = (FalconService)atlasService;
            this.configChangeListenerImpl = (ConfigurationChangeListener)atlasService;
        }
        catch (Exception excp) {
            LOG.error("Error instantiating Atlas hook implementation", (Throwable)excp);
        }
        finally {
            this.deactivatePluginClassLoader();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasService.initialize()");
        }
    }

    private void activatePluginClassLoader() {
        if (this.atlasPluginClassLoader != null) {
            this.atlasPluginClassLoader.activate();
        }
    }

    private void deactivatePluginClassLoader() {
        if (this.atlasPluginClassLoader != null) {
            this.atlasPluginClassLoader.deactivate();
        }
    }
}

