/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.atlas.ParamChecker;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Servlets {
    private static final Logger LOG = LoggerFactory.getLogger(Servlets.class);
    public static final String JSON_MEDIA_TYPE = "application/json; charset=UTF-8";

    private Servlets() {
    }

    public static String getUserFromRequest(HttpServletRequest httpRequest) {
        String user = httpRequest.getRemoteUser();
        if (!StringUtils.isEmpty((CharSequence)user)) {
            return user;
        }
        user = httpRequest.getParameter("user.name");
        if (!StringUtils.isEmpty((CharSequence)user)) {
            return user;
        }
        user = httpRequest.getHeader("Remote-User");
        if (!StringUtils.isEmpty((CharSequence)user)) {
            return user;
        }
        return null;
    }

    public static String getRequestURI(HttpServletRequest httpRequest) {
        StringBuilder url = new StringBuilder(100).append(httpRequest.getRequestURI());
        if (httpRequest.getQueryString() != null) {
            url.append('?').append(httpRequest.getQueryString());
        }
        return url.toString();
    }

    public static String getRequestURL(HttpServletRequest httpRequest) {
        StringBuilder url = new StringBuilder(100).append(httpRequest.getRequestURL());
        if (httpRequest.getQueryString() != null) {
            url.append('?').append(httpRequest.getQueryString());
        }
        return url.toString();
    }

    public static Response getErrorResponse(Throwable e, Response.Status status) {
        Response response = Servlets.getErrorResponse(e.getMessage(), status);
        JSONObject responseJson = (JSONObject)response.getEntity();
        try {
            responseJson.put("stackTrace", (Object)Servlets.printStackTrace(e));
        }
        catch (JSONException e1) {
            LOG.warn("Could not construct error Json rensponse", (Throwable)e1);
        }
        return response;
    }

    private static String printStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static Response getErrorResponse(String message, Response.Status status) {
        JSONObject errorJson = new JSONObject();
        String errorEntity = Servlets.escapeJsonString(message);
        try {
            errorJson.put("error", (Object)errorEntity);
            errorEntity = errorJson;
        }
        catch (JSONException jsonE) {
            LOG.warn("Could not construct error Json rensponse", (Throwable)jsonE);
        }
        return Response.status((Response.Status)status).entity((Object)errorEntity).type(JSON_MEDIA_TYPE).build();
    }

    public static String getRequestPayload(HttpServletRequest request) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)request.getInputStream(), (Writer)writer);
        return writer.toString();
    }

    public static String getRequestId() {
        return Thread.currentThread().getName();
    }

    public static String escapeJsonString(String inputStr) {
        ParamChecker.notNull((Object)inputStr, (String)"Input String cannot be null");
        return StringEscapeUtils.escapeJson((String)inputStr);
    }
}

