/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DateTimeHelper {
    public static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm'Z'";
    private static final String DATE_PATTERN = "(2\\d\\d\\d|19\\d\\d)-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])T([0-1][0-9]|2[0-3]):([0-5][0-9])Z";
    private static final Pattern PATTERN = Pattern.compile("(2\\d\\d\\d|19\\d\\d)-(0[1-9]|1[012])-(0[1-9]|1[0-9]|2[0-9]|3[01])T([0-1][0-9]|2[0-3]):([0-5][0-9])Z");

    private DateTimeHelper() {
    }

    public static String getTimeZoneId(TimeZone tz) {
        return tz.getID();
    }

    public static DateFormat getDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(ISO8601_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat;
    }

    public static String formatDateUTC(Date date) {
        return date != null ? DateTimeHelper.getDateFormat().format(date) : null;
    }

    public static Date parseDateUTC(String dateStr) {
        if (!DateTimeHelper.validate(dateStr)) {
            throw new IllegalArgumentException(dateStr + " is not a valid UTC string");
        }
        try {
            return DateTimeHelper.getDateFormat().parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatDateUTCToISO8601(String dateString, String dateStringFormat) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(dateStringFormat.substring(0, dateString.length()));
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return DateTimeHelper.formatDateUTC(dateFormat.parse(dateString));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean validate(String date) {
        Matcher matcher = PATTERN.matcher(date);
        if (matcher.matches()) {
            matcher.reset();
            if (matcher.find()) {
                int year = Integer.parseInt(matcher.group(1));
                String month = matcher.group(2);
                String day = matcher.group(3);
                if (day.equals("31") && (month.equals("4") || month.equals("6") || month.equals("9") || month.equals("11") || month.equals("04") || month.equals("06") || month.equals("09"))) {
                    return false;
                }
                if (month.equals("2") || month.equals("02")) {
                    if (year % 4 == 0) {
                        return !day.equals("30") && !day.equals("31");
                    }
                    return !day.equals("29") && !day.equals("30") && !day.equals("31");
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

