/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.service;

import java.io.IOException;
import org.apache.atlas.web.service.EmbeddedServer;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureEmbeddedServer
extends EmbeddedServer {
    private static final Logger LOG = LoggerFactory.getLogger(SecureEmbeddedServer.class);

    public SecureEmbeddedServer(int port, String path) throws IOException {
        super(port, path);
    }

    @Override
    protected Connector getConnector(int port) throws IOException {
        PropertiesConfiguration config = this.getConfiguration();
        SslSocketConnector connector = new SslSocketConnector();
        connector.setPort(port);
        connector.setHost("0.0.0.0");
        connector.setKeystore(config.getString("keystore.file", System.getProperty("keystore.file", "target/atlas.keystore")));
        connector.setKeyPassword(this.getPassword(config, "password"));
        connector.setTruststore(config.getString("truststore.file", System.getProperty("truststore.file", "target/atlas.keystore")));
        connector.setTrustPassword(this.getPassword(config, "truststore.password"));
        connector.setPassword(this.getPassword(config, "keystore.password"));
        connector.setWantClientAuth(config.getBoolean("client.auth.enabled", Boolean.getBoolean("client.auth.enabled")));
        return connector;
    }

    private String getPassword(PropertiesConfiguration config, String key) throws IOException {
        CredentialProvider.CredentialEntry entry;
        String provider = config.getString("cert.stores.credential.provider.path");
        if (provider != null) {
            LOG.info("Attempting to retrieve password from configured credential provider path");
            Configuration c = new Configuration();
            c.set("hadoop.security.credential.provider.path", provider);
            CredentialProvider credentialProvider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)c).get(0);
            entry = credentialProvider.getCredentialEntry(key);
            if (entry == null) {
                throw new IOException(String.format("No credential entry found for %s. Please create an entry in the configured credential provider", key));
            }
        } else {
            throw new IOException("No credential provider path configured for storage of certificate store passwords");
        }
        String password = String.valueOf(entry.getCredential());
        return password;
    }

    protected PropertiesConfiguration getConfiguration() {
        try {
            return new PropertiesConfiguration("application.properties");
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Unable to load configuration: application.properties");
        }
    }
}

