/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.service;

import java.io.IOException;
import org.apache.atlas.web.service.SecureEmbeddedServer;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.webapp.WebAppContext;

public class EmbeddedServer {
    private static final int DEFAULT_BUFFER_SIZE = 16192;
    protected final Server server = new Server();

    public EmbeddedServer(int port, String path) throws IOException {
        Connector connector = this.getConnector(port);
        this.server.addConnector(connector);
        WebAppContext application = new WebAppContext(path, "/");
        this.server.setHandler((Handler)application);
    }

    public static EmbeddedServer newServer(int port, String path, boolean secure) throws IOException {
        if (secure) {
            return new SecureEmbeddedServer(port, path);
        }
        return new EmbeddedServer(port, path);
    }

    protected Connector getConnector(int port) throws IOException {
        SocketConnector connector = new SocketConnector();
        connector.setPort(port);
        connector.setHost("0.0.0.0");
        Integer bufferSize = this.getBufferSize();
        connector.setHeaderBufferSize(bufferSize.intValue());
        connector.setRequestBufferSize(bufferSize.intValue());
        return connector;
    }

    private Integer getBufferSize() {
        try {
            PropertiesConfiguration configuration = new PropertiesConfiguration("application.properties");
            return configuration.getInt("atlas.jetty.request.buffer.size", 16192);
        }
        catch (ConfigurationException configurationException) {
            return 16192;
        }
    }

    public void start() throws Exception {
        this.server.start();
        this.server.join();
    }

    public void stop() throws Exception {
        this.server.stop();
    }
}

