/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.resources;

import com.sun.jersey.api.client.ClientResponse;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.atlas.AtlasException;
import org.apache.atlas.services.MetadataService;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.web.resources.EntityResource;
import org.apache.atlas.web.util.Servlets;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="types")
@Singleton
public class TypesResource {
    private static final Logger LOG = LoggerFactory.getLogger(EntityResource.class);
    private final MetadataService metadataService;
    static final String TYPE_ALL = "all";

    @Inject
    public TypesResource(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    @POST
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response submit(@Context HttpServletRequest request) {
        try {
            String typeDefinition = Servlets.getRequestPayload(request);
            LOG.debug("Creating type with definition {} ", (Object)typeDefinition);
            JSONObject typesJson = this.metadataService.createType(typeDefinition);
            JSONArray typesJsonArray = typesJson.getJSONArray("types");
            JSONArray typesResponse = new JSONArray();
            for (int i = 0; i < typesJsonArray.length(); ++i) {
                final String name = typesJsonArray.getString(i);
                typesResponse.put((Object)new JSONObject(){
                    {
                        this.put("name", name);
                    }
                });
            }
            JSONObject response = new JSONObject();
            response.put("requestId", (Object)Servlets.getRequestId());
            response.put("types", (Object)typesResponse);
            return Response.status((Response.StatusType)ClientResponse.Status.CREATED).entity((Object)response).build();
        }
        catch (IllegalArgumentException | AtlasException e) {
            LOG.error("Unable to persist types", e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to persist types", e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @GET
    @Path(value="{typeName}")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getDefinition(@Context HttpServletRequest request, @PathParam(value="typeName") String typeName) {
        try {
            String typeDefinition = this.metadataService.getTypeDefinition(typeName);
            JSONObject response = new JSONObject();
            response.put("typeName", (Object)typeName);
            response.put("definition", (Object)typeDefinition);
            response.put("requestId", (Object)Servlets.getRequestId());
            return Response.ok((Object)response).build();
        }
        catch (AtlasException e) {
            LOG.error("Unable to get type definition for type {}", (Object)typeName, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.NOT_FOUND));
        }
        catch (IllegalArgumentException | JSONException e) {
            LOG.error("Unable to get type definition for type {}", (Object)typeName, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to get type definition for type {}", (Object)typeName, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @GET
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getTypesByFilter(@Context HttpServletRequest request, @DefaultValue(value="all") @QueryParam(value="type") String type) {
        try {
            List result;
            if (TYPE_ALL.equals(type)) {
                result = this.metadataService.getTypeNamesList();
            } else {
                DataTypes.TypeCategory typeCategory = DataTypes.TypeCategory.valueOf((String)type);
                result = this.metadataService.getTypeNamesByCategory(typeCategory);
            }
            JSONObject response = new JSONObject();
            response.put("results", (Object)new JSONArray((Collection)result));
            response.put("count", result.size());
            response.put("requestId", (Object)Servlets.getRequestId());
            return Response.ok((Object)response).build();
        }
        catch (IllegalArgumentException | AtlasException ie) {
            LOG.error("Unsupported typeName while retrieving type list {}", (Object)type);
            throw new WebApplicationException(Servlets.getErrorResponse("Unsupported type " + type, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to get types list", e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }
}

