/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.resources;

import com.thinkaurelius.titan.core.TitanGraph;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.VertexQuery;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONUtility;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.atlas.repository.graph.GraphProvider;
import org.apache.atlas.web.util.Servlets;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="graph")
@Singleton
public class RexsterGraphResource {
    public static final String OUT_E = "outE";
    public static final String IN_E = "inE";
    public static final String BOTH_E = "bothE";
    public static final String OUT = "out";
    public static final String IN = "in";
    public static final String BOTH = "both";
    public static final String OUT_COUNT = "outCount";
    public static final String IN_COUNT = "inCount";
    public static final String BOTH_COUNT = "bothCount";
    public static final String OUT_IDS = "outIds";
    public static final String IN_IDS = "inIds";
    public static final String BOTH_IDS = "bothIds";
    private static final Logger LOG = LoggerFactory.getLogger(RexsterGraphResource.class);
    private TitanGraph graph;

    @Inject
    public RexsterGraphResource(GraphProvider<TitanGraph> graphProvider) {
        this.graph = (TitanGraph)graphProvider.get();
    }

    private static void validateInputs(String errorMsg, String ... inputs) {
        for (String input : inputs) {
            if (!StringUtils.isEmpty((String)input)) continue;
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMsg).type("text/plain").build());
        }
    }

    protected Graph getGraph() {
        return this.graph;
    }

    protected Set<String> getVertexIndexedKeys() {
        return this.graph.getIndexedKeys(Vertex.class);
    }

    protected Set<String> getEdgeIndexedKeys() {
        return this.graph.getIndexedKeys(Edge.class);
    }

    @GET
    @Path(value="/vertices/{id}")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getVertex(@PathParam(value="id") String vertexId) {
        LOG.info("Get vertex for vertexId= {}", (Object)vertexId);
        RexsterGraphResource.validateInputs("Invalid argument: vertex id passed is null or empty.", vertexId);
        try {
            Vertex vertex = this.findVertex(vertexId);
            JSONObject response = new JSONObject();
            response.put("results", (Object)GraphSONUtility.jsonFromElement((Element)vertex, this.getVertexIndexedKeys(), (GraphSONMode)GraphSONMode.NORMAL));
            return Response.ok((Object)response).build();
        }
        catch (JSONException e) {
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private Vertex findVertex(String vertexId) {
        Vertex vertex = this.getGraph().getVertex((Object)vertexId);
        if (vertex == null) {
            String message = "Vertex with [" + vertexId + "] cannot be found.";
            LOG.info(message);
            throw new WebApplicationException(Servlets.getErrorResponse(message, Response.Status.NOT_FOUND));
        }
        return vertex;
    }

    @GET
    @Path(value="/vertices/properties/{id}")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getVertexProperties(@PathParam(value="id") String vertexId, @DefaultValue(value="false") @QueryParam(value="relationships") String relationships) {
        LOG.info("Get vertex for vertexId= {}", (Object)vertexId);
        RexsterGraphResource.validateInputs("Invalid argument: vertex id passed is null or empty.", vertexId);
        try {
            Vertex vertex = this.findVertex(vertexId);
            Map<String, String> vertexProperties = this.getVertexProperties(vertex);
            JSONObject response = new JSONObject();
            response.put("results", (Object)new JSONObject(vertexProperties));
            response.put("count", vertexProperties.size());
            return Response.ok((Object)response).build();
        }
        catch (JSONException e) {
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private Map<String, String> getVertexProperties(Vertex vertex) {
        HashMap<String, String> vertexProperties = new HashMap<String, String>();
        for (String key : vertex.getPropertyKeys()) {
            vertexProperties.put(key, (String)vertex.getProperty(key));
        }
        return vertexProperties;
    }

    @GET
    @Path(value="/vertices")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getVertices(@QueryParam(value="key") String key, @QueryParam(value="value") String value) {
        LOG.info("Get vertices for property key= {}, value= {}", (Object)key, (Object)value);
        RexsterGraphResource.validateInputs("Invalid argument: key or value passed is null or empty.", key, value);
        try {
            JSONObject response = this.buildJSONResponse(this.getGraph().getVertices(key, (Object)value));
            return Response.ok((Object)response).build();
        }
        catch (JSONException e) {
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @GET
    @Path(value="vertices/{id}/{direction}")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getVertexEdges(@PathParam(value="id") String vertexId, @PathParam(value="direction") String direction) {
        LOG.info("Get vertex edges for vertexId= {}, direction= {}", (Object)vertexId, (Object)direction);
        RexsterGraphResource.validateInputs("Invalid argument: vertex id or direction passed is null or empty.", vertexId, direction);
        try {
            Vertex vertex = this.findVertex(vertexId);
            return this.getVertexEdges(vertex, direction);
        }
        catch (JSONException e) {
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private Response getVertexEdges(Vertex vertex, String direction) throws JSONException {
        VertexQueryArguments queryArguments = new VertexQueryArguments(direction);
        boolean countOnly = queryArguments.isCountOnly();
        ReturnType returnType = queryArguments.getReturnType();
        Direction queryDirection = queryArguments.getQueryDirection();
        VertexQuery query = vertex.query().direction(queryDirection);
        JSONArray elementArray = new JSONArray();
        long counter = 0L;
        if (returnType == ReturnType.VERTICES || returnType == ReturnType.VERTEX_IDS) {
            Iterable vertexQueryResults = query.vertices();
            for (Vertex v : vertexQueryResults) {
                if (returnType.equals((Object)ReturnType.VERTICES)) {
                    elementArray.put((Object)GraphSONUtility.jsonFromElement((Element)v, this.getVertexIndexedKeys(), (GraphSONMode)GraphSONMode.NORMAL));
                } else {
                    elementArray.put(v.getId());
                }
                ++counter;
            }
        } else if (returnType == ReturnType.EDGES) {
            Iterable edgeQueryResults = query.edges();
            for (Edge e : edgeQueryResults) {
                elementArray.put((Object)GraphSONUtility.jsonFromElement((Element)e, this.getEdgeIndexedKeys(), (GraphSONMode)GraphSONMode.NORMAL));
                ++counter;
            }
        } else if (returnType == ReturnType.COUNT) {
            counter = query.count();
        }
        JSONObject response = new JSONObject();
        if (!countOnly) {
            response.put("results", (Object)elementArray);
        }
        response.put("count", counter);
        return Response.ok((Object)response).build();
    }

    @GET
    @Path(value="/edges/{id}")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getEdge(@PathParam(value="id") String edgeId) {
        LOG.info("Get vertex for edgeId= {}", (Object)edgeId);
        RexsterGraphResource.validateInputs("Invalid argument: edge id passed is null or empty.", edgeId);
        try {
            Edge edge = this.getGraph().getEdge((Object)edgeId);
            if (edge == null) {
                String message = "Edge with [" + edgeId + "] cannot be found.";
                LOG.info(message);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)Servlets.escapeJsonString(message)).build());
            }
            JSONObject response = new JSONObject();
            response.put("results", (Object)GraphSONUtility.jsonFromElement((Element)edge, this.getEdgeIndexedKeys(), (GraphSONMode)GraphSONMode.NORMAL));
            return Response.ok((Object)response).build();
        }
        catch (JSONException e) {
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private <T extends Element> JSONObject buildJSONResponse(Iterable<T> elements) throws JSONException {
        JSONArray vertexArray = new JSONArray();
        long counter = 0L;
        for (Element element : elements) {
            ++counter;
            vertexArray.put((Object)GraphSONUtility.jsonFromElement((Element)element, this.getVertexIndexedKeys(), (GraphSONMode)GraphSONMode.NORMAL));
        }
        JSONObject response = new JSONObject();
        response.put("results", (Object)vertexArray);
        response.put("count", counter);
        return response;
    }

    public static final class VertexQueryArguments {
        private final Direction queryDirection;
        private final ReturnType returnType;
        private final boolean countOnly;

        public VertexQueryArguments(String directionSegment) {
            if (RexsterGraphResource.OUT_E.equals(directionSegment)) {
                this.returnType = ReturnType.EDGES;
                this.queryDirection = Direction.OUT;
                this.countOnly = false;
            } else if (RexsterGraphResource.IN_E.equals(directionSegment)) {
                this.returnType = ReturnType.EDGES;
                this.queryDirection = Direction.IN;
                this.countOnly = false;
            } else if (RexsterGraphResource.BOTH_E.equals(directionSegment)) {
                this.returnType = ReturnType.EDGES;
                this.queryDirection = Direction.BOTH;
                this.countOnly = false;
            } else if (RexsterGraphResource.OUT.equals(directionSegment)) {
                this.returnType = ReturnType.VERTICES;
                this.queryDirection = Direction.OUT;
                this.countOnly = false;
            } else if (RexsterGraphResource.IN.equals(directionSegment)) {
                this.returnType = ReturnType.VERTICES;
                this.queryDirection = Direction.IN;
                this.countOnly = false;
            } else if (RexsterGraphResource.BOTH.equals(directionSegment)) {
                this.returnType = ReturnType.VERTICES;
                this.queryDirection = Direction.BOTH;
                this.countOnly = false;
            } else if (RexsterGraphResource.BOTH_COUNT.equals(directionSegment)) {
                this.returnType = ReturnType.COUNT;
                this.queryDirection = Direction.BOTH;
                this.countOnly = true;
            } else if (RexsterGraphResource.IN_COUNT.equals(directionSegment)) {
                this.returnType = ReturnType.COUNT;
                this.queryDirection = Direction.IN;
                this.countOnly = true;
            } else if (RexsterGraphResource.OUT_COUNT.equals(directionSegment)) {
                this.returnType = ReturnType.COUNT;
                this.queryDirection = Direction.OUT;
                this.countOnly = true;
            } else if (RexsterGraphResource.BOTH_IDS.equals(directionSegment)) {
                this.returnType = ReturnType.VERTEX_IDS;
                this.queryDirection = Direction.BOTH;
                this.countOnly = false;
            } else if (RexsterGraphResource.IN_IDS.equals(directionSegment)) {
                this.returnType = ReturnType.VERTEX_IDS;
                this.queryDirection = Direction.IN;
                this.countOnly = false;
            } else if (RexsterGraphResource.OUT_IDS.equals(directionSegment)) {
                this.returnType = ReturnType.VERTEX_IDS;
                this.queryDirection = Direction.OUT;
                this.countOnly = false;
            } else {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Servlets.escapeJsonString(directionSegment + " segment was invalid.")).build());
            }
        }

        public Direction getQueryDirection() {
            return this.queryDirection;
        }

        public ReturnType getReturnType() {
            return this.returnType;
        }

        public boolean isCountOnly() {
            return this.countOnly;
        }
    }

    private static enum ReturnType {
        VERTICES,
        EDGES,
        COUNT,
        VERTEX_IDS;

    }
}

