/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.resources;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.atlas.ParamChecker;
import org.apache.atlas.discovery.DiscoveryException;
import org.apache.atlas.discovery.DiscoveryService;
import org.apache.atlas.web.resources.EntityResource;
import org.apache.atlas.web.util.Servlets;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="discovery")
@Singleton
public class MetadataDiscoveryResource {
    private static final Logger LOG = LoggerFactory.getLogger(EntityResource.class);
    private static final String QUERY_TYPE_DSL = "dsl";
    private static final String QUERY_TYPE_GREMLIN = "gremlin";
    private static final String QUERY_TYPE_FULLTEXT = "full-text";
    private final DiscoveryService discoveryService;

    @Inject
    public MetadataDiscoveryResource(DiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    @GET
    @Path(value="search")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response search(@QueryParam(value="query") String query) {
        JSONObject response;
        try {
            ParamChecker.notEmpty((String)query, (String)"query cannot be null");
            if (query.startsWith("g.")) {
                return this.searchUsingGremlinQuery(query);
            }
            String jsonResultStr = this.discoveryService.searchByDSL(query);
            response = new DSLJSONResponseBuilder().results(jsonResultStr).query(query).build();
        }
        catch (IllegalArgumentException e) {
            LOG.error("Unable to get entity list for empty query", (Throwable)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable throwable) {
            LOG.error("Unable to get entity list for query {} using dsl", (Object)query, (Object)throwable);
            try {
                String jsonResultStr = this.discoveryService.searchByFullText(query);
                response = new FullTextJSonResponseBuilder().results(jsonResultStr).query(query).build();
            }
            catch (IllegalArgumentException | DiscoveryException e) {
                LOG.error("Unable to get entity list for query {}", (Object)query, (Object)e);
                throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
            }
            catch (Throwable e) {
                LOG.error("Unable to get entity list for query {}", (Object)query, (Object)e);
                throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
            }
        }
        return Response.ok((Object)response).build();
    }

    @GET
    @Path(value="search/dsl")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response searchUsingQueryDSL(@QueryParam(value="query") String dslQuery) {
        try {
            ParamChecker.notEmpty((String)dslQuery, (String)"dslQuery cannot be null");
            String jsonResultStr = this.discoveryService.searchByDSL(dslQuery);
            JSONObject response = new DSLJSONResponseBuilder().results(jsonResultStr).query(dslQuery).build();
            return Response.ok((Object)response).build();
        }
        catch (IllegalArgumentException | DiscoveryException e) {
            LOG.error("Unable to get entity list for dslQuery {}", (Object)dslQuery, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to get entity list for dslQuery {}", (Object)dslQuery, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @GET
    @Path(value="search/gremlin")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response searchUsingGremlinQuery(@QueryParam(value="query") String gremlinQuery) {
        try {
            ParamChecker.notEmpty((String)gremlinQuery, (String)"gremlinQuery cannot be null or empty");
            List results = this.discoveryService.searchByGremlin(gremlinQuery);
            JSONObject response = new JSONObject();
            response.put("requestId", (Object)Servlets.getRequestId());
            response.put("query", (Object)gremlinQuery);
            response.put("queryType", (Object)QUERY_TYPE_GREMLIN);
            JSONArray list = new JSONArray();
            for (Map result : results) {
                list.put((Object)new JSONObject(result));
            }
            response.put("results", (Object)list);
            response.put("count", list.length());
            return Response.ok((Object)response).build();
        }
        catch (IllegalArgumentException | DiscoveryException e) {
            LOG.error("Unable to get entity list for gremlinQuery {}", (Object)gremlinQuery, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to get entity list for gremlinQuery {}", (Object)gremlinQuery, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @GET
    @Path(value="search/fulltext")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response searchUsingFullText(@QueryParam(value="query") String query) {
        try {
            ParamChecker.notEmpty((String)query, (String)"query cannot be null or empty");
            String jsonResultStr = this.discoveryService.searchByFullText(query);
            JSONArray rowsJsonArr = new JSONArray(jsonResultStr);
            JSONObject response = new FullTextJSonResponseBuilder().results(rowsJsonArr).query(query).build();
            return Response.ok((Object)response).build();
        }
        catch (IllegalArgumentException | DiscoveryException e) {
            LOG.error("Unable to get entity list for query {}", (Object)query, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to get entity list for query {}", (Object)query, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    private class FullTextJSonResponseBuilder
    extends JsonResponseBuilder {
        private JSONArray fullTextResults;

        public FullTextJSonResponseBuilder results(JSONArray fullTextResults) {
            this.fullTextResults = fullTextResults;
            return this;
        }

        public FullTextJSonResponseBuilder results(String dslResults) throws JSONException {
            return this.results(new JSONArray(dslResults));
        }

        @Override
        public JSONObject build() throws JSONException {
            Preconditions.checkNotNull((Object)this.fullTextResults);
            this.count(this.fullTextResults.length());
            this.queryType(MetadataDiscoveryResource.QUERY_TYPE_FULLTEXT);
            JSONObject response = super.build();
            response.put("results", (Object)this.fullTextResults);
            return response;
        }
    }

    private class DSLJSONResponseBuilder
    extends JsonResponseBuilder {
        private JSONObject dslResults;

        DSLJSONResponseBuilder() {
        }

        public DSLJSONResponseBuilder results(JSONObject dslResults) {
            this.dslResults = dslResults;
            return this;
        }

        public DSLJSONResponseBuilder results(String dslResults) throws JSONException {
            return this.results(new JSONObject(dslResults));
        }

        @Override
        public JSONObject build() throws JSONException {
            Preconditions.checkNotNull((Object)this.dslResults);
            JSONArray rowsJsonArr = this.dslResults.getJSONArray("rows");
            this.count(rowsJsonArr.length());
            this.queryType(MetadataDiscoveryResource.QUERY_TYPE_DSL);
            JSONObject response = super.build();
            response.put("results", (Object)this.dslResults);
            return response;
        }
    }

    private class JsonResponseBuilder {
        protected int count = 0;
        protected String query;
        protected String queryType;
        protected JSONObject response = new JSONObject();

        JsonResponseBuilder() {
        }

        protected JsonResponseBuilder count(int count) {
            this.count = count;
            return this;
        }

        public JsonResponseBuilder query(String query) {
            this.query = query;
            return this;
        }

        public JsonResponseBuilder queryType(String queryType) {
            this.queryType = queryType;
            return this;
        }

        protected JSONObject build() throws JSONException {
            Preconditions.checkNotNull((Object)this.query, (Object)"Query cannot be null");
            Preconditions.checkNotNull((Object)this.queryType, (Object)"Query Type must be specified");
            Preconditions.checkArgument((this.count >= 0 ? 1 : 0) != 0, (Object)"Search Result count should be > 0");
            this.response.put("requestId", (Object)Servlets.getRequestId());
            this.response.put("query", (Object)this.query);
            this.response.put("queryType", (Object)this.queryType);
            this.response.put("count", this.count);
            return this.response;
        }
    }
}

