/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.resources;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.atlas.ParamChecker;
import org.apache.atlas.discovery.DiscoveryException;
import org.apache.atlas.discovery.LineageService;
import org.apache.atlas.repository.EntityNotFoundException;
import org.apache.atlas.web.util.Servlets;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="lineage/hive")
@Singleton
public class HiveLineageResource {
    private static final Logger LOG = LoggerFactory.getLogger(HiveLineageResource.class);
    private final LineageService lineageService;

    @Inject
    public HiveLineageResource(LineageService lineageService) {
        this.lineageService = lineageService;
    }

    @GET
    @Path(value="table/{tableName}/inputs/graph")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response inputsGraph(@Context HttpServletRequest request, @PathParam(value="tableName") String tableName) {
        LOG.info("Fetching lineage inputs graph for tableName={}", (Object)tableName);
        try {
            ParamChecker.notEmpty((String)tableName, (String)"table name cannot be null");
            String jsonResult = this.lineageService.getInputsGraph(tableName);
            JSONObject response = new JSONObject();
            response.put("requestId", (Object)Servlets.getRequestId());
            response.put("tableName", (Object)tableName);
            response.put("results", (Object)new JSONObject(jsonResult));
            return Response.ok((Object)response).build();
        }
        catch (EntityNotFoundException e) {
            LOG.error("table entity not found for {}", (Object)tableName, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.NOT_FOUND));
        }
        catch (IllegalArgumentException | DiscoveryException e) {
            LOG.error("Unable to get lineage inputs graph for table {}", (Object)tableName, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to get lineage inputs graph for table {}", (Object)tableName, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @GET
    @Path(value="table/{tableName}/outputs/graph")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response outputsGraph(@Context HttpServletRequest request, @PathParam(value="tableName") String tableName) {
        LOG.info("Fetching lineage outputs graph for tableName={}", (Object)tableName);
        try {
            ParamChecker.notEmpty((String)tableName, (String)"table name cannot be null");
            String jsonResult = this.lineageService.getOutputsGraph(tableName);
            JSONObject response = new JSONObject();
            response.put("requestId", (Object)Servlets.getRequestId());
            response.put("tableName", (Object)tableName);
            response.put("results", (Object)new JSONObject(jsonResult));
            return Response.ok((Object)response).build();
        }
        catch (EntityNotFoundException e) {
            LOG.error("table entity not found for {}", (Object)tableName, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.NOT_FOUND));
        }
        catch (IllegalArgumentException | DiscoveryException e) {
            LOG.error("Unable to get lineage outputs graph for table {}", (Object)tableName, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to get lineage outputs graph for table {}", (Object)tableName, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @GET
    @Path(value="table/{tableName}/schema")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response schema(@Context HttpServletRequest request, @PathParam(value="tableName") String tableName) {
        LOG.info("Fetching schema for tableName={}", (Object)tableName);
        try {
            ParamChecker.notEmpty((String)tableName, (String)"table name cannot be null");
            String jsonResult = this.lineageService.getSchema(tableName);
            JSONObject response = new JSONObject();
            response.put("requestId", (Object)Servlets.getRequestId());
            response.put("tableName", (Object)tableName);
            response.put("results", (Object)new JSONObject(jsonResult));
            return Response.ok((Object)response).build();
        }
        catch (EntityNotFoundException e) {
            LOG.error("table entity not found for {}", (Object)tableName, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.NOT_FOUND));
        }
        catch (IllegalArgumentException | DiscoveryException e) {
            LOG.error("Unable to get schema for table {}", (Object)tableName, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to get schema for table {}", (Object)tableName, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }
}

