/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.resources;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.atlas.AtlasException;
import org.apache.atlas.ParamChecker;
import org.apache.atlas.TypeNotFoundException;
import org.apache.atlas.repository.EntityNotFoundException;
import org.apache.atlas.services.MetadataService;
import org.apache.atlas.typesystem.types.ValueConversionException;
import org.apache.atlas.web.util.Servlets;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="entities")
@Singleton
public class EntityResource {
    private static final Logger LOG = LoggerFactory.getLogger(EntityResource.class);
    private static final String TRAIT_NAME = "traitName";
    private final MetadataService metadataService;
    @Context
    UriInfo uriInfo;

    @Inject
    public EntityResource(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    @POST
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response submit(@Context HttpServletRequest request) {
        try {
            String entity = Servlets.getRequestPayload(request);
            LOG.debug("submitting entity {} ", (Object)entity);
            String guid = this.metadataService.createEntity(entity);
            UriBuilder ub = this.uriInfo.getAbsolutePathBuilder();
            URI locationURI = ub.path(guid).build(new Object[0]);
            JSONObject response = new JSONObject();
            response.put("requestId", (Object)Servlets.getRequestId());
            response.put("GUID", (Object)guid);
            response.put("definition", (Object)this.metadataService.getEntityDefinition(guid));
            return Response.created((URI)locationURI).entity((Object)response).build();
        }
        catch (ValueConversionException ve) {
            LOG.error("Unable to persist entity instance due to a desrialization error ", (Throwable)ve);
            throw new WebApplicationException(Servlets.getErrorResponse(ve.getCause(), Response.Status.BAD_REQUEST));
        }
        catch (IllegalArgumentException | AtlasException e) {
            LOG.error("Unable to persist entity instance", e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to persist entity instance", e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @GET
    @Path(value="{guid}")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getEntityDefinition(@PathParam(value="guid") String guid) {
        try {
            LOG.debug("Fetching entity definition for guid={} ", (Object)guid);
            ParamChecker.notEmpty((String)guid, (String)"guid cannot be null");
            String entityDefinition = this.metadataService.getEntityDefinition(guid);
            JSONObject response = new JSONObject();
            response.put("requestId", (Object)Servlets.getRequestId());
            response.put("GUID", (Object)guid);
            Response.Status status = Response.Status.NOT_FOUND;
            if (entityDefinition != null) {
                response.put("definition", (Object)entityDefinition);
                status = Response.Status.OK;
            } else {
                response.put("error", (Object)Servlets.escapeJsonString(String.format("An entity with GUID={%s} does not exist", guid)));
            }
            return Response.status((Response.Status)status).entity((Object)response).build();
        }
        catch (EntityNotFoundException e) {
            LOG.error("An entity with GUID={} does not exist", (Object)guid, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.NOT_FOUND));
        }
        catch (IllegalArgumentException | AtlasException e) {
            LOG.error("Bad GUID={}", (Object)guid, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to get instance definition for GUID {}", (Object)guid, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @GET
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getEntityListByType(@QueryParam(value="type") String entityType) {
        try {
            Preconditions.checkNotNull((Object)entityType, (Object)"Entity type cannot be null");
            LOG.debug("Fetching entity list for type={} ", (Object)entityType);
            List entityList = this.metadataService.getEntityList(entityType);
            JSONObject response = new JSONObject();
            response.put("requestId", (Object)Servlets.getRequestId());
            response.put("typeName", (Object)entityType);
            response.put("results", (Object)new JSONArray((Collection)entityList));
            response.put("count", entityList.size());
            return Response.ok((Object)response).build();
        }
        catch (NullPointerException e) {
            LOG.error("Entity type cannot be null", (Throwable)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (IllegalArgumentException | AtlasException e) {
            LOG.error("Unable to get entity list for type {}", (Object)entityType, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to get entity list for type {}", (Object)entityType, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @PUT
    @Path(value="{guid}")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response update(@PathParam(value="guid") String guid, @QueryParam(value="property") String property, @QueryParam(value="value") String value) {
        try {
            Preconditions.checkNotNull((Object)property, (Object)"Entity property cannot be null");
            Preconditions.checkNotNull((Object)value, (Object)"Entity value cannot be null");
            this.metadataService.updateEntity(guid, property, value);
            JSONObject response = new JSONObject();
            response.put("requestId", (Object)Thread.currentThread().getName());
            return Response.ok((Object)response).build();
        }
        catch (EntityNotFoundException e) {
            LOG.error("An entity with GUID={} does not exist", (Object)guid, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.NOT_FOUND));
        }
        catch (IllegalArgumentException | AtlasException e) {
            LOG.error("Unable to add property {} to entity id {}", new Object[]{property, guid, e});
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to add property {} to entity id {}", new Object[]{property, guid, e});
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @GET
    @Path(value="{guid}/traits")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getTraitNames(@PathParam(value="guid") String guid) {
        try {
            LOG.debug("Fetching trait names for entity={}", (Object)guid);
            List traitNames = this.metadataService.getTraitNames(guid);
            JSONObject response = new JSONObject();
            response.put("requestId", (Object)Servlets.getRequestId());
            response.put("GUID", (Object)guid);
            response.put("results", (Object)new JSONArray((Collection)traitNames));
            response.put("count", traitNames.size());
            return Response.ok((Object)response).build();
        }
        catch (EntityNotFoundException e) {
            LOG.error("An entity with GUID={} does not exist", (Object)guid, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.NOT_FOUND));
        }
        catch (IllegalArgumentException | AtlasException e) {
            LOG.error("Unable to get trait names for entity {}", (Object)guid, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to get trait names for entity {}", (Object)guid, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @POST
    @Path(value="{guid}/traits")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response addTrait(@Context HttpServletRequest request, @PathParam(value="guid") String guid) {
        try {
            String traitDefinition = Servlets.getRequestPayload(request);
            LOG.debug("Adding trait={} for entity={} ", (Object)traitDefinition, (Object)guid);
            this.metadataService.addTrait(guid, traitDefinition);
            UriBuilder ub = this.uriInfo.getAbsolutePathBuilder();
            URI locationURI = ub.path(guid).build(new Object[0]);
            JSONObject response = new JSONObject();
            response.put("requestId", (Object)Servlets.getRequestId());
            response.put("GUID", (Object)guid);
            return Response.created((URI)locationURI).entity((Object)response).build();
        }
        catch (TypeNotFoundException | EntityNotFoundException e) {
            LOG.error("An entity with GUID={} does not exist", (Object)guid, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.NOT_FOUND));
        }
        catch (IllegalArgumentException | AtlasException e) {
            LOG.error("Unable to add trait for entity={}", (Object)guid, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to add trait for entity={}", (Object)guid, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }

    @DELETE
    @Path(value="{guid}/traits/{traitName}")
    @Consumes(value={"application/json; charset=UTF-8"})
    @Produces(value={"application/json; charset=UTF-8"})
    public Response deleteTrait(@Context HttpServletRequest request, @PathParam(value="guid") String guid, @PathParam(value="traitName") String traitName) {
        LOG.debug("Deleting trait={} from entity={} ", (Object)traitName, (Object)guid);
        try {
            this.metadataService.deleteTrait(guid, traitName);
            JSONObject response = new JSONObject();
            response.put("requestId", (Object)Servlets.getRequestId());
            response.put("GUID", (Object)guid);
            response.put(TRAIT_NAME, (Object)traitName);
            return Response.ok((Object)response).build();
        }
        catch (TypeNotFoundException | EntityNotFoundException e) {
            LOG.error("An entity with GUID={} does not exist", (Object)guid, (Object)e);
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.NOT_FOUND));
        }
        catch (IllegalArgumentException | AtlasException e) {
            LOG.error("Unable to delete trait name={} for entity={}", new Object[]{traitName, guid, e});
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.BAD_REQUEST));
        }
        catch (Throwable e) {
            LOG.error("Unable to delete trait name={} for entity={}", new Object[]{traitName, guid, e});
            throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
        }
    }
}

