/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.resources;

import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.atlas.web.util.Servlets;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Path(value="admin")
@Singleton
public class AdminResource {
    private Response version;

    @GET
    @Path(value="stack")
    @Produces(value={"text/plain"})
    public String getThreadDump() {
        ThreadGroup topThreadGroup = Thread.currentThread().getThreadGroup();
        while (topThreadGroup.getParent() != null) {
            topThreadGroup = topThreadGroup.getParent();
        }
        Thread[] threads = new Thread[topThreadGroup.activeCount()];
        int nr = topThreadGroup.enumerate(threads);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < nr; ++i) {
            builder.append(threads[i].getName()).append("\nState: ").append((Object)threads[i].getState()).append("\n");
            String stackTrace = StringUtils.join((Object[])threads[i].getStackTrace(), (String)"\n");
            builder.append(stackTrace);
        }
        return builder.toString();
    }

    @GET
    @Path(value="version")
    @Produces(value={"application/json; charset=UTF-8"})
    public Response getVersion() {
        if (this.version == null) {
            try {
                PropertiesConfiguration configProperties = new PropertiesConfiguration("atlas-buildinfo.properties");
                JSONObject response = new JSONObject();
                response.put("Version", (Object)configProperties.getString("build.version", "UNKNOWN"));
                response.put("Name", (Object)configProperties.getString("project.name", "apache-atlas"));
                response.put("Description", (Object)configProperties.getString("project.description", "Metadata Management and Data Governance Platform over Hadoop"));
                this.version = Response.ok((Object)response).build();
            }
            catch (ConfigurationException | JSONException e) {
                throw new WebApplicationException(Servlets.getErrorResponse(e, Response.Status.INTERNAL_SERVER_ERROR));
            }
        }
        return this.version;
    }
}

