/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.listeners;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.atlas.AtlasException;
import org.apache.atlas.PropertiesUtil;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(LoginProcessor.class);
    public static final String METADATA_AUTHENTICATION_PREFIX = "atlas.authentication.";
    public static final String AUTHENTICATION_METHOD = "atlas.authentication.method";
    public static final String AUTHENTICATION_PRINCIPAL = "atlas.authentication.principal";
    public static final String AUTHENTICATION_KEYTAB = "atlas.authentication.keytab";

    public void login() {
        boolean isHadoopCluster = this.isHadoopCluster();
        Configuration hadoopConfig = isHadoopCluster ? this.getHadoopConfiguration() : new Configuration(false);
        PropertiesConfiguration configuration = null;
        try {
            configuration = this.getPropertiesConfiguration();
        }
        catch (ConfigurationException e) {
            LOG.warn("Error reading application configuration", (Throwable)e);
        }
        if (!isHadoopCluster) {
            this.setupHadoopConfiguration(hadoopConfig, configuration);
        }
        this.doServiceLogin(hadoopConfig, configuration);
    }

    protected void doServiceLogin(Configuration hadoopConfig, PropertiesConfiguration configuration) {
        UserGroupInformation.setConfiguration((Configuration)hadoopConfig);
        Object ugi = null;
        UserGroupInformation.AuthenticationMethod authenticationMethod = SecurityUtil.getAuthenticationMethod((Configuration)hadoopConfig);
        try {
            if (authenticationMethod == UserGroupInformation.AuthenticationMethod.SIMPLE) {
                UserGroupInformation.loginUserFromSubject(null);
            } else if (authenticationMethod == UserGroupInformation.AuthenticationMethod.KERBEROS) {
                String bindAddress = this.getHostname(configuration);
                UserGroupInformation.loginUserFromKeytab((String)this.getServerPrincipal(configuration.getString(AUTHENTICATION_PRINCIPAL), bindAddress), (String)configuration.getString(AUTHENTICATION_KEYTAB));
            }
            LOG.info("Logged in user {}", (Object)UserGroupInformation.getLoginUser());
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to perform %s login.", authenticationMethod), e);
        }
    }

    private String getHostname(PropertiesConfiguration configuration) {
        String bindAddress = configuration.getString("atlas.server.bind.address");
        if (bindAddress == null) {
            LOG.info("No host name configured.  Defaulting to local host name.");
            try {
                bindAddress = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException(e);
            }
        }
        return bindAddress;
    }

    protected void setupHadoopConfiguration(Configuration hadoopConfig, PropertiesConfiguration configuration) {
        String authMethod;
        String string = authMethod = configuration != null ? configuration.getString(AUTHENTICATION_METHOD) : null;
        if (authMethod == null) {
            LOG.info("No authentication method configured.  Defaulting to simple authentication");
            authMethod = "simple";
        }
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.valueOf((String)authMethod.toUpperCase()), (Configuration)hadoopConfig);
    }

    private String getServerPrincipal(String principal, String host) throws IOException {
        return SecurityUtil.getServerPrincipal((String)principal, (String)host);
    }

    protected Configuration getHadoopConfiguration() {
        return new Configuration();
    }

    protected PropertiesConfiguration getPropertiesConfiguration() throws ConfigurationException {
        try {
            return PropertiesUtil.getApplicationProperties();
        }
        catch (AtlasException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected boolean isHadoopCluster() {
        boolean isHadoopCluster = false;
        try {
            isHadoopCluster = Shell.getHadoopHome() != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isHadoopCluster;
    }
}

