/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.listeners;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceServletContextListener;
import com.sun.jersey.guice.JerseyServletModule;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import java.util.HashMap;
import javax.servlet.ServletContextEvent;
import org.apache.atlas.AtlasException;
import org.apache.atlas.PropertiesUtil;
import org.apache.atlas.RepositoryMetadataModule;
import org.apache.atlas.web.filters.AtlasAuthenticationFilter;
import org.apache.atlas.web.filters.AuditFilter;
import org.apache.atlas.web.listeners.LoginProcessor;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceServletConfig
extends GuiceServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(GuiceServletConfig.class);
    private static final String GUICE_CTX_PARAM = "guice.packages";
    static final String HTTP_AUTHENTICATION_ENABLED = "atlas.http.authentication.enabled";
    private Injector injector;

    protected Injector getInjector() {
        LOG.info("Loading Guice modules");
        if (this.injector == null) {
            this.injector = Guice.createInjector((Module[])new Module[]{new RepositoryMetadataModule(), new JerseyServletModule(){

                protected void configureServlets() {
                    this.filter("/*", new String[0]).through(AuditFilter.class);
                    try {
                        this.configureAuthenticationFilter();
                    }
                    catch (ConfigurationException e) {
                        LOG.warn("Unable to add and configure authentication filter", (Throwable)e);
                    }
                    String packages = this.getServletContext().getInitParameter(GuiceServletConfig.GUICE_CTX_PARAM);
                    LOG.info("Jersey loading from packages: " + packages);
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("com.sun.jersey.config.property.packages", packages);
                    this.serve("/api/atlas/*", new String[0]).with(GuiceContainer.class, params);
                }

                private void configureAuthenticationFilter() throws ConfigurationException {
                    try {
                        PropertiesConfiguration configuration = PropertiesUtil.getApplicationProperties();
                        if (Boolean.valueOf(configuration.getString(GuiceServletConfig.HTTP_AUTHENTICATION_ENABLED)).booleanValue()) {
                            this.filter("/*", new String[0]).through(AtlasAuthenticationFilter.class);
                        }
                    }
                    catch (AtlasException e) {
                        LOG.warn("Error loading configuration and initializing authentication filter", (Throwable)e);
                    }
                }
            }});
            LOG.info("Guice modules loaded");
        }
        return this.injector;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        super.contextInitialized(servletContextEvent);
        LoginProcessor loginProcessor = new LoginProcessor();
        loginProcessor.login();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        super.contextDestroyed(servletContextEvent);
    }
}

