/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.filters;

import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Date;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.atlas.web.util.DateTimeHelper;
import org.apache.atlas.web.util.Servlets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AuditFilter
implements Filter {
    private static final Logger AUDIT_LOG = LoggerFactory.getLogger((String)"AUDIT");
    private static final Logger LOG = LoggerFactory.getLogger(AuditFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        LOG.info("AuditFilter initialization started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String requestTimeISO9601 = DateTimeHelper.formatDateUTC(new Date());
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String requestId = UUID.randomUUID().toString();
        Thread currentThread = Thread.currentThread();
        String oldName = currentThread.getName();
        try {
            currentThread.setName(this.formatName(oldName, requestId));
            this.recordAudit(httpRequest, requestTimeISO9601);
            filterChain.doFilter(request, response);
        }
        finally {
            ((HttpServletResponse)response).setHeader("requestId", requestId);
            currentThread.setName(oldName);
        }
    }

    private String formatName(String oldName, String requestId) {
        return oldName + " - " + requestId;
    }

    private void recordAudit(HttpServletRequest httpRequest, String whenISO9601) {
        String who = this.getUserFromRequest(httpRequest);
        String fromHost = httpRequest.getRemoteHost();
        String fromAddress = httpRequest.getRemoteAddr();
        String whatRequest = httpRequest.getMethod();
        String whatURL = Servlets.getRequestURL(httpRequest);
        String whatAddrs = httpRequest.getLocalAddr();
        LOG.debug("Audit: {}/{} performed request {} {} ({}) at time {}", new Object[]{who, fromAddress, whatRequest, whatURL, whatAddrs, whenISO9601});
        this.audit(who, fromAddress, fromHost, whatURL, whatAddrs, whenISO9601);
    }

    private String getUserFromRequest(HttpServletRequest httpRequest) {
        String userFromRequest = Servlets.getUserFromRequest(httpRequest);
        return userFromRequest == null ? "UNKNOWN" : userFromRequest;
    }

    private void audit(String who, String fromAddress, String fromHost, String whatURL, String whatAddrs, String whenISO9601) {
        AUDIT_LOG.info("Audit: {}/{}-{} performed request {} ({}) at time {}", new Object[]{who, fromAddress, fromHost, whatURL, whatAddrs, whenISO9601});
    }

    public void destroy() {
    }
}

