/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.web.filters;

import com.google.inject.Singleton;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.atlas.PropertiesUtil;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AtlasAuthenticationFilter
extends AuthenticationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasAuthenticationFilter.class);
    static final String PREFIX = "atlas.http.authentication.";

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
        String principal;
        PropertiesConfiguration configuration;
        try {
            configuration = PropertiesUtil.getApplicationProperties();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        Properties config = new Properties();
        config.put("cookie.path", "/");
        Enumeration enumeration = filterConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            config.put(name, filterConfig.getInitParameter(name));
        }
        Iterator itor = configuration.getKeys();
        while (itor.hasNext()) {
            String name = (String)itor.next();
            if (!name.startsWith(PREFIX)) continue;
            String value = configuration.getString(name);
            name = name.substring(PREFIX.length());
            config.put(name, value);
        }
        String bindAddress = configuration.getString("atlas.server.bind.address");
        if (bindAddress == null) {
            LOG.info("No host name configured.  Defaulting to local host name.");
            try {
                bindAddress = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new ServletException("Unable to obtain host name", (Throwable)e);
            }
        }
        if ((principal = config.getProperty("kerberos.principal")) != null) {
            try {
                principal = SecurityUtil.getServerPrincipal((String)principal, (String)bindAddress);
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not resolve Kerberos principal name: " + ex.toString(), ex);
            }
            config.put("kerberos.principal", principal);
        }
        LOG.info("AuthenticationFilterConfig: {}", (Object)config);
        return config;
    }
}

